/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class BoatTypeRegistry {
    private static final Map<String, BoatTypeData> BOATS = (Map)Util.m_137469_((Object)Maps.newHashMap(), entries -> entries.put("minecraft:oak", new BoatTypeData(() -> Items.f_42453_, () -> Items.f_220207_, () -> Blocks.f_50705_, "minecraft:oak")));

    public static synchronized void registerBoat(String boatName, Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Block> plank) {
        BOATS.put(boatName, new BoatTypeData(boat, chestBoat, plank, boatName));
    }

    @Nullable
    public static BoatTypeData getTypeData(String boatName) {
        return BOATS.get(boatName);
    }

    public static String getNameForData(BoatTypeData data) {
        for (Map.Entry<String, BoatTypeData> entries : BOATS.entrySet()) {
            if (!entries.getValue().equals(data)) continue;
            return entries.getKey();
        }
        return BoatTypeRegistry.getBaseBoatName();
    }

    public static String getBaseBoatName() {
        return BOATS.size() > 1 ? (String)BOATS.keySet().toArray()[1] : "minecraft:oak";
    }

    public static class BoatTypeData {
        private final Supplier<Item> boat;
        private final Supplier<Item> chestBoat;
        private final Supplier<Block> plank;
        private final ResourceLocation texture;
        private final ResourceLocation chestVariantTexture;

        public BoatTypeData(Supplier<Item> boat, Supplier<Item> chestBoat, Supplier<Block> plank, String texture) {
            this.boat = boat;
            this.chestBoat = chestBoat;
            this.plank = plank;
            String modId = BoatTypeData.findModId(texture);
            String wood = BoatTypeData.findWood(texture);
            this.texture = new ResourceLocation(modId, "textures/entity/boat/" + wood + ".png");
            this.chestVariantTexture = new ResourceLocation(modId, "textures/entity/chest_boat/" + wood + ".png");
        }

        public Item getBoatItem() {
            return this.boat.get();
        }

        public Item getChestBoatItem() {
            return this.chestBoat.get();
        }

        public Item getPlankItem() {
            return this.plank.get().m_5456_();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getChestVariantTexture() {
            return this.chestVariantTexture;
        }

        private static String findModId(String parentString) {
            StringBuilder builder = new StringBuilder();
            for (char parentChars : parentString.toCharArray()) {
                if (parentChars == ':') break;
                builder.append(parentChars);
            }
            return builder.toString();
        }

        private static String findWood(String parentString) {
            StringBuilder builder = new StringBuilder();
            boolean start = false;
            for (char parentChars : parentString.toCharArray()) {
                if (start) {
                    builder.append(parentChars);
                }
                if (parentChars != ':') continue;
                start = true;
            }
            return builder.toString();
        }
    }
}

