/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.menu.MarketFakeSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.network.MarketSelectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class MarketClientMenu
extends MarketMenu {
    private final List<IMarketCategory> categoryList = Lists.newArrayList();
    private final List<IMarketEntry> itemList = Lists.newArrayList();
    private final List<IMarketEntry> filteredItems = Lists.newArrayList();
    private final Comparator<IMarketEntry> comparator = Comparator.comparingInt(o -> o.getCategory().getSortIndex());
    private String currentSearch;
    private IMarketCategory currentCategory;
    private boolean isDirty;
    private int scrollOffset;

    public MarketClientMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super(windowId, playerInventory, pos);
    }

    public void m_150399_(int slotNumber, int dragType, ClickType clickType, Player player) {
        if (slotNumber >= 0 && slotNumber < this.f_38839_.size()) {
            MarketFakeSlot marketSlot;
            IMarketEntry entry;
            Slot slot = (Slot)this.f_38839_.get(slotNumber);
            if (player.f_19853_.f_46443_ && slot instanceof MarketFakeSlot && (entry = (marketSlot = (MarketFakeSlot)slot).getEntry()) != null) {
                this.selectedEntry = entry;
                Balm.getNetworking().sendToServer((Object)new MarketSelectMessage(entry.getEntryId()));
            }
        }
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.applyFilters();
    }

    public void setFilterCategory(@Nullable IMarketCategory category) {
        this.currentCategory = category;
        this.applyFilters();
    }

    private void applyFilters() {
        boolean hasSearchFilter;
        this.scrollOffset = 0;
        this.filteredItems.clear();
        boolean bl = hasSearchFilter = this.currentSearch != null && !this.currentSearch.trim().isEmpty();
        if (this.currentCategory == null && !hasSearchFilter) {
            this.filteredItems.addAll(this.itemList);
        } else {
            for (IMarketEntry entry : this.itemList) {
                String itemName = entry.getOutputItem().m_41611_().getString();
                if (hasSearchFilter && !itemName.toLowerCase(Locale.ENGLISH).contains(this.currentSearch.toLowerCase()) || this.currentCategory != null && !this.currentCategory.passes(entry)) continue;
                this.filteredItems.add(entry);
            }
        }
        this.filteredItems.sort(this.comparator);
    }

    public int getFilteredListCount() {
        return this.filteredItems.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateMarketSlots();
    }

    public void populateMarketSlots() {
        int i = this.scrollOffset * 3;
        for (MarketFakeSlot slot : this.marketSlots) {
            if (i < this.filteredItems.size()) {
                slot.setEntry(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setEntry(null);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setCategoryList(Collection<IMarketCategory> categoryList) {
        this.categoryList.clear();
        this.categoryList.addAll(categoryList);
        this.setDirty(true);
    }

    public void setEntryList(Collection<IMarketEntry> entryList) {
        this.itemList.clear();
        this.itemList.addAll(entryList);
        this.applyFilters();
        this.populateMarketSlots();
        this.setDirty(true);
    }

    @Nullable
    public IMarketCategory getCurrentCategory() {
        return this.currentCategory;
    }

    public Collection<IMarketCategory> getCategories() {
        return this.categoryList;
    }
}

