/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item.rings;

import com.focamacho.ringsofascension.config.ConfigHolder;
import com.focamacho.ringsofascension.item.ItemRingBase;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemRingKnockbackResistance
extends ItemRingBase {
    private static final UUID KNOBACK_RESISTANCE_UUID = UUID.fromString("320d847e-eecd-402f-b6cf-d339d2fa97af");

    public ItemRingKnockbackResistance(Item.Properties properties, String tooltip) {
        super(properties, tooltip);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        HashMultimap modifiers = HashMultimap.create();
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).contains(identifier) && this.isEnabled()) {
            modifiers.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(KNOBACK_RESISTANCE_UUID, "Knockback Resistance", 1.0, AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    @Override
    public List<ResourceLocation> getLocations() {
        return super.getLocations(ConfigHolder.ringLocationKnockbackResistance);
    }

    @Override
    public boolean isEnabled() {
        return ConfigHolder.ringKnockbackResistance;
    }

    @Override
    public int getTier() {
        return ConfigHolder.ringTierKnockbackResistance;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!this.isEnabled()) {
            return;
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

