/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item;

import com.focamacho.ringsofascension.RingsOfAscension;
import com.focamacho.ringsofascension.init.ModItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class ItemRingBase
extends Item {
    protected String tooltip;
    private final List<ResourceLocation> locations = new ArrayList<ResourceLocation>();

    public ItemRingBase(Item.Properties properties, String tooltip) {
        super(properties.m_41491_(RingsOfAscension.tabGroup).m_41487_(1));
        this.tooltip = tooltip;
        ModItems.allRings.add(this);
    }

    public abstract boolean isEnabled();

    protected List<ResourceLocation> getLocations(String locations) {
        if (this.locations.isEmpty() && !locations.isEmpty()) {
            for (String location : locations.split(";")) {
                try {
                    String[] split = location.split(":");
                    this.locations.add(new ResourceLocation(split[0], split[1]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.locations;
    }

    public abstract List<ResourceLocation> getLocations();

    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
    }

    public Multimap<Attribute, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        HashMultimap modifiers = HashMultimap.create();
        return modifiers;
    }

    public void onEquippedCurio(String identifier, LivingEntity livingEntity) {
    }

    public void onUnequippedCurio(String identifier, LivingEntity livingEntity) {
    }

    public abstract int getTier();

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> lazyCurio = LazyOptional.of(() -> new ICurio(){

                public ItemStack getStack() {
                    return stack;
                }

                public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.tickCurio(identifier, index, livingEntity);
                }

                public void playRightClickEquipSound(LivingEntity livingEntity) {
                    livingEntity.f_19853_.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11676_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }

                public void onEquip(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.onEquippedCurio(identifier, livingEntity);
                }

                @Nonnull
                public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                    return ICurio.DropRule.DEFAULT;
                }

                public void onUnequip(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.onUnequippedCurio(identifier, livingEntity);
                }

                public boolean canRightClickEquip() {
                    return true;
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
                    return ItemRingBase.this.curioModifiers(stack, identifier);
                }
            });

            public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
                return CuriosCapability.ITEM.orEmpty(capability, this.lazyCurio);
            }
        };
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        switch (this.getTier()) {
            case 0: {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.ringsofascension.tier").getString() + " " + ChatFormatting.GREEN + Component.m_237115_((String)"tooltip.ringsofascension.tier.common").getString())));
                break;
            }
            case 1: {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.ringsofascension.tier").getString() + " " + ChatFormatting.BLUE + Component.m_237115_((String)"tooltip.ringsofascension.tier.rare").getString())));
                break;
            }
            case 2: {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.ringsofascension.tier").getString() + " " + ChatFormatting.LIGHT_PURPLE + Component.m_237115_((String)"tooltip.ringsofascension.tier.epic").getString())));
                break;
            }
            case 3: {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.ringsofascension.tier").getString() + " " + ChatFormatting.RED + Component.m_237115_((String)"tooltip.ringsofascension.tier.legendary").getString())));
                break;
            }
            case 4: {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.ringsofascension.tier").getString() + " " + ChatFormatting.DARK_RED + Component.m_237115_((String)"tooltip.ringsofascension.tier.mythic").getString())));
            }
        }
        if (this.tooltip == null) {
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.ringsofascension.worn").getString())));
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + Component.m_237115_((String)this.tooltip).getString())));
    }
}

