/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;

public class FollowEntity<E extends PathfinderMob, T extends Entity>
extends ExtendedBehaviour<E> {
    protected Function<E, T> followingEntityProvider = entity -> null;
    protected BiFunction<E, T, Double> teleportDistance = (entity, target) -> Double.MAX_VALUE;
    protected BiFunction<E, T, Double> followDistMin = (entity, target) -> 4.0;
    protected BiFunction<E, T, Float> speedMod = (entity, target) -> Float.valueOf(1.0f);
    protected float oldWaterPathMalus = 0.0f;
    protected float oldLavaPathMalus = 0.0f;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of();
    }

    public FollowEntity<E, T> following(Function<E, T> following) {
        this.followingEntityProvider = following;
        return this;
    }

    public FollowEntity<E, T> teleportToTargetAfter(double distance) {
        return this.teleportToTargetAfter((entity, target) -> distance);
    }

    public FollowEntity<E, T> teleportToTargetAfter(BiFunction<E, T, Double> distanceProvider) {
        this.teleportDistance = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> stopFollowingWithin(double distance) {
        return this.stopFollowingWithin((entity, target) -> distance);
    }

    public FollowEntity<E, T> stopFollowingWithin(BiFunction<E, T, Double> distanceProvider) {
        this.followDistMin = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> speedMod(float modifier) {
        return this.speedMod((entity, target) -> Float.valueOf(modifier));
    }

    public FollowEntity<E, T> speedMod(BiFunction<E, T, Float> modifier) {
        this.speedMod = modifier;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        if (target == null || target.m_5833_()) {
            return false;
        }
        double minDist = this.followDistMin.apply(entity, target);
        return entity.m_20280_(target) > minDist * minDist;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        double minDist;
        if (entity.m_21573_().m_26571_()) {
            return false;
        }
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        if (target == null) {
            return false;
        }
        double dist = entity.m_20280_(target);
        return dist > (minDist = this.followDistMin.apply(entity, target).doubleValue()) * minDist;
    }

    @Override
    protected void start(E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        double minDist = this.followDistMin.apply(entity, target);
        float speedMod = this.speedMod.apply(entity, target).floatValue();
        this.oldWaterPathMalus = entity.m_21439_(BlockPathTypes.WATER);
        if (entity.m_5825_()) {
            this.oldLavaPathMalus = entity.m_21439_(BlockPathTypes.LAVA);
            entity.m_21441_(BlockPathTypes.LAVA, 0.0f);
        }
        BrainUtils.setMemory(entity, MemoryModuleType.f_26370_, new WalkTarget(target, speedMod, (int)minDist));
        BrainUtils.setMemory(entity, MemoryModuleType.f_26371_, new EntityTracker(target, true));
        entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    protected void stop(E entity) {
        entity.m_21441_(BlockPathTypes.WATER, this.oldWaterPathMalus);
        if (entity.m_5825_()) {
            entity.m_21441_(BlockPathTypes.LAVA, this.oldLavaPathMalus);
        }
        entity.m_21573_().m_26573_();
        BrainUtils.clearMemory(entity, MemoryModuleType.f_26370_);
    }

    @Override
    protected void tick(E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        double teleportDist = this.teleportDistance.apply(entity, target);
        if (entity.m_20280_(target) >= teleportDist * teleportDist) {
            this.teleportToTarget(entity, target);
        }
    }

    protected void teleportToTarget(E entity, T target) {
        Level level = ((PathfinderMob)entity).f_19853_;
        BlockPos entityPos = target.m_20183_();
        BlockPos pos = RandomUtil.getRandomPositionWithinRange(entityPos, 5, 5, 5, 1, 1, 1, true, level, 10, (state, statePos) -> {
            BlockPathTypes pathTypes = entity.m_21573_().m_26575_().m_8086_((BlockGetter)level, statePos.m_123341_(), statePos.m_123342_(), statePos.m_123343_());
            if (pathTypes != BlockPathTypes.WALKABLE) {
                return false;
            }
            return level.m_45756_((Entity)entity, entity.m_20191_().m_82338_(statePos.m_121996_((Vec3i)entityPos)));
        });
        if (pos != entityPos) {
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
            entity.m_21573_().m_26573_();
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26370_);
        }
    }
}

