/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;

public class PacketChestplateLauncher {
    private static final float SCALE_FACTOR = 0.7f;
    private final float amount;

    public PacketChestplateLauncher(float amount) {
        this.amount = amount;
    }

    PacketChestplateLauncher(FriendlyByteBuf buffer) {
        this.amount = buffer.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.amount);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handleLaunch(((NetworkEvent.Context)ctx.get()).getSender()));
        ctx.get().setPacketHandled(true);
    }

    private void handleLaunch(ServerPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21206_();
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)player);
        if (handler.upgradeUsable(CommonUpgradeHandlers.chestplateLauncherHandler, false) && !stack.m_41619_() && !player.m_36335_().m_41519_(stack.m_41720_())) {
            ItemStack toFire = stack;
            if (stack.m_41720_() != ModItems.MICROMISSILES.get()) {
                toFire = player.m_7500_() ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1) : stack.m_41620_(1);
            }
            Entity launchedEntity = ItemLaunching.getEntityToLaunch(player.m_20193_(), toFire, (Player)player, true, true);
            int upgrades = handler.getUpgradeCount(EquipmentSlot.CHEST, (PNCUpgrade)ModUpgrades.DISPENSER.get(), 4);
            Vec3 velocity = player.m_20154_().m_82541_().m_82490_((double)(this.amount * (float)upgrades * 0.7f));
            if (launchedEntity instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)launchedEntity;
                arrow.f_36705_ = player.m_7500_() ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                arrow.m_36781_(arrow.m_36789_() + 0.25 * (double)upgrades * (double)this.amount);
            }
            ItemLaunching.launchEntity(launchedEntity, player.m_20299_(1.0f).m_82520_(0.0, -0.1, 0.0), velocity, true);
            if (!player.m_7500_()) {
                int usedAir = (int)((float)(20 * upgrades) * this.amount);
                handler.addAir(EquipmentSlot.CHEST, -usedAir);
            }
        }
    }
}

