/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PressurizableItem
extends Item
implements IPressurizableItem,
Vanishable {
    private final int volume;
    private final float maxPressure;

    public PressurizableItem(Item.Properties props, int maxAir, int volume) {
        super(props);
        this.volume = volume;
        this.maxPressure = (float)maxAir / (float)volume;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_142522_(ItemStack pStack) {
        return PressurizableItem.shouldShowPressureDurability(pStack);
    }

    public int m_142158_(ItemStack pStack) {
        return pStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> Math.round(h.getPressure() / h.maxPressure() * 13.0f)).orElse(0);
    }

    public int m_142159_(ItemStack pStack) {
        return PressurizableItem.getPressureDurabilityColor(pStack);
    }

    static int getPressureDurabilityColor(ItemStack stack) {
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            int c = (int)(64.0f + 191.0f * f);
            return 0x400000 | c << 8 | 0xFF;
        }).orElse(0xC0C0C0);
    }

    static boolean shouldShowPressureDurability(ItemStack stack) {
        return stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(airHandler -> airHandler.getPressure() < airHandler.maxPressure()).orElse(false);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
            ItemStack stack = new ItemStack((ItemLike)this);
            new AirHandlerItemStack(stack, this.maxPressure).addAir((int)((float)this.volume * this.maxPressure));
            items.add((Object)stack);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return stack.m_41720_() instanceof PressurizableItem ? new AirHandlerItemStack(stack, this.maxPressure) : super.initCapabilities(stack, nbt);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return (Boolean)ConfigHelper.common().advanced.nbtToClientModification.get() != false ? PressurizableItem.roundedPressure(stack) : super.getShareTag(stack);
    }

    @Override
    public int getBaseVolume() {
        return this.volume;
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, (PNCUpgrade)ModUpgrades.VOLUME.get());
    }

    @Override
    public int getAir(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("pneumaticcraft:air") : 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 9;
    }

    public static CompoundTag roundedPressure(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IPressurizableItem) {
            IPressurizableItem p = (IPressurizableItem)item;
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("pneumaticcraft:air")) {
                ItemStack stackCopy = stack.m_41777_();
                CompoundTag tag = Objects.requireNonNull(stackCopy.m_41783_());
                int air = tag.m_128451_("pneumaticcraft:air");
                int volume = p.getEffectiveVolume(stackCopy);
                tag.m_128405_("pneumaticcraft:air", air - air % (volume / (Integer)ConfigHelper.common().advanced.pressureSyncPrecision.get()));
                return tag;
            }
        }
        return stack.m_41783_();
    }
}

