/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ProgrammerMenu
extends AbstractPneumaticCraftMenu<ProgrammerBlockEntity> {
    private final boolean hiRes;

    public ProgrammerMenu(int i, Inventory playerInventory, BlockPos pos) {
        super((MenuType)ModMenuTypes.PROGRAMMER.get(), i, playerInventory, pos);
        this.hiRes = playerInventory.f_35978_.f_19853_.f_46443_ && ClientUtils.isScreenHiRes();
        int xBase = this.hiRes ? 270 : 95;
        int yBase = this.hiRes ? 430 : 174;
        this.m_38897_((Slot)new SlotItemHandler(((ProgrammerBlockEntity)this.te).getPrimaryInventory(), 0, this.hiRes ? 676 : 326, 15){

            public boolean m_5857_(@Nonnull ItemStack stack) {
                return ProgrammerMenu.isProgrammableItem(stack);
            }
        });
        this.addPlayerSlots(playerInventory, xBase, yBase);
    }

    public ProgrammerMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, ProgrammerMenu.getTilePos(buffer));
    }

    public boolean isHiRes() {
        return this.hiRes;
    }

    private static boolean isProgrammableItem(@Nonnull ItemStack stack) {
        return stack.m_41720_() instanceof IProgrammable && ((IProgrammable)stack.m_41720_()).canProgram(stack);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (((ProgrammerBlockEntity)this.te).nonNullLevel().m_46467_() % 20L == 0L) {
            for (Direction d : DirectionUtil.VALUES) {
                BlockEntity neighbor = ((ProgrammerBlockEntity)this.te).getCachedNeighbor(d);
                if (neighbor == null || !neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, d.m_122424_()).isPresent()) continue;
                ProgrammerMenu self = this;
                List<ServerPlayer> players = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().stream().filter(p -> p.f_36096_ == self).toList();
                if (players.isEmpty()) continue;
                players.forEach(p -> NetworkHandler.sendToPlayer(new PacketSendNBTPacket(neighbor), p));
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(Player par1EntityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot srcSlot = (Slot)this.f_38839_.get(slotIndex);
        if (srcSlot != null && srcSlot.m_6657_()) {
            ItemStack stackInSlot = srcSlot.m_7993_();
            stack = stackInSlot.m_41777_();
            if (slotIndex == 0) {
                if (!this.m_38903_(stackInSlot, 1, 36, false)) {
                    return ItemStack.f_41583_;
                }
                srcSlot.m_40234_(stackInSlot, stack);
            } else if (ProgrammerMenu.isProgrammableItem(stack)) {
                if (!this.m_38903_(stackInSlot, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                srcSlot.m_40234_(stackInSlot, stack);
            }
            if (stackInSlot.m_41619_()) {
                srcSlot.m_5852_(ItemStack.f_41583_);
            } else {
                srcSlot.m_6654_();
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            srcSlot.m_142406_(par1EntityPlayer, stackInSlot);
        }
        return stack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (playerIn.f_19853_.f_46443_) {
            ProgrammerScreen.onCloseFromContainer();
        }
    }
}

