/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.IHasBoundingBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPNCBlockWithBoundingBlocks
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    public static final BooleanProperty BOUNDING = BooleanProperty.m_61465_((String)"bounding");

    public AbstractPNCBlockWithBoundingBlocks(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BOUNDING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return ALMOST_FULL_SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.m_5940_(state, world, pos, context);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BOUNDING});
    }

    @Nullable
    public abstract BlockEntity m_142194_(@NotNull BlockPos var1, @NotNull BlockState var2);

    @Nonnull
    public abstract Vec3i[] getBoundingBlockOffsets();

    public BlockPos getMainPos(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue() && (blockEntity = world.m_7702_(pos)) instanceof IHasBoundingBlocks) {
            IHasBoundingBlocks bounding = (IHasBoundingBlocks)blockEntity;
            return pos.m_121996_(bounding.getOffsetFromMain());
        }
        return pos;
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        IHasBoundingBlocks blockEntity;
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            return world.m_8055_(this.getMainPos(state, world, pos)).m_60734_() == state.m_60734_();
        }
        Vec3i[] vec3iArray = world.m_7702_(pos);
        if (vec3iArray instanceof IHasBoundingBlocks && (blockEntity = (IHasBoundingBlocks)vec3iArray).getBoundingPlaced()) {
            for (Vec3i offset : this.getBoundingBlockOffsets()) {
                if (!world.m_46859_(pos.m_121955_(offset))) continue;
                return false;
            }
        } else {
            for (Vec3i offset : this.getBoundingBlockOffsets()) {
                if (world.m_46859_(pos.m_121955_(offset))) continue;
                return false;
            }
        }
        return true;
    }

    public void removeBoundingBlocks(BlockState state, Level level, BlockPos mainPos, @Nullable Player player) {
        Object blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(mainPos);
        if (blockEntity2 instanceof IHasBoundingBlocks) {
            blockEntity = (Vec3i[])blockEntity2;
            blockEntity.setMainBlockRemovalLock(true);
        }
        for (Vec3i offset : this.getBoundingBlockOffsets()) {
            BlockPos offsetPos = mainPos.m_121955_(offset);
            if (level.m_8055_(offsetPos).m_60734_() != this) continue;
            if (player != null) {
                this.m_142387_(level, player, offsetPos, state);
            }
            level.m_7471_(offsetPos, false);
        }
        BlockEntity blockEntity3 = level.m_7702_(mainPos);
        if (blockEntity3 instanceof IHasBoundingBlocks) {
            blockEntity = (IHasBoundingBlocks)blockEntity3;
            blockEntity.setBoundingRemoved(true);
            blockEntity.setMainBlockRemovalLock(false);
        }
    }

    public void placeBoundingBlocks(Level level, BlockPos mainPos) {
        for (Vec3i offset : this.getBoundingBlockOffsets()) {
            level.m_7731_(mainPos.m_121955_(offset), (BlockState)level.m_8055_(mainPos).m_61124_((Property)BOUNDING, (Comparable)Boolean.valueOf(true)), 3);
            BlockEntity blockEntity = level.m_7702_(mainPos.m_121955_(offset));
            if (!(blockEntity instanceof IHasBoundingBlocks)) continue;
            IHasBoundingBlocks blockEntity2 = (IHasBoundingBlocks)blockEntity;
            blockEntity2.setOffsetFromMain(offset);
        }
        BlockEntity blockEntity = level.m_7702_(mainPos);
        if (blockEntity instanceof IHasBoundingBlocks) {
            IHasBoundingBlocks blockEntity3 = (IHasBoundingBlocks)blockEntity;
            blockEntity3.setBoundingPlaced(true);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockPos mainPos = this.getMainPos(state, (LevelReader)level, pos);
        BlockState mainBlockState = level.m_8055_(mainPos);
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            this.onDestroyedByPlayer(mainBlockState, level, mainPos, player, willHarvest, mainBlockState.m_60819_());
            return false;
        }
        this.removeBoundingBlocks(state, level, pos, player);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public void setRotation(Level world, BlockPos pos, Direction rotation) {
        BlockEntity blockEntity;
        if (!((Boolean)world.m_8055_(pos).m_61143_((Property)BOUNDING)).booleanValue() && (blockEntity = world.m_7702_(pos)) instanceof IHasBoundingBlocks) {
            IHasBoundingBlocks blockEntity2 = (IHasBoundingBlocks)blockEntity;
            blockEntity2.setMainBlockRemovalLock(true);
            super.setRotation(world, pos, rotation);
            blockEntity2.setMainBlockRemovalLock(false);
        }
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        BlockState state = world.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            return this.onWrenched(world, player, this.getMainPos(state, (LevelReader)world, pos), face, hand);
        }
        if (player != null && player.m_6144_()) {
            this.removeBoundingBlocks(state, world, pos, null);
        }
        return super.onWrenched(world, player, pos, face, hand);
    }

    public void m_6807_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!((Boolean)pState.m_61143_((Property)BOUNDING)).booleanValue()) {
            this.placeBoundingBlocks(pLevel, pPos);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IHasBoundingBlocks blockEntity;
        BlockEntity blockEntity2;
        if (!((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue() && (blockEntity2 = world.m_7702_(pos)) instanceof IHasBoundingBlocks && !(blockEntity = (IHasBoundingBlocks)blockEntity2).getBoundingRemoved()) {
            this.removeBoundingBlocks(state, world, pos, null);
        } else {
            IHasBoundingBlocks blockEntity3;
            blockEntity2 = world.m_7702_(this.getMainPos(state, (LevelReader)world, pos));
            if (blockEntity2 instanceof IHasBoundingBlocks && !(blockEntity3 = (IHasBoundingBlocks)blockEntity2).getMainBlockRemovalLock()) {
                world.m_7471_(this.getMainPos(state, (LevelReader)world, pos), false);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (((Boolean)state.m_61143_((Property)BOUNDING)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(state, world, pos, player, hand, brtr);
    }
}

