/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.jerintegration;

import fr.alasdiablo.jerintegration.compat.CompatibilityHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="jerintegration")
public class JERIntegration {
    public static final String MOD_ID = "jerintegration";
    public static final Logger LOGGER = LogManager.getLogger((String)"jerintegration");
    private static final ModList MOD_LIST = ModList.get();

    public JERIntegration() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DisableConfig.CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent commonSetupEvent) {
        CompatibilityHandler.init();
    }

    public static class DisableConfig {
        public static final ForgeConfigSpec CONFIG_SPEC;
        public static final Config CONFIG;

        static {
            Pair configPair = new ForgeConfigSpec.Builder().configure(Config::new);
            CONFIG_SPEC = (ForgeConfigSpec)configPair.getRight();
            CONFIG = (Config)configPair.getLeft();
        }

        public static class Config {
            public final ForgeConfigSpec.BooleanValue RANDOMITE;
            public final ForgeConfigSpec.BooleanValue CREATE;
            public final ForgeConfigSpec.BooleanValue IMMERSIVE_ENGINEERING;
            public final ForgeConfigSpec.BooleanValue TINKERS_CONSTRUCT;
            public final ForgeConfigSpec.BooleanValue MEKANISM;

            public Config(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ForgeConfigSpec.Builder builder) {
                builder.comment("Jer Integration override options").push("jer-integration");
                this.RANDOMITE = builder.comment("Enable / Disable patch for Randomite Classic").define("randomite", true);
                this.CREATE = builder.comment("Enable / Disable patch for Create").define("create", true);
                this.IMMERSIVE_ENGINEERING = builder.comment("Enable / Disable patch for Immersive Engineering").define("immersiveengineering", true);
                this.TINKERS_CONSTRUCT = builder.comment("Enable / Disable patch for Tinkers' Construct").define("tconstruct", true);
                this.MEKANISM = builder.comment("Enable / Disable patch for Mekanism").define("mekanism", true);
            }
        }
    }

    public static class Compat {
        public static boolean RANDOMITE = MOD_LIST.isLoaded("randomite");
        public static boolean CREATE = MOD_LIST.isLoaded("create");
        public static boolean IMMERSIVE_ENGINEERING = MOD_LIST.isLoaded("immersiveengineering");
        public static boolean TINKERS_CONSTRUCT = MOD_LIST.isLoaded("tconstruct");
        public static boolean MEKANISM = MOD_LIST.isLoaded("mekanism");
    }
}

