/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.eemekanismaddon;

import com.google.common.collect.Lists;
import com.ridanisaurus.eemekanismaddon.EEMekanismRegistrar;
import com.ridanisaurus.eemekanismaddon.EEMekanismTags;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EEItemModelProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EELangProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.EETagProvider;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import com.ridanisaurus.emendatusenigmatica.datagen.base.ItemModelBuilder;
import com.ridanisaurus.emendatusenigmatica.datagen.base.TagBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.datagen.recipe.builder.ChemicalCrystallizerRecipeBuilder;
import mekanism.api.datagen.recipe.builder.ChemicalDissolutionRecipeBuilder;
import mekanism.api.datagen.recipe.builder.FluidSlurryToSlurryRecipeBuilder;
import mekanism.api.datagen.recipe.builder.ItemStackChemicalToItemStackRecipeBuilder;
import mekanism.api.datagen.recipe.builder.ItemStackToChemicalRecipeBuilder;
import mekanism.api.datagen.recipe.builder.ItemStackToItemStackRecipeBuilder;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class EEMekanismDataGen {
    private static final Gas SULFURIC_ACID = Gas.getFromRegistry((ResourceLocation)new ResourceLocation("mekanism", "sulfuric_acid"));
    private static final Gas HYDROGEN_CHLORIDE = Gas.getFromRegistry((ResourceLocation)new ResourceLocation("mekanism", "hydrogen_chloride"));
    private static final Gas OXYGEN = Gas.getFromRegistry((ResourceLocation)new ResourceLocation("mekanism", "oxygen"));

    public static class Lang
    extends EELangProvider {
        private final EmendatusDataRegistry registry;

        public Lang(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen, "ee_mekanism_addon", "en_us");
            this.registry = registry;
        }

        protected void addTranslations() {
            for (MaterialModel material : this.registry.getMaterials()) {
                StringBuilder sb2;
                StringBuilder sb;
                List processedType = material.getProcessedTypes();
                if (processedType.contains("slurry")) {
                    sb = new StringBuilder();
                    sb.append("Dirty ");
                    sb.append(material.getLocalizedName());
                    sb.append(" Slurry");
                    this.add(((Slurry)EEMekanismRegistrar.dirtySlurryMap.get(material.getId()).get()).getTranslationKey(), sb.toString());
                    sb2 = new StringBuilder();
                    sb2.append("Clean ");
                    sb2.append(material.getLocalizedName());
                    sb2.append(" Slurry");
                    this.add(((Slurry)EEMekanismRegistrar.cleanSlurryMap.get(material.getId()).get()).getTranslationKey(), sb2.toString());
                }
                if (processedType.contains("crystal")) {
                    sb = new StringBuilder();
                    sb.append(material.getLocalizedName());
                    sb.append(" Crystal");
                    this.add((Item)EEMekanismRegistrar.crystalMap.get(material.getId()).get(), sb.toString());
                }
                if (processedType.contains("shard")) {
                    sb = new StringBuilder();
                    sb.append(material.getLocalizedName());
                    sb.append(" Shard");
                    this.add((Item)EEMekanismRegistrar.shardMap.get(material.getId()).get(), sb.toString());
                }
                if (processedType.contains("clump")) {
                    sb = new StringBuilder();
                    sb.append(material.getLocalizedName());
                    sb.append(" Clump");
                    this.add((Item)EEMekanismRegistrar.clumpMap.get(material.getId()).get(), sb.toString());
                }
                if (processedType.contains("dirty_dust")) {
                    sb = new StringBuilder();
                    sb.append("Dirty ");
                    sb.append(material.getLocalizedName());
                    sb.append(" Dust");
                    this.add((Item)EEMekanismRegistrar.dirtyDustMap.get(material.getId()).get(), sb.toString());
                }
                if (processedType.contains("gas")) {
                    sb = new StringBuilder();
                    sb.append("Gaseous ");
                    sb.append(material.getLocalizedName());
                    this.add(((Gas)EEMekanismRegistrar.gasMap.get(material.getId()).get()).getTranslationKey(), sb.toString());
                }
                if (!processedType.contains("infuse_type")) continue;
                sb = new StringBuilder();
                sb.append(material.getLocalizedName());
                this.add(((InfuseType)EEMekanismRegistrar.infuseMap.get(material.getId()).get()).getTranslationKey(), sb.toString());
                sb2 = new StringBuilder();
                sb2.append("Enriched ");
                sb2.append(material.getLocalizedName());
                this.add((Item)EEMekanismRegistrar.enrichedMap.get(material.getId()).get(), sb2.toString());
            }
        }

        public String m_6055_() {
            return "EE Mekanism Addon Languages: en_us";
        }
    }

    public static class InfuseTypeTags
    extends EETagProvider {
        private final EmendatusDataRegistry registry;
        private final List<String> mekanismInfuseType = Lists.newArrayList();

        public InfuseTypeTags(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen);
            this.registry = registry;
        }

        protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                List processedType = material.getProcessedTypes();
                if (!processedType.contains("infuse_type")) continue;
                ResourceLocation infuseType = EEMekanismRegistrar.infuseMap.get(material.getId()).getId();
                this.mekanismInfuseType.add(infuseType.toString());
            }
            if (!this.mekanismInfuseType.isEmpty()) {
                new TagBuilder().tags(this.mekanismInfuseType).save(consumer, new ResourceLocation("mekanism", "/mekanism/infuse_type"));
            }
        }

        public String m_6055_() {
            return "EE Mekanism Addon Infuse Type Tags";
        }
    }

    public static class SlurryTags
    extends EETagProvider {
        private final EmendatusDataRegistry registry;
        private final List<String> mekanismCleanSlurry = Lists.newArrayList();
        private final List<String> mekanismDirtySlurry = Lists.newArrayList();

        public SlurryTags(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen);
            this.registry = registry;
        }

        protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                List processedType = material.getProcessedTypes();
                if (!processedType.contains("slurry")) continue;
                ResourceLocation cleanSlurry = EEMekanismRegistrar.cleanSlurryMap.get(material.getId()).getId();
                this.mekanismCleanSlurry.add(cleanSlurry.toString());
                ResourceLocation dirtySlurry = EEMekanismRegistrar.dirtySlurryMap.get(material.getId()).getId();
                this.mekanismDirtySlurry.add(dirtySlurry.toString());
            }
            if (!this.mekanismCleanSlurry.isEmpty()) {
                new TagBuilder().tags(this.mekanismCleanSlurry).save(consumer, new ResourceLocation("mekanism", "/mekanism/clean"));
            }
            if (!this.mekanismDirtySlurry.isEmpty()) {
                new TagBuilder().tags(this.mekanismDirtySlurry).save(consumer, new ResourceLocation("mekanism", "/mekanism/dirty"));
            }
        }

        public String m_6055_() {
            return "EE Mekanism Addon Slurry Tags";
        }
    }

    public static class ItemTags
    extends EETagProvider {
        private final EmendatusDataRegistry registry;
        private final List<String> mekanismCrystals = Lists.newArrayList();
        private final List<String> mekanismShards = Lists.newArrayList();
        private final List<String> mekanismClumps = Lists.newArrayList();
        private final List<String> mekanismDirtyDusts = Lists.newArrayList();
        private final List<String> mekanismEnriched = Lists.newArrayList();

        public ItemTags(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen);
            this.registry = registry;
        }

        protected void buildTags(Consumer<IFinishedGenericJSON> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                List processedType = material.getProcessedTypes();
                if (processedType.contains("crystal")) {
                    ResourceLocation crystal = EEMekanismRegistrar.crystalMap.get(material.getId()).getId();
                    if (!this.mekanismCrystals.contains("#mekanism:crystals/" + material.getId())) {
                        this.mekanismCrystals.add("#mekanism:crystals/" + material.getId());
                    }
                    new TagBuilder().tag(crystal.toString()).save(consumer, new ResourceLocation("mekanism", "/items/crystals/" + material.getId()));
                }
                if (processedType.contains("shard")) {
                    ResourceLocation shard = EEMekanismRegistrar.shardMap.get(material.getId()).getId();
                    if (!this.mekanismShards.contains("#mekanism:shards/" + material.getId())) {
                        this.mekanismShards.add("#mekanism:shards/" + material.getId());
                    }
                    new TagBuilder().tag(shard.toString()).save(consumer, new ResourceLocation("mekanism", "/items/shards/" + material.getId()));
                }
                if (processedType.contains("clump")) {
                    ResourceLocation clump = EEMekanismRegistrar.clumpMap.get(material.getId()).getId();
                    if (!this.mekanismClumps.contains("#mekanism:clumps/" + material.getId())) {
                        this.mekanismClumps.add("#mekanism:clumps/" + material.getId());
                    }
                    new TagBuilder().tag(clump.toString()).save(consumer, new ResourceLocation("mekanism", "/items/clumps/" + material.getId()));
                }
                if (processedType.contains("dirty_dust")) {
                    ResourceLocation dirtyDust = EEMekanismRegistrar.dirtyDustMap.get(material.getId()).getId();
                    if (!this.mekanismDirtyDusts.contains("#mekanism:dirty_dusts/" + material.getId())) {
                        this.mekanismDirtyDusts.add("#mekanism:dirty_dusts/" + material.getId());
                    }
                    new TagBuilder().tag(dirtyDust.toString()).save(consumer, new ResourceLocation("mekanism", "/items/dirty_dusts/" + material.getId()));
                }
                if (!processedType.contains("infuse_type")) continue;
                ResourceLocation enriched = EEMekanismRegistrar.enrichedMap.get(material.getId()).getId();
                if (!this.mekanismEnriched.contains("#mekanism:enriched/" + material.getId())) {
                    this.mekanismEnriched.add("#mekanism:enriched/" + material.getId());
                }
                new TagBuilder().tag(enriched.toString()).save(consumer, new ResourceLocation("mekanism", "/items/enriched/" + material.getId()));
            }
            if (!this.mekanismCrystals.isEmpty()) {
                new TagBuilder().tags(this.mekanismCrystals).save(consumer, new ResourceLocation("mekanism", "/items/crystals"));
            }
            if (!this.mekanismShards.isEmpty()) {
                new TagBuilder().tags(this.mekanismShards).save(consumer, new ResourceLocation("mekanism", "/items/shards"));
            }
            if (!this.mekanismClumps.isEmpty()) {
                new TagBuilder().tags(this.mekanismClumps).save(consumer, new ResourceLocation("mekanism", "/items/clumps"));
            }
            if (!this.mekanismDirtyDusts.isEmpty()) {
                new TagBuilder().tags(this.mekanismDirtyDusts).save(consumer, new ResourceLocation("mekanism", "/items/dirty_dusts"));
            }
            if (!this.mekanismEnriched.isEmpty()) {
                new TagBuilder().tags(this.mekanismEnriched).save(consumer, new ResourceLocation("mekanism", "/items/enriched"));
            }
        }

        public String m_6055_() {
            return "EE Mekanism Addon Item Tags";
        }
    }

    public static class ItemModels
    extends EEItemModelProvider {
        private final EmendatusDataRegistry registry;

        public ItemModels(DataGenerator generator, EmendatusDataRegistry registry) {
            super(generator);
            this.registry = registry;
        }

        protected void buildItemModels(Consumer<IFinishedGenericJSON> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                List processedType = material.getProcessedTypes();
                if (processedType.contains("crystal")) {
                    ItemModelBuilder crystalBuilder = new ItemModelBuilder("minecraft:item/generated");
                    if (material.getColors().getMaterialColor() == -1) {
                        crystalBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_crystal").toString());
                    } else {
                        crystalBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/crystal/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/crystal/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/crystal/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/crystal/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/crystal/04").toString());
                    }
                    crystalBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_crystal"));
                }
                if (processedType.contains("shard")) {
                    ItemModelBuilder shardBuilder = new ItemModelBuilder("minecraft:item/generated");
                    if (material.getColors().getMaterialColor() == -1) {
                        shardBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_shard").toString());
                    } else {
                        shardBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/shard/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/shard/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/shard/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/shard/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/shard/04").toString());
                    }
                    shardBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_shard"));
                }
                if (processedType.contains("clump")) {
                    ItemModelBuilder clumpBuilder = new ItemModelBuilder("minecraft:item/generated");
                    if (material.getColors().getMaterialColor() == -1) {
                        clumpBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_clump").toString());
                    } else {
                        clumpBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/clump/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/clump/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/clump/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/clump/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/clump/04").toString());
                    }
                    clumpBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_clump"));
                }
                if (processedType.contains("dirty_dust")) {
                    ItemModelBuilder dirtyDustBuilder = new ItemModelBuilder("minecraft:item/generated");
                    if (material.getColors().getMaterialColor() == -1) {
                        dirtyDustBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/" + material.getId() + "_dirty_dust").toString());
                    } else {
                        dirtyDustBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/dirty_dust/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/dirty_dust/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/dirty_dust/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/dirty_dust/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/dirty_dust/04").toString());
                    }
                    dirtyDustBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", material.getId() + "_dirty_dust"));
                }
                if (!processedType.contains("infuse_type")) continue;
                ItemModelBuilder enrichedBuilder = new ItemModelBuilder("minecraft:item/generated");
                if (material.getColors().getMaterialColor() == -1) {
                    enrichedBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/enriched_" + material.getId()).toString());
                } else {
                    enrichedBuilder.texture("layer0", new ResourceLocation("emendatusenigmatica", "items/templates/enriched/00").toString()).texture("layer1", new ResourceLocation("emendatusenigmatica", "items/templates/enriched/01").toString()).texture("layer2", new ResourceLocation("emendatusenigmatica", "items/templates/enriched/02").toString()).texture("layer3", new ResourceLocation("emendatusenigmatica", "items/templates/enriched/03").toString()).texture("layer4", new ResourceLocation("emendatusenigmatica", "items/templates/enriched/04").toString());
                }
                enrichedBuilder.save(consumer, new ResourceLocation("emendatusenigmatica", "enriched_" + material.getId()));
            }
        }

        public String m_6055_() {
            return "EE Mekanism Addon Item Models";
        }
    }

    public static class Recipes
    extends RecipeProvider {
        private final EmendatusDataRegistry registry;

        public Recipes(DataGenerator gen, EmendatusDataRegistry registry) {
            super(gen);
            this.registry = registry;
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            for (MaterialModel material : this.registry.getMaterials()) {
                if (!material.getCompat().getMeknaismCompat()) continue;
                List processedType = material.getProcessedTypes();
                if (processedType.contains("slurry")) {
                    if (processedType.contains("ore")) {
                        ChemicalDissolutionRecipeBuilder.dissolution((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_ORE.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)SULFURIC_ACID, 1)), (ChemicalStack)((Slurry)EEMekanismRegistrar.dirtySlurryMap.get(material.getId()).get()).getStack(1000L)).build(consumer, new ResourceLocation("emendatusenigmatica", "slurry/dirty/from_ore/" + material.getId()));
                    }
                    if (processedType.contains("raw")) {
                        ChemicalDissolutionRecipeBuilder.dissolution((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_RAW.apply(material.getId()), 3), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)SULFURIC_ACID, 1)), (ChemicalStack)((Slurry)EEMekanismRegistrar.dirtySlurryMap.get(material.getId()).get()).getStack(2000L)).build(consumer, new ResourceLocation("emendatusenigmatica", "slurry/dirty/from_raw/" + material.getId()));
                        ChemicalDissolutionRecipeBuilder.dissolution((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_RAW_STORAGE_BLOCK.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)SULFURIC_ACID, 2)), (ChemicalStack)((Slurry)EEMekanismRegistrar.dirtySlurryMap.get(material.getId()).get()).getStack(6000L)).build(consumer, new ResourceLocation("emendatusenigmatica", "slurry/dirty/from_raw_block/" + material.getId()));
                    }
                    FluidSlurryToSlurryRecipeBuilder.washing((FluidStackIngredient)((FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidTags.f_13131_, 5)), (ChemicalStackIngredient.SlurryStackIngredient)((ChemicalStackIngredient.SlurryStackIngredient)IngredientCreatorAccess.slurry().from((Chemical)((Slurry)EEMekanismRegistrar.dirtySlurryMap.get(material.getId()).get()), 1)), (SlurryStack)((Slurry)EEMekanismRegistrar.cleanSlurryMap.get(material.getId()).get()).getStack(1L)).build(consumer, new ResourceLocation("emendatusenigmatica", "slurry/clean/" + material.getId()));
                }
                if (processedType.contains("crystal") && processedType.contains("slurry")) {
                    ChemicalCrystallizerRecipeBuilder.crystallizing((ChemicalStackIngredient)IngredientCreatorAccess.slurry().from((Chemical)((Slurry)EEMekanismRegistrar.cleanSlurryMap.get(material.getId()).get()), 200), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.crystalMap.get(material.getId()).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "crystal/from_slurry/" + material.getId()));
                }
                if (processedType.contains("shard")) {
                    if (processedType.contains("crystal")) {
                        ItemStackChemicalToItemStackRecipeBuilder.injecting((ItemStackIngredient)IngredientCreatorAccess.item().from(EEMekanismTags.MATERIAL_CRYSTAL.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)HYDROGEN_CHLORIDE, 1)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.shardMap.get(material.getId()).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "shard/from_crystal/" + material.getId()));
                    }
                    if (processedType.contains("ore")) {
                        ItemStackChemicalToItemStackRecipeBuilder.injecting((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_ORE.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)HYDROGEN_CHLORIDE, 1)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.shardMap.get(material.getId()).get(), 4)).build(consumer, new ResourceLocation("emendatusenigmatica", "shard/from_ore/" + material.getId()));
                    }
                    if (processedType.contains("raw")) {
                        ItemStackChemicalToItemStackRecipeBuilder.injecting((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_RAW.apply(material.getId()), 3), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)HYDROGEN_CHLORIDE, 1)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.shardMap.get(material.getId()).get(), 8)).build(consumer, new ResourceLocation("emendatusenigmatica", "shard/from_raw/" + material.getId()));
                        ItemStackChemicalToItemStackRecipeBuilder.injecting((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_RAW_STORAGE_BLOCK.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)HYDROGEN_CHLORIDE, 2)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.shardMap.get(material.getId()).get(), 24)).build(consumer, new ResourceLocation("emendatusenigmatica", "shard/from_raw_block/" + material.getId()));
                    }
                }
                if (processedType.contains("clump")) {
                    if (processedType.contains("shard")) {
                        ItemStackChemicalToItemStackRecipeBuilder.purifying((ItemStackIngredient)IngredientCreatorAccess.item().from(EEMekanismTags.MATERIAL_SHARD.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)OXYGEN, 1)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.clumpMap.get(material.getId()).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "clump/from_shard/" + material.getId()));
                    }
                    if (processedType.contains("ore")) {
                        ItemStackChemicalToItemStackRecipeBuilder.purifying((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_ORE.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)OXYGEN, 1)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.clumpMap.get(material.getId()).get(), 3)).build(consumer, new ResourceLocation("emendatusenigmatica", "clump/from_ore/" + material.getId()));
                    }
                    if (processedType.contains("raw")) {
                        ItemStackChemicalToItemStackRecipeBuilder.purifying((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_RAW.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)OXYGEN, 1)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.clumpMap.get(material.getId()).get(), 2)).build(consumer, new ResourceLocation("emendatusenigmatica", "clump/from_raw/" + material.getId()));
                        ItemStackChemicalToItemStackRecipeBuilder.purifying((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_RAW_STORAGE_BLOCK.apply(material.getId())), (ChemicalStackIngredient.GasStackIngredient)((ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)OXYGEN, 2)), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.clumpMap.get(material.getId()).get(), 18)).build(consumer, new ResourceLocation("emendatusenigmatica", "clump/from_raw_block/" + material.getId()));
                    }
                }
                if (processedType.contains("dirty_dust") && processedType.contains("clump")) {
                    ItemStackToItemStackRecipeBuilder.crushing((ItemStackIngredient)IngredientCreatorAccess.item().from(EEMekanismTags.MATERIAL_CLUMP.apply(material.getId())), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.dirtyDustMap.get(material.getId()).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "dirty_dust/from_clump/" + material.getId()));
                }
                if (processedType.contains("dust") && processedType.contains("dirty_dust")) {
                    ItemStackToItemStackRecipeBuilder.enriching((ItemStackIngredient)IngredientCreatorAccess.item().from(EEMekanismTags.MATERIAL_DIRTY_DUST.apply(material.getId())), (ItemStack)this.getItemStack((Item)((RegistryObject)EERegistrar.dustMap.get(material.getId())).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "dust/from_dirty_dust/" + material.getId()));
                }
                if (!processedType.contains("infuse_type")) continue;
                if (material.isModded() && material.getProperties().getMaterialType().equals("metal")) {
                    ItemStackToItemStackRecipeBuilder.enriching((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_INGOT.apply(material.getId())), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.enrichedMap.get(material.getId()).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "enriched/from_ingot/" + material.getId()));
                }
                if (material.isModded() && material.getProperties().getMaterialType().equals("gem")) {
                    ItemStackToItemStackRecipeBuilder.enriching((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_GEM.apply(material.getId())), (ItemStack)this.getItemStack((Item)EEMekanismRegistrar.enrichedMap.get(material.getId()).get())).build(consumer, new ResourceLocation("emendatusenigmatica", "enriched/from_gem/" + material.getId()));
                }
                if (processedType.contains("dust")) {
                    ItemStackToChemicalRecipeBuilder.infusionConversion((ItemStackIngredient)IngredientCreatorAccess.item().from((TagKey)EETags.MATERIAL_DUST.apply(material.getId())), (InfusionStack)new InfusionStack((IInfuseTypeProvider)EEMekanismRegistrar.infuseMap.get(material.getId()).get(), 10L)).build(consumer, new ResourceLocation("emendatusenigmatica", "infuse_type/from_dust/" + material.getId()));
                }
                ItemStackToChemicalRecipeBuilder.infusionConversion((ItemStackIngredient)IngredientCreatorAccess.item().from(EEMekanismTags.MATERIAL_ENRICHED.apply(material.getId())), (InfusionStack)new InfusionStack((IInfuseTypeProvider)EEMekanismRegistrar.infuseMap.get(material.getId()).get(), 80L)).build(consumer, new ResourceLocation("emendatusenigmatica", "infuse_type/from_enriched/" + material.getId()));
            }
        }

        private ItemStack getItemStack(Item item, int size) {
            return new ItemStack((ItemLike)item, size);
        }

        private ItemStack getItemStack(Item item) {
            return this.getItemStack(item, 1);
        }

        public String m_6055_() {
            return "EE Mekanism Addon Recipes";
        }
    }
}

