/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome;

import biomesoplenty.api.sound.BOPSounds;
import biomesoplenty.common.worldgen.carver.BOPConfiguredCarvers;
import biomesoplenty.common.worldgen.placement.BOPCavePlacements;
import biomesoplenty.common.worldgen.placement.BOPMiscOverworldPlacements;
import biomesoplenty.common.worldgen.placement.BOPVegetationPlacements;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.registries.RegistryObject;

public class BOPOverworldBiomes {
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return BOPOverworldBiomes.biome(precipitation, temperature, downfall, 4159204, 329011, spawnBuilder, biomeBuilder, music);
    }

    private static Biome biomeWithColorOverrides(Biome.Precipitation precipitation, float temperature, float downfall, int grassColor, int foliageColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return BOPOverworldBiomes.biomeWithColorOverrides(precipitation, temperature, downfall, 4159204, 329011, grassColor, foliageColor, spawnBuilder, biomeBuilder, music);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(BOPOverworldBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, int skyColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(skyColor).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    private static Biome biomeWithColorOverrides(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int grassColor, int foliageColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48045_(grassColor).m_48043_(foliageColor).m_48040_(BOPOverworldBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    private static Biome biomeWithColorOverrides(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, int grassColor, int foliageColor, int skyColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48045_(grassColor).m_48043_(foliageColor).m_48040_(skyColor).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    private static Biome biomeWithColorOverridesAndParticles(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, int grassColor, int foliageColor, int skyColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, ParticleOptions particleOptions, float particleProbability, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48045_(grassColor).m_48043_(foliageColor).m_48040_(skyColor).m_48029_(new AmbientParticleSettings(particleOptions, particleProbability)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    private static void addFeature(BiomeGenerationSettings.Builder builder, GenerationStep.Decoration step, RegistryObject<PlacedFeature> feature) {
        builder.m_204201_(step, (Holder)feature.getHolder().orElseThrow());
    }

    private static void addFeature(BiomeGenerationSettings.Builder builder, GenerationStep.Decoration step, Holder<PlacedFeature> feature) {
        builder.m_204201_(step, feature);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }

    private static void globalOverworldGenerationNoLavaLakes(BiomeGenerationSettings.Builder builder) {
        builder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126848_);
        builder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_194741_);
        builder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126849_);
        builder.m_204201_(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.f_195266_);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }

    public static Biome auroralGarden() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_AURORAL_GARDEN);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_VIOLET);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_ICY_IRIS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.SNOW, -0.25f, 0.5f, 3750089, 329011, 0xF0FDFD, 14417148, 10876919, 12446972, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome bambooGrove() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 2, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195220_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_BAMBOO_GROVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_CHERRY_BLOSSOM_GROVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.CLOVER_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILAC_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILY_PAD_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SHORT_BAMBOO);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.9f, 8769137, 6537062, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome bayou() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_MUD);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195222_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_BAYOU);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_CATTAIL_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_8);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_LARGE_FERN_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILY_PAD_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.95f, 0.9f, 6467460, 794908, 12638463, 7318096, 9165671, BOPOverworldBiomes.calculateSkyColor(0.95f), spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome bog() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_BOG);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BUSH_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.2f, 0.5f, 11048279, 13008731, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome cherryBlossomGrove() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195220_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_CHERRY_BLOSSOM_GROVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_CHERRY_BLOSSOM_GROVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.CLOVER_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILAC_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PEONY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.9f, 8769137, 6537062, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome cloverPatch() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195401_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_CLOVER_PATCH);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.CLOVER_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.HUGE_CLOVER);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.7f, 8963455, 6993519, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome coldDesert() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20514_, 1, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.WASTELAND_GRASS_1);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.NONE, 0.25f, 0.0f, 11375460, 11904876, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome coniferousForest(boolean isSnowy) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        if (!isSnowy) {
            BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        }
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGenerationNoLavaLakes(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (isSnowy) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_SNOWY_CONIFEROUS_FOREST);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SNOWY);
        } else {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_CONIFEROUS_FOREST);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_CONIFEROUS_FOREST);
        }
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_2);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, isSnowy ? -0.25f : 0.45f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome crag() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 10, 4, 6));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPMiscOverworldPlacements.CRAG_SPLATTER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_24);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.6f, 0.6f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome deadForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_DEAD_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_3);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.2f, 0.3f, 12234084, 12040035, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome dryland() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20557_, 8, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_DRYLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BUSH_1);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.NONE, 0.85f, 0.05f, 4159204, 329011, 12638463, 15065001, 14344371, 10395135, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome duneBeach() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)MiscOverworldPlacements.f_195270_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)MiscOverworldPlacements.f_195268_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_DUNE_GRASS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SEA_OATS);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.7f, 0.4f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome field(boolean forest) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_FIELD_1);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILAC_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.ROSE_BUSH_NORMAL);
        if (forest) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_FIELD_FOREST);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_15);
        } else {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_FIELD);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_FIELD_2);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_10);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SUNFLOWER);
        }
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.4f, 0.7f, 6533741, 6533741, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome firClearing(boolean snowy) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGenerationNoLavaLakes(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_FIR_CLEARING);
        if (!snowy) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_CONIFEROUS_FOREST);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_4);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_NORMAL);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
            return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.45f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
        }
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SNOWY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_2);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_3);
        return BOPOverworldBiomes.biome(Biome.Precipitation.SNOW, -0.25f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome floodplain() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195222_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_RAINFOREST_FLOODPLAIN);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_RAINFOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILY_PAD_15);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SMALL_DRIPLEAF);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_WATERGRASS_250);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 1.2f, 2.0f, 4172478, 268844, 8377405, 6016293, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome fungalJungle() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195400_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195222_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_FUNGAL_JUNGLE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.HUGE_TOADSTOOL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SMALL_TOADSTOOL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.DRIPSTONE_SPLATTER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.MYCELIUM_SPLATTER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.9f, 0.9f, 4185956, 274200, 14806371, 13428005, 14738722, 6479082, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome glowingGrotto() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.GLOWING_GROTTO_VEGETATION);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.GLOWING_GROTTO_MUD);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.GLOWWORM_SILK_STRANDS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.GIANT_GLOWSHROOM_CAVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.HUGE_GLOWSHROOM_CAVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.MEDIUM_GLOWSHROOM_CAVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.SMALL_GLOWSHROOM_CAVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.EXTRA_GLOW_LICHEN);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.5f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome grassland() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195401_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.CLOVER_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.7f, 8963455, 6993519, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome highland() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 10, 4, 6));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_24);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.6f, 0.6f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome highlandMoor() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 10, 4, 6));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195221_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_MOOR);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_VIOLET);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SCRUB_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_6);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.6f, 7449200, 7914605, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome jadeCliffs() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_JADE_CLIFFS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.85f, 4159204, 329011, 12308949, 8168808, 9156462, 12045485, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome lavenderField(boolean forest) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_LAVENDER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_LAVENDER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_64);
        if (forest) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_LAVENDER_FOREST);
        } else {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_LAVENDER_FIELD);
        }
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.7f, 10601325, 10601325, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome lushDesert() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.FLUID_SPRINGS, BOPMiscOverworldPlacements.SPRING_WATER_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195460_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_LUSH_DESERT);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_LUSH_DESERT);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_DEAD_GRASS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_DESERT_GRASS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_DUNE_GRASS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_5);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.9f, 0.5f, 4566514, 267827, 15720834, 13881686, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome lushSavanna() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 3));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.FLUID_SPRINGS, BOPMiscOverworldPlacements.SPRING_WATER_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_POPPY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.ROSE_BUSH_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_15);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_24);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.9f, 0.5f, 4566514, 267827, 15720834, 13881686, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome mapleWoods(boolean snowy) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (!snowy) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_MAPLE_FOREST);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SNOWY);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_2);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
            return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.25f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
        }
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_SNOWY_MAPLE_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SNOWY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_2);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_3);
        return BOPOverworldBiomes.biome(Biome.Precipitation.SNOW, -0.25f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome marsh() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195222_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_250);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_WATERGRASS_50);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.65f, 0.7f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome mediterraneanForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_CALCITE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_MEDITERRANEAN_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_DEFAULT_EXTENDED_6);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BUSH_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PEONY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_3);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.8f, 0.275f, 4566514, 267827, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome muskeg() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)MiscOverworldPlacements.f_195268_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)MiscOverworldPlacements.f_195269_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_MUD);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_MUSKEG);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPMiscOverworldPlacements.MUD_SPLATTER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_1);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.SNOW, 0.0f, 0.6f, 9737838, 9280363, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome mysticGrove() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 5, 1, 1));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 20, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGenerationNoLavaLakes(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)MiscOverworldPlacements.f_195268_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_WHITE_SAND);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_MYSTIC_GROVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_MYSTIC_GROVE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BLUE_HYDRANGEA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.HUGE_RED_MUSHROOM_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SMALL_RED_MUSHROOM);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.CLOVER_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILAC_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_15);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_WATERGRASS_10);
        return BOPOverworldBiomes.biomeWithColorOverridesAndParticles(Biome.Precipitation.RAIN, 0.7f, 0.8f, 10239972, 3015987, 16763354, 6934491, 7397557, 0xAAEFFF, spawnBuilder, biomeBuilder, (ParticleOptions)ParticleTypes.f_123810_, 1.1532552E-4f, NORMAL_MUSIC);
    }

    public static Biome oldGrowthDeadForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_OLD_GROWTH_DEAD_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.3f, 0.3f, 12234084, 12040035, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome ominousWoods() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 50, 2, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 5, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGenerationNoLavaLakes(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_BLACK_SAND);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_OMINOUS_WOODS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_OMINOUS_WOODS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.BRAMBLE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_DEAD_GRASS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.6f, 3220294, 656140, 7897509, 4999792, 7030908, 8692172, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome orchard() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_ORCHARD);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_DEFAULT_EXTENDED_15);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.ROSE_BUSH_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.4f, 11131753, 13236061, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome originValley() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 95, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 100, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204198_(GenerationStep.Carving.AIR, (Holder)BOPConfiguredCarvers.ORIGIN_CAVE.getHolder().orElseThrow());
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195323_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195324_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195332_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195333_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195334_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195335_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195336_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195338_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195340_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)OrePlacements.f_195303_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_ORIGIN_VALLEY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_ORIGIN_VALLEY);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.6f, 930303, 458841, 11587583, 10157919, 3866368, 9223679, spawnBuilder, biomeBuilder, Musics.m_11653_((SoundEvent)((SoundEvent)BOPSounds.MUSIC_BIOME_ORIGIN_VALLEY.get())));
    }

    public static Biome pasture() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BARLEY);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_64);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.3f, 15002231, 13100658, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome prairie() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_PRAIRIE);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_CONIFEROUS_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.GOLDENROD_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_24);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.3f, 15002231, 13100658, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome pumpkinPatch() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_SEASONAL_PUMPKIN_PATCH);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.BIG_PUMPKIN);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PUMPKIN_PATCH);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.4f, 0.8f, 14532426, 13553994, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome rainforest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_ORANGE_SAND);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195222_);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_RAINFOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_RAINFOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.BIG_DRIPLEAF);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_16);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_LARGE_FERN_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILY_PAD_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SMALL_DRIPLEAF);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_WATERGRASS_10);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 1.2f, 2.0f, 4186009, 274214, 11002176, 8970560, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome rockyRainforest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_ORANGE_SAND);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_RAINFOREST_CLIFFS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_RAINFOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_16);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_LARGE_FERN_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.RAINFOREST_CLIFFS_VINES);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_15);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_24);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_WATERGRASS_10);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 1.2f, 2.0f, 4186009, 274214, 11002176, 8970560, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome redwoodForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGenerationNoLavaLakes(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_REDWOOD_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_LARGE_FERN_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.MOSS_SPLATTER);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.6f, 11916636, 9355074, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome rockyShrubland() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 5, 4, 6));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_ROCKY_SHRUBLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SHRUBLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BUSH_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.6f, 0.05f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome scrubland(boolean wooded) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SCRUBLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_DESERT_GRASS);
        if (wooded) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_WOODED_SCRUBLAND);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SCRUB_EXTRA);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_6);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        } else {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SCRUB_NORMAL);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        }
        return BOPOverworldBiomes.biome(Biome.Precipitation.NONE, 1.1f, 0.15f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome shrubland() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_SHRUBLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_SHRUBLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BUSH_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILAC_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.6f, 0.05f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome seasonalForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_SEASONAL_FOREST);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.4f, 0.8f, 14522954, 13742666, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome seasonalOrchard() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_SEASONAL_ORCHARD);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_LARGE_FERN_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.4f, 0.8f, 14527306, 13746762, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome spiderNest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20554_, 50, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.HANGING_COBWEBS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.CORNER_COBWEBS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.WEBBING);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.SPIDER_EGGS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPCavePlacements.STRINGY_COBWEB);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.5f, 0.5f, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome tropics() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20516_, 15, 1, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20559_, 2, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_WHITE_SAND_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195403_);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_TROPICS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_TROPICS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_BLUE_HYDRANGEA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.ROSE_BUSH_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SHORT_BAMBOO);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.95f, 1.0f, 4445678, 270131, 11726335, 6733055, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome tundra() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_GRAVEL_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_TUNDRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_4);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.SCATTERED_ROCKS);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.2f, 0.5f, 12616537, 12949340, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome volcano() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.LAKES, BOPMiscOverworldPlacements.LAKE_LAVA_SURFACE_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.FLUID_SPRINGS, BOPMiscOverworldPlacements.SPRING_LAVA_VOLCANO);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, (Holder<PlacedFeature>)MiscOverworldPlacements.f_195269_);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126820_((BiomeGenerationSettings.Builder)biomeBuilder);
        return BOPOverworldBiomes.biomeWithColorOverridesAndParticles(Biome.Precipitation.NONE, 0.95f, 0.3f, 4566514, 267827, 0x7F7F7F, 4878395, 5537090, BOPOverworldBiomes.calculateSkyColor(0.95f), spawnBuilder, biomeBuilder, (ParticleOptions)ParticleTypes.f_123790_, 0.059046667f, NORMAL_MUSIC);
    }

    public static Biome volcanicPlains() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.FLUID_SPRINGS, BOPMiscOverworldPlacements.SPRING_LAVA_VOLCANO);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_VOLCANIC_PLAINS);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPMiscOverworldPlacements.GRASS_SPLATTER);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_SPROUTS_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.NONE, 0.95f, 0.3f, 4566514, 267827, 4878395, 5537090, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome wasteland(boolean wooded) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 80, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (wooded) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_WASTELAND);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_WASTELAND);
        }
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.WASTELAND_GRASS_2);
        return BOPOverworldBiomes.biomeWithColorOverridesAndParticles(Biome.Precipitation.NONE, 2.0f, 0.0f, 4405025, 789507, 14409153, 11375460, 11904876, 7384559, spawnBuilder, biomeBuilder, (ParticleOptions)ParticleTypes.f_123757_, 0.00357f, NORMAL_MUSIC);
    }

    public static Biome wetland() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, BOPMiscOverworldPlacements.DISK_MUD);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)AquaticPlacements.f_195222_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_WETLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_WETLAND);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_CATTAIL_EXTRA);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_FERN_16);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.LILY_PAD_10);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TOADSTOOL_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_REED_5);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_WATERGRASS_10);
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.6f, 0.7f, 2564473, 787227, 12638463, 5935967, 5215831, BOPOverworldBiomes.calculateSkyColor(0.6f), spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome woodland(boolean dense) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        BOPOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (Holder<PlacedFeature>)VegetationPlacements.f_195450_);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.FLOWER_DEFAULT_EXTENDED_6);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.ROSE_BUSH_NORMAL);
        BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.GOLDENROD_NORMAL);
        if (dense) {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_DENSE_WOODLAND);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_12);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_12);
        } else {
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_GRASS_6);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.PATCH_TALL_GRASS_6);
            BOPOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, BOPVegetationPlacements.TREES_WOODLAND);
        }
        return BOPOverworldBiomes.biomeWithColorOverrides(Biome.Precipitation.RAIN, 0.8f, 0.5f, 10273849, 8762376, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }
}

