/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.model.CachedFormat;
import codechicken.lib.render.buffer.ISpriteAwareVertexConsumer;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.lighting.LC;
import codechicken.lib.render.lighting.LightMatrix;
import codechicken.lib.render.pipeline.CCRenderPipeline;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.ColourAttribute;
import codechicken.lib.render.pipeline.attribute.LightCoordAttribute;
import codechicken.lib.render.pipeline.attribute.LightingAttribute;
import codechicken.lib.render.pipeline.attribute.NormalAttribute;
import codechicken.lib.render.pipeline.attribute.SideAttribute;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class CCRenderState {
    private static final ThreadLocal<CCRenderState> instances = ThreadLocal.withInitial(CCRenderState::new);
    public final VertexAttribute<Vector3[]> normalAttrib = new NormalAttribute();
    public final VertexAttribute<int[]> colourAttrib = new ColourAttribute();
    public final VertexAttribute<int[]> lightingAttrib = new LightingAttribute();
    public final VertexAttribute<int[]> sideAttrib = new SideAttribute();
    public final VertexAttribute<LC[]> lightCoordAttrib = new LightCoordAttribute();
    public IVertexSource model;
    public int firstVertexIndex;
    public int lastVertexIndex;
    public int vertexIndex;
    public CCRenderPipeline pipeline;
    public VertexConsumer r;
    public VertexFormat fmt;
    public CachedFormat cFmt;
    public int baseColour;
    public int alphaOverride;
    public boolean computeLighting;
    public LightMatrix lightMatrix = new LightMatrix();
    public final Vertex5 vert = new Vertex5();
    public final Vector3 normal = new Vector3();
    public int colour;
    public int brightness;
    public int overlay;
    public int side;
    public LC lc = new LC();
    public TextureAtlasSprite sprite;

    private CCRenderState() {
        this.pipeline = new CCRenderPipeline(this);
    }

    public static CCRenderState instance() {
        return instances.get();
    }

    public BufferBuilder startDrawing(VertexFormat.Mode mode, VertexFormat format) {
        BufferBuilder r = Tesselator.m_85913_().m_85915_();
        r.m_166779_(mode, format);
        this.bind(r);
        return r;
    }

    public BufferBuilder startDrawing(VertexFormat.Mode mode, VertexFormat format, BufferBuilder buffer) {
        buffer.m_166779_(mode, format);
        this.bind(buffer);
        return buffer;
    }

    public void bind(BufferBuilder r) {
        this.bind((VertexConsumer)r, r.f_85658_);
    }

    public void bind(VertexConsumer consumer, VertexFormat format) {
        this.r = consumer;
        this.fmt = format;
        this.cFmt = CachedFormat.lookup(format);
    }

    public void bind(RenderType renderType, MultiBufferSource source) {
        this.bind(source.m_6299_(renderType), renderType.m_110508_());
    }

    public void bind(RenderType renderType, MultiBufferSource source, PoseStack mStack) {
        this.bind(new TransformingVertexConsumer(source.m_6299_(renderType), mStack), renderType.m_110508_());
    }

    public void bind(RenderType renderType, MultiBufferSource getter, Matrix4 mat) {
        this.bind(new TransformingVertexConsumer(getter.m_6299_(renderType), mat), renderType.m_110508_());
    }

    public void reset() {
        this.model = null;
        this.pipeline.reset();
        this.computeLighting = true;
        this.alphaOverride = -1;
        this.baseColour = -1;
        this.colour = -1;
    }

    public void preRenderWorld(BlockAndTintGetter world, BlockPos pos) {
        this.reset();
        this.colour = -1;
        this.setBrightness(world, pos);
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.pipeline.setPipeline(ops);
    }

    public void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        this.pipeline.reset();
        this.setModel(model, start, end);
        this.pipeline.setPipeline(ops);
    }

    public void bindModel(IVertexSource model) {
        if (this.model != model) {
            this.model = model;
            this.pipeline.rebuild();
        }
    }

    public void setModel(IVertexSource source) {
        this.setModel(source, 0, source.getVertices().length);
    }

    public void setModel(IVertexSource source, int start, int end) {
        this.bindModel(source);
        this.setVertexRange(start, end);
    }

    public void setVertexRange(int start, int end) {
        this.firstVertexIndex = start;
        this.lastVertexIndex = end;
    }

    public void render(IVertexOperation ... ops) {
        this.setPipeline(ops);
        this.render();
    }

    public void render() {
        Vertex5[] verts = this.model.getVertices();
        this.vertexIndex = this.firstVertexIndex;
        while (this.vertexIndex < this.lastVertexIndex) {
            this.model.prepareVertex(this);
            this.vert.set(verts[this.vertexIndex]);
            this.runPipeline();
            this.writeVert();
            ++this.vertexIndex;
        }
    }

    public void runPipeline() {
        this.pipeline.operate();
    }

    public void writeVert() {
        if (this.r instanceof ISpriteAwareVertexConsumer) {
            ((ISpriteAwareVertexConsumer)this.r).sprite(this.sprite);
        }
        ImmutableList elements = this.fmt.m_86023_();
        block12: for (int e = 0; e < elements.size(); ++e) {
            VertexFormatElement fmte = (VertexFormatElement)elements.get(e);
            switch (fmte.m_86048_()) {
                case POSITION: {
                    this.r.m_5483_(this.vert.vec.x, this.vert.vec.y, this.vert.vec.z);
                    continue block12;
                }
                case UV: {
                    int idx = fmte.m_86049_();
                    switch (idx) {
                        case 0: {
                            this.r.m_7421_((float)this.vert.uv.u, (float)this.vert.uv.v);
                            break;
                        }
                        case 1: {
                            this.r.m_86008_(this.overlay);
                            break;
                        }
                        case 2: {
                            this.r.m_85969_(this.brightness);
                        }
                    }
                    continue block12;
                }
                case COLOR: {
                    if (this.r instanceof BufferBuilder && ((BufferBuilder)this.r).f_85824_) {
                        ((BufferBuilder)this.r).m_5751_();
                        continue block12;
                    }
                    this.r.m_6122_(this.colour >>> 24, this.colour >> 16 & 0xFF, this.colour >> 8 & 0xFF, this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF);
                    continue block12;
                }
                case NORMAL: {
                    this.r.m_5601_((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                    continue block12;
                }
                case PADDING: {
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException("Generic vertex format element");
                }
            }
        }
        this.r.m_5752_();
    }

    public void setBrightness(BlockAndTintGetter world, BlockPos pos) {
        this.brightness = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)world.m_8055_(pos), (BlockPos)pos);
    }

    public void setBrightness(Entity entity, float frameDelta) {
        this.brightness = Minecraft.m_91087_().m_91290_().m_114394_(entity, frameDelta);
    }

    public void setFluidColour(FluidStack fluidStack) {
        this.setFluidColour(fluidStack, 255);
    }

    public void setFluidColour(FluidStack fluidStack, int alpha) {
        this.baseColour = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack) << 8 | alpha;
    }

    public void setColour(Colour colour) {
        this.colour = colour.rgba();
    }

    public ColourRGBA getColour() {
        return new ColourRGBA(this.colour);
    }

    public VertexConsumer getConsumer() {
        return this.r;
    }

    public VertexFormat getVertexFormat() {
        return this.fmt;
    }

    public void draw() {
        Tesselator.m_85913_().m_85914_();
    }
}

