/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferUsage;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.QuadConverter;
import com.jozufozu.flywheel.core.model.BakedModelBuilder;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.util.Pair;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryUtil;

public class BlockModel
implements Model {
    private final VertexList reader;
    private final String name;
    private final EBOSupplier eboSupplier;

    public BlockModel(BlockState state) {
        this(Minecraft.m_91087_().m_91289_().m_110910_(state), state);
    }

    public BlockModel(BakedModel model, BlockState referenceState) {
        this(new BakedModelBuilder(model).withReferenceState(referenceState), referenceState.toString());
    }

    public BlockModel(BakedModel model, BlockState referenceState, PoseStack ms) {
        this(new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(ms), referenceState.toString());
    }

    public BlockModel(Bufferable bufferable, String name) {
        this(bufferable.build(), name);
    }

    public BlockModel(Pair<BufferBuilder.RenderedBuffer, Integer> pair, String name) {
        this.name = name;
        BufferBuilder.RenderedBuffer renderedBuffer = pair.first();
        BufferBuilder.DrawState drawState = renderedBuffer.m_231198_();
        this.reader = Formats.BLOCK.createReader(renderedBuffer, (int)pair.second());
        this.eboSupplier = !drawState.f_166800_() ? new BufferEBOSupplier(renderedBuffer.m_231197_(), drawState.f_166797_(), drawState.f_166798_()) : () -> QuadConverter.getInstance().quads2Tris(this.vertexCount() / 4);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int vertexCount() {
        return this.reader.getVertexCount();
    }

    @Override
    public VertexList getReader() {
        return this.reader;
    }

    @Override
    public ElementBuffer createEBO() {
        return (ElementBuffer)this.eboSupplier.get();
    }

    @Override
    public VertexType getType() {
        return Formats.BLOCK;
    }

    @Override
    public void delete() {
        VertexList vertexList = this.reader;
        if (vertexList instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)((Object)vertexList);
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.eboSupplier.delete();
    }

    private static class BufferEBOSupplier
    implements EBOSupplier {
        private final ByteBuffer indexBuffer;
        private final int indexCount;
        private final VertexFormat.IndexType indexType;
        private int eboName = -1;
        private ElementBuffer ebo;

        public BufferEBOSupplier(ByteBuffer indexBufferSrc, int indexCount, VertexFormat.IndexType indexType) {
            this.indexBuffer = MemoryTracker.m_182527_((int)indexBufferSrc.capacity());
            MemoryUtil.memCopy((ByteBuffer)indexBufferSrc, (ByteBuffer)this.indexBuffer);
            this.indexCount = indexCount;
            this.indexType = indexType;
        }

        @Override
        public ElementBuffer get() {
            if (this.eboName == -1) {
                this.eboName = this.createEBO();
                this.ebo = new ElementBuffer(this.eboName, this.indexCount, this.indexType);
                MemoryUtil.memFree((Buffer)this.indexBuffer);
            }
            return this.ebo;
        }

        private int createEBO() {
            int vbo = GL32.glGenBuffers();
            GlBufferType bufferType = GlBufferType.ARRAY_BUFFER;
            int oldBuffer = bufferType.getBoundBuffer();
            bufferType.bind(vbo);
            GL15.glBufferData((int)bufferType.glEnum, (ByteBuffer)this.indexBuffer, (int)GlBufferUsage.STATIC_DRAW.glEnum);
            bufferType.bind(oldBuffer);
            return vbo;
        }

        @Override
        public void delete() {
            GL32.glDeleteBuffers((int)this.eboName);
        }
    }

    private static interface EBOSupplier
    extends Supplier<ElementBuffer> {
        default public void delete() {
        }
    }
}

