/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.instancing;

import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancedMaterialGroup;
import com.jozufozu.flywheel.core.compile.ProgramCompiler;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.FlwUtil;
import com.jozufozu.flywheel.util.WeakHashSet;
import com.mojang.math.Matrix4f;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;

public class InstancingEngine<P extends WorldProgram>
implements Engine {
    public static int MAX_ORIGIN_DISTANCE = 100;
    protected BlockPos originCoordinate = BlockPos.f_121853_;
    protected final ProgramCompiler<P> context;
    protected final GroupFactory<P> groupFactory;
    protected final boolean ignoreOriginCoordinate;
    protected final Map<RenderLayer, Map<RenderType, InstancedMaterialGroup<P>>> layers;
    private final WeakHashSet<OriginShiftListener> listeners;

    public static <P extends WorldProgram> Builder<P> builder(ProgramCompiler<P> context) {
        return new Builder<P>(context);
    }

    public InstancingEngine(ProgramCompiler<P> context, GroupFactory<P> groupFactory, boolean ignoreOriginCoordinate) {
        this.context = context;
        this.ignoreOriginCoordinate = ignoreOriginCoordinate;
        this.listeners = new WeakHashSet();
        this.groupFactory = groupFactory;
        this.layers = new EnumMap<RenderLayer, Map<RenderType, InstancedMaterialGroup<P>>>(RenderLayer.class);
        for (RenderLayer value : RenderLayer.values()) {
            this.layers.put(value, new HashMap());
        }
    }

    @Override
    public MaterialGroup state(RenderLayer layer, RenderType type) {
        return this.layers.get((Object)layer).computeIfAbsent(type, t -> this.groupFactory.create(this, (RenderType)t));
    }

    @Override
    public void render(TaskEngine taskEngine, RenderLayerEvent event) {
        Matrix4f viewProjection;
        double camZ;
        double camY;
        double camX;
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        if (!this.ignoreOriginCoordinate) {
            camX = event.camX - (double)this.originCoordinate.m_123341_();
            camY = event.camY - (double)this.originCoordinate.m_123342_();
            camZ = event.camZ - (double)this.originCoordinate.m_123343_();
            viewProjection = Matrix4f.m_27653_((float)((float)(-camX)), (float)((float)(-camY)), (float)((float)(-camZ)));
            viewProjection.multiplyBackward(event.viewProjection);
        } else {
            camX = event.camX;
            camY = event.camY;
            camZ = event.camZ;
            viewProjection = event.viewProjection;
        }
        this.getGroupsToRender(event.getLayer()).forEach(group -> group.render(viewProjection, camX, camY, camZ, event.getLayer()));
        restoreState.restore();
    }

    private Stream<InstancedMaterialGroup<P>> getGroupsToRender(@Nullable RenderLayer layer) {
        if (layer != null) {
            return this.layers.get((Object)layer).values().stream();
        }
        return this.layers.values().stream().flatMap(FlwUtil::mapValues);
    }

    @Override
    public void delete() {
        for (Map<RenderType, InstancedMaterialGroup<P>> groups : this.layers.values()) {
            groups.values().forEach(InstancedMaterialGroup::delete);
        }
    }

    @Override
    public Vec3i getOriginCoordinate() {
        return this.originCoordinate;
    }

    public void addListener(OriginShiftListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void beginFrame(Camera info) {
        int cX = Mth.m_14107_((double)info.m_90583_().f_82479_);
        int cY = Mth.m_14107_((double)info.m_90583_().f_82480_);
        int cZ = Mth.m_14107_((double)info.m_90583_().f_82481_);
        int dX = cX - this.originCoordinate.m_123341_();
        int dY = cY - this.originCoordinate.m_123342_();
        int dZ = cZ - this.originCoordinate.m_123343_();
        if (Math.abs(dX) > MAX_ORIGIN_DISTANCE || Math.abs(dY) > MAX_ORIGIN_DISTANCE || Math.abs(dZ) > MAX_ORIGIN_DISTANCE) {
            this.originCoordinate = new BlockPos(cX, cY, cZ);
            for (Map<RenderType, InstancedMaterialGroup<P>> groups : this.layers.values()) {
                groups.values().forEach(InstancedMaterialGroup::clear);
            }
            this.listeners.forEach(OriginShiftListener::onOriginShift);
        }
    }

    @Override
    public void addDebugInfo(List<String> info) {
        info.add("GL33 Instanced Arrays");
        info.add("Instances: " + this.getGroupsToRender(null).mapToInt(InstancedMaterialGroup::getInstanceCount).sum());
        info.add("Vertices: " + this.getGroupsToRender(null).mapToInt(InstancedMaterialGroup::getVertexCount).sum());
        info.add("Origin: " + this.originCoordinate.m_123341_() + ", " + this.originCoordinate.m_123342_() + ", " + this.originCoordinate.m_123343_());
    }

    public static class Builder<P extends WorldProgram> {
        protected final ProgramCompiler<P> context;
        protected GroupFactory<P> groupFactory = InstancedMaterialGroup::new;
        protected boolean ignoreOriginCoordinate;

        public Builder(ProgramCompiler<P> context) {
            this.context = context;
        }

        public Builder<P> setGroupFactory(GroupFactory<P> groupFactory) {
            this.groupFactory = groupFactory;
            return this;
        }

        public Builder<P> setIgnoreOriginCoordinate(boolean ignoreOriginCoordinate) {
            this.ignoreOriginCoordinate = ignoreOriginCoordinate;
            return this;
        }

        public InstancingEngine<P> build() {
            return new InstancingEngine<P>(this.context, this.groupFactory, this.ignoreOriginCoordinate);
        }
    }

    @FunctionalInterface
    public static interface GroupFactory<P extends WorldProgram> {
        public InstancedMaterialGroup<P> create(InstancingEngine<P> var1, RenderType var2);
    }

    @FunctionalInterface
    public static interface OriginShiftListener {
        public void onOriginShift();
    }
}

