/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldData {
    static final Map<LevelAccessor, WorldData> DATA_MAP = new ConcurrentHashMap<LevelAccessor, WorldData>();
    protected final Map<ChunkPos, DepositGenResult> generatedDeposits = new ConcurrentHashMap<ChunkPos, DepositGenResult>();

    @Nonnull
    public static WorldData getData(LevelAccessor world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData();
            DATA_MAP.put(world, data);
        }
        return data;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(LevelEvent.Unload event) {
        DATA_MAP.remove(event.getLevel());
    }

    @SubscribeEvent
    public static void onChunkDataLoading(ChunkDataEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (level == null) {
            return;
        }
        if (!GameWorld.isServerSide((LevelReader)level)) {
            return;
        }
        CompoundTag compound = event.getData();
        DepositGenResult result = DepositGenResult.EMPTY.readFrom(compound);
        if (!result.isEmpty()) {
            WorldData.getData(level).addDepositGenResult(result);
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaving(ChunkDataEvent.Save event) {
        LevelAccessor world = event.getLevel();
        if (world == null) {
            return;
        }
        if (!GameWorld.isServerSide((LevelReader)world)) {
            return;
        }
        ChunkPos pos = event.getChunk().m_7697_();
        DepositGenResult deposit = WorldData.getData((LevelAccessor)world).generatedDeposits.get(pos);
        if (deposit != null) {
            CompoundTag compound = event.getData();
            deposit.writeTo(compound);
        }
    }

    public static boolean inAdjacentChunk(BlockPos pos, WorldGenLevel level, ChunkPos center, boolean includeCorners) {
        ChunkPos check = new ChunkPos(pos);
        int dX = Math.abs(center.f_45578_ - check.f_45578_);
        int dZ = Math.abs(center.f_45579_ - check.f_45579_);
        return includeCorners ? dX <= 1 && dZ <= 1 : dX == 0 && dZ <= 1 || dZ == 0 && dX <= 1;
    }

    public void addDepositGenResult(DepositGenResult result) {
        if (!result.isEmpty()) {
            this.generatedDeposits.put(new ChunkPos(result.pos), result);
        }
    }

    public Map<ChunkPos, DepositGenResult> getGeneratedDeposits() {
        return Collections.unmodifiableMap(this.generatedDeposits);
    }
}

