/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonPath;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.deposit.DepositSample;
import com.endertech.minecraft.mods.adlods.deposit.Flowers;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Replacements;
import com.endertech.minecraft.mods.adlods.world.AbstractGenerator;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class DepositGenerator
extends AbstractGenerator {
    protected final Path configsDir;
    protected final List<Deposit> deposits = new ArrayList<Deposit>();
    protected final Set<BlockState> ores = new HashSet<BlockState>();

    public DepositGenerator(AbstractForgeMod mod) {
        super(mod);
        this.configsDir = mod.getConfigsDir().resolve("Deposits");
    }

    static String withOreSuffix(String name) {
        return Names.registry().join(new String[]{name, "ore"});
    }

    @Override
    public boolean generateAt(WorldGenLevel level, ChunkPos chunkPos) {
        List passed = this.deposits.stream().filter(deposit -> deposit.inAllowedDimenstion((ServerLevelAccessor)level) && deposit.getChance().takeChance()).collect(Collectors.toList());
        if (passed.isEmpty()) {
            return false;
        }
        int maxAttempts = 16;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            DepositGenResult result;
            Deposit deposit2 = CommonCollect.getRandomElementFrom(passed).orElse(null);
            if (deposit2 == null || (result = deposit2.generateAt(level, chunkPos)).isEmpty()) continue;
            deposit2.placeIndicatorIfFullsized(level, result);
            return true;
        }
        ForgeEndertech.debugMsg((String)("Failed all attempts to generate deposit at " + chunkPos));
        return false;
    }

    protected void createDefaultDeposits(Path dir) {
        DepositSample sample = new DepositSample(new Deposit.Size(900, 1800), new Deposit.Altitude(0, 80), new Deposit.Rarity(800, 2400));
        this.createVanillaDeposit(dir, "coal", sample, 1.0f, Flowers.circles(Flowers.GlowRose.BLACK_DIAMOND, Flowers.Mystical.BLACK, Flowers.Vanilla.LARGE_FERN));
        Deposit.in(dir, (Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)Deposit.Properties.overworld("gas_pocket").size(50, 500))).altitude(4, 64))).rarity(1000))).ores("adpother:carbon:[density=heavy], 50", "adpother:sulfur:[density=heavy], 1"))).replaceableBlocks("#minecraft:stone_ore_replaceables", "air:*"))).exposed(false)));
        sample = new DepositSample(new Deposit.Size(700, 1400), new Deposit.Altitude(16, 64), new Deposit.Rarity(1000, 3000));
        this.createVanillaDeposit(dir, "iron", sample.withAltitude(-64, 64), 1.0f, Flowers.circles(Flowers.GlowRose.CITRINE, Flowers.Mystical.BROWN, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.CHEAP));
        this.createCustomDeposit(dir, "aluminum", sample, 6.6f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.CHEAP));
        this.createCustomDeposit(dir, "lead", sample, 7.0f, Flowers.circles(Flowers.GlowRose.ONYX, Flowers.Mystical.GRAY, Flowers.Vanilla.AZURE_BLUET, Flowers.Metal.CHEAP));
        this.createCustomDeposit(dir, "zinc", sample, 10.3f, Flowers.circles(Flowers.GlowRose.EUCLAUSE, Flowers.Mystical.LIGHT_BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        this.createVanillaDeposit(dir, "copper", sample.withAltitude(-16, 64), 22.6f, Flowers.circles(Flowers.GlowRose.SPINEL, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "nickel", sample, 44.6f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "tin", sample, 74.8f, Flowers.circles(Flowers.GlowRose.ZIRCON, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "cobalt", sample, 104.7f, Flowers.circles(Flowers.GlowRose.BENITOITE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER, Flowers.Metal.NORMAL));
        sample = new DepositSample(new Deposit.Size(500, 1000), new Deposit.Altitude(8, 32), new Deposit.Rarity(1200, 3600));
        this.createCustomDeposit(dir, "silver", sample, 1.0f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.GRAY, Flowers.Vanilla.AZURE_BLUET, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "ruthenium", sample, 17.45f, Flowers.circles(Flowers.GlowRose.MOONSTONE, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "osmium", sample, 26.2f, Flowers.circles(Flowers.GlowRose.EUCLAUSE, Flowers.Mystical.LIGHT_BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        this.createCustomDeposit(dir, "platinum", sample, 58.89f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "gold", sample, 85.67f, Flowers.circles(Flowers.GlowRose.JASPER, Flowers.Mystical.ORANGE, Flowers.Vanilla.DANDELION, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "palladium", sample, 90.97f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "iridium", sample, 97.8f, Flowers.circles(Flowers.GlowRose.ZIRCON, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "uranium", sample, 100.0f, Flowers.circles(Flowers.GlowRose.MALACHITE, Flowers.Mystical.LIME, Flowers.Vanilla.LILY_OF_THE_VALLEY, Flowers.Metal.PRECIOUS));
        this.createCustomDeposit(dir, "rhodium", sample, 211.94f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        sample = new DepositSample(new Deposit.Size(300, 600), new Deposit.Altitude(4, 16), new Deposit.Rarity(1400, 4200));
        this.createVanillaDeposit(dir, "redstone", sample.withAltitude(-32, 16), 60.0f, Flowers.circles(Flowers.GlowRose.CARNELIAN, Flowers.Mystical.RED, Flowers.Vanilla.POPPY));
        this.createVanillaDeposit(dir, "lapis", sample.withAltitude(-32, 16), 80.0f, Flowers.circles(Flowers.GlowRose.BENITOITE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER));
        this.createVanillaDeposit(dir, "diamond", sample.withAltitude(-64, 16), 100.0f, Flowers.circles(Flowers.GlowRose.FLUORITE, Flowers.Mystical.CYAN, Flowers.Vanilla.BLUE_ORCHID));
        this.createCustomDeposit(dir, "amethyst", sample, 70.0f, Flowers.circles(Flowers.GlowRose.AMETHYST, Flowers.Mystical.PURPLE, Flowers.Vanilla.PINK_TULIP));
        this.createCustomDeposit(dir, "sapphire", sample, 80.0f, Flowers.circles(Flowers.GlowRose.SAPPHIRE, Flowers.Mystical.BLUE, Flowers.Vanilla.CORNFLOWER));
        this.createCustomDeposit(dir, "ruby", sample, 90.0f, Flowers.circles(Flowers.GlowRose.RUBY, Flowers.Mystical.RED, Flowers.Vanilla.RED_TULIP));
        this.createCustomDeposit(dir, "topaz", sample, 100.0f, Flowers.circles(Flowers.GlowRose.TOPAZ, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP));
        this.createVanillaDeposit(dir, "emerald", sample.withAltitude(-16, 16), 110.0f, Flowers.circles(Flowers.GlowRose.PHOSPHOPHYLLITE, Flowers.Mystical.LIME, Flowers.Vanilla.WHITE_TULIP));
        this.createNetherDeposit(dir, "ancient_debris", new Deposit.Size(250, 500), 1800, false, new String[]{"minecraft:brown_mushroom, 3", "minecraft:brown_mushroom, 6"});
        this.createNetherDeposit(dir, "nether_gold", new Deposit.Size(500, 1000), 600, true, new String[0]);
        this.createNetherDeposit(dir, "nether_quartz", new Deposit.Size(700, 1400), 400, true, new String[0]);
    }

    public Deposit createNetherDeposit(Path dir, String name, Deposit.Size size, int rarity, boolean exposed, String[] indicators) {
        String[] ores = new String[]{name.startsWith("nether") ? DepositGenerator.withOreSuffix(name) : name};
        return new Deposit(UnitConfig.in((Path)dir, (String)name), (Deposit.Properties<?>)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)Deposit.Properties.nether(name).size(size.getMin(), size.getMax()))).altitude(8, 118))).rarity(rarity))).ores(ores))).exposed(exposed))).indicators(indicators)));
    }

    public Deposit createVanillaDeposit(Path dir, String name, DepositSample sample, float priceFactor, String[] indicators) {
        String ore = DepositGenerator.withOreSuffix(name);
        float factor = new Percentage(priceFactor).toFraction();
        return Deposit.in(dir, ((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)Deposit.Properties.overworld(name).size(sample.size().getMin(), sample.size().getMax()))).altitude(sample.altitude().getMin(), sample.altitude().getMax()))).rarity(sample.getRarity(factor)))).ores(ore))).deepslate(ore))).indicators(indicators));
    }

    public Deposit createCustomDeposit(Path dir, String name, DepositSample sample, float priceFactor, String[] indicators) {
        float factor = new Percentage(priceFactor).toFraction();
        return this.createCustomDeposit(dir, name, sample.size(), sample.altitude(), sample.getRarity(factor), indicators);
    }

    public Deposit createCustomDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity, String[] indicators) {
        return this.createCustomDeposit(dir, name, size, altitude, rarity, new String[]{"#forge:ores/" + name}, indicators);
    }

    public Deposit createCustomDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity, String[] ores, String[] indicators) {
        return Deposit.in(dir, ((Deposit.Properties)((Object)((Deposit.Properties)((Object)((Deposit.Properties)((Object)((AbstractOre.Properties)((Object)Deposit.Properties.deposit(name).size(size.getMin(), size.getMax()))).altitude(altitude.getMin(), altitude.getMax()))).rarity(rarity))).ores(ores))).indicators(indicators));
    }

    protected void parseDepositsFrom(Path dir) {
        this.deposits.clear();
        for (Path path : UnitConfig.listCustomConfigs((Path)dir, null)) {
            String name = CommonPath.getFileNameOnly((Path)path);
            Deposit deposit = new Deposit(new UnitConfig(path.toFile()), Deposit.Properties.overworld(name));
            this.addDeposit(deposit);
        }
    }

    public Path getConfigsDir() {
        return this.configsDir;
    }

    public List<Deposit> getDeposits() {
        return Collections.unmodifiableList(this.deposits);
    }

    public void loadDeposits() {
        this.createDefaultDeposits(this.configsDir);
        this.parseDepositsFrom(this.configsDir);
        this.enumerateOres();
    }

    protected void enumerateOres() {
        this.ores.clear();
        this.deposits.stream().map(AbstractOre::getReplacements).map(Replacements::getOres).forEach(this.ores::addAll);
        this.deposits.stream().map(AbstractOre::getReplacements).forEach(reps -> this.ores.removeIf(reps::haveReplacementFor));
    }

    public boolean isOreBlock(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        return this.ores.contains(state) || GameWorld.isOreBlock((LevelReader)world, (BlockPos)pos, (BlockState)state);
    }

    public boolean addDeposit(Deposit deposit) {
        if (!deposit.isValid()) {
            return false;
        }
        if (this.findDepositBy(deposit.getName()).isPresent()) {
            return false;
        }
        return this.deposits.add(deposit);
    }

    public boolean removeDeposit(Deposit deposit) {
        return this.deposits.remove(deposit);
    }

    public Optional<Deposit> findDepositBy(String name) {
        for (Deposit deposit : this.deposits) {
            if (!deposit.getName().equals(name)) continue;
            return Optional.of(deposit);
        }
        return Optional.empty();
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return super.m_142674_(context);
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)AdLods.getInstance().codecs.generator.get();
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            builder.getGenerationSettings().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placedFeature);
        }
    }
}

