/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite.handlers;

import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.init.UpgradedNetheriteEffects;
import com.rolfmao.upgradednetherite.utils.DurabilityUtil;
import com.rolfmao.upgradednetherite.utils.check.CorruptUtil;
import com.rolfmao.upgradednetherite.utils.check.EchoUtil;
import com.rolfmao.upgradednetherite.utils.check.FireUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="upgradednetherite", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onEnderTeleport(EntityTeleportEvent event) {
        if (event.getEntity() instanceof LivingEntity && ((LivingEntity)event.getEntity()).m_21023_((MobEffect)UpgradedNetheriteEffects.ENDER_ANCHOR.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onFogDensity(ViewportEvent.RenderFog event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (FireUtil.isWearingFireArmor((Player)player) && event.getCamera().m_167685_() == FogType.LAVA) {
            event.setFarPlaneDistance(event.getFarPlaneDistance() + 3.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            ItemStack heldItem = player.m_21205_();
            if (CorruptUtil.intWearingCorrupt(player, false) > 0 || CorruptUtil.isCorruptToolOrWeapon(heldItem)) {
                DurabilityUtil.CorruptDurabilityGain(player);
            }
        }
        if (event.getEntity().m_21023_((MobEffect)UpgradedNetheriteEffects.ATTRACTION.get())) {
            LivingEntity target = event.getEntity();
            double tx = target.m_20185_();
            double ty = target.m_20186_();
            double tz = target.m_20189_();
            List entities = target.f_19853_.m_45976_(LivingEntity.class, new AABB(tx - 5.0, ty - 5.0, tz - 5.0, tx + 5.0, ty + 5.0, tz + 5.0));
            int pulled = 0;
            for (LivingEntity entity : entities) {
                if (!entity.m_6084_() || entity == event.getEntity() || target instanceof WitherBoss || target instanceof EnderDragon || entity instanceof Player && !(target instanceof Player)) continue;
                if (pulled > 32) break;
                Vec3 entityVector = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                Vec3 finalVector = new Vec3(tx, ty, tz).m_82546_(entityVector);
                if (entity.m_20186_() < ty && target.m_20096_()) {
                    finalVector = new Vec3(tx, ty + 0.1, tz).m_82546_(entityVector);
                    entity.f_19789_ = 0.0f;
                }
                if (!(Math.sqrt(finalVector.f_82479_ * finalVector.f_82479_ + finalVector.f_82480_ * finalVector.f_82480_ + finalVector.f_82481_ * finalVector.f_82481_) > 1.8)) continue;
                finalVector = finalVector.m_82541_();
                entity.m_20334_(finalVector.f_82479_ * (double)0.15f, finalVector.f_82480_ * (double)0.15f, finalVector.f_82481_ * (double)0.15f);
                ++pulled;
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (EchoUtil.isEchoSoulbound(itemStack) && UpgradedNetheriteConfig.EnableSoulbound) {
            for (Component line : event.getToolTip()) {
                if (line instanceof Component && (line.getString().contains("item.unbreakable") || line.getString().contains("item.canBreak") || line.getString().contains("item.canPlace") || line.getString().contains("item.durability"))) {
                    event.getToolTip().add(event.getToolTip().indexOf(line), Component.m_237115_((String)"upgradednetherite.Echo_Tool.TT"));
                    break;
                }
                if (ForgeRegistries.ITEMS.getKey((Object)event.getItemStack().m_41720_()).toString().equals(line.getString())) {
                    event.getToolTip().add(event.getToolTip().indexOf(line), Component.m_237115_((String)"upgradednetherite.Echo_Tool.TT"));
                    break;
                }
                if (line instanceof Component && line.getString().contains("item.nbt_tags")) {
                    event.getToolTip().add(event.getToolTip().indexOf(line), Component.m_237115_((String)"upgradednetherite.Echo_Tool.TT"));
                    break;
                }
                if (event.getToolTip().indexOf(line) != event.getToolTip().size() - 1) continue;
                event.getToolTip().add(event.getToolTip().indexOf(line) + 1, Component.m_237115_((String)"upgradednetherite.Echo_Tool.TT"));
                break;
            }
        }
    }
}

