/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.ValidItemsScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTask
extends Task
implements Predicate<ItemStack> {
    public ItemStack item = ItemStack.f_41583_;
    public long count = 1L;
    public Tristate consumeItems = Tristate.DEFAULT;
    public Tristate onlyFromCrafting = Tristate.DEFAULT;
    public Tristate matchNBT = Tristate.DEFAULT;
    public boolean weakNBTmatch = false;
    public boolean taskScreenOnly = false;

    public ItemTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1L) {
            nbt.m_128356_("count", this.count);
        }
        this.consumeItems.write(nbt, "consume_items");
        this.onlyFromCrafting.write(nbt, "only_from_crafting");
        this.matchNBT.write(nbt, "match_nbt");
        if (this.weakNBTmatch) {
            nbt.m_128379_("weak_nbt_match", true);
        }
        if (this.taskScreenOnly) {
            nbt.m_128379_("task_screen_only", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = Math.max(nbt.m_128454_("count"), 1L);
        this.consumeItems = Tristate.read((CompoundTag)nbt, (String)"consume_items");
        this.onlyFromCrafting = Tristate.read((CompoundTag)nbt, (String)"only_from_crafting");
        this.matchNBT = Tristate.read((CompoundTag)nbt, (String)"match_nbt");
        this.weakNBTmatch = nbt.m_128471_("weak_nbt_match");
        this.taskScreenOnly = nbt.m_128471_("task_screen_only");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (this.count > 1L ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (this.consumeItems != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.consumeItems == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.onlyFromCrafting != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (this.onlyFromCrafting == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (this.matchNBT != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (this.matchNBT == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)128, (boolean)this.weakNBTmatch);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.taskScreenOnly);
        buffer.m_130130_(flags);
        FTBQuestsNetHandler.writeItemType(buffer, this.item);
        if (this.count > 1L) {
            buffer.m_130103_(this.count);
        }
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        int flags = buffer.m_130242_();
        this.item = FTBQuestsNetHandler.readItemType(buffer);
        long l = this.count = Bits.getFlag((int)flags, (int)1) ? buffer.m_130258_() : 1L;
        Tristate tristate = Bits.getFlag((int)flags, (int)2) ? (Bits.getFlag((int)flags, (int)4) ? Tristate.TRUE : Tristate.FALSE) : (this.consumeItems = Tristate.DEFAULT);
        Tristate tristate2 = Bits.getFlag((int)flags, (int)8) ? (Bits.getFlag((int)flags, (int)16) ? Tristate.TRUE : Tristate.FALSE) : (this.onlyFromCrafting = Tristate.DEFAULT);
        this.matchNBT = Bits.getFlag((int)flags, (int)32) ? (Bits.getFlag((int)flags, (int)64) ? Tristate.TRUE : Tristate.FALSE) : Tristate.DEFAULT;
        this.weakNBTmatch = Bits.getFlag((int)flags, (int)128);
        this.taskScreenOnly = Bits.getFlag((int)flags, (int)256);
    }

    public List<ItemStack> getValidDisplayItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemFiltersAPI.getDisplayItemStacks((ItemStack)this.item, list);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        if (this.count > 1L) {
            return Component.m_237113_((String)(this.count + "x ")).m_7220_(this.item.m_41786_());
        }
        return Component.m_237113_((String)"").m_7220_(this.item.m_41786_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : this.getValidDisplayItems()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            Icon icon = ItemIcon.getItemIcon((ItemStack)copy);
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.item.m_41619_()) {
            return true;
        }
        IItemFilter f = ItemFiltersAPI.getFilter((ItemStack)this.item);
        return f != null ? f.filter(this.item, stack) : this.areItemStacksEqual(this.item, stack);
    }

    private boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.m_41720_() != stackB.m_41720_()) {
            return false;
        }
        if (!stackA.m_41782_() && !stackB.m_41782_()) {
            return true;
        }
        return !this.shouldMatchNBT() || NBTUtils.compareNbt((Tag)stackA.m_41783_(), (Tag)stackB.m_41783_(), this.weakNBTmatch, true);
    }

    private boolean shouldMatchNBT() {
        return switch (this.matchNBT) {
            default -> throw new IncompatibleClassChangeError();
            case Tristate.TRUE -> true;
            case Tristate.FALSE -> false;
            case Tristate.DEFAULT -> this.item.m_41720_().m_204114_().m_203656_(ItemFiltersAPI.CHECK_NBT_ITEM_TAG);
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, false).setNameKey("ftbquests.task.ftbquests.item");
        config.addLong("count", this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", (Object)this.consumeItems, v -> {
            this.consumeItems = v;
        }, Tristate.NAME_MAP);
        config.addEnum("only_from_crafting", (Object)this.onlyFromCrafting, v -> {
            this.onlyFromCrafting = v;
        }, Tristate.NAME_MAP);
        config.addEnum("match_nbt", (Object)this.matchNBT, v -> {
            this.matchNBT = v;
        }, Tristate.NAME_MAP);
        config.addBool("weak_nbt_match", this.weakNBTmatch, v -> {
            this.weakNBTmatch = v;
        }, false);
        config.addBool("task_screen_only", this.taskScreenOnly, v -> {
            this.taskScreenOnly = v;
        }, false);
    }

    @Override
    public boolean consumesResources() {
        return this.consumeItems.get(this.quest.chapter.file.defaultTeamConsumeItems);
    }

    @Override
    public boolean canInsertItem() {
        return this.consumesResources();
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.consumesResources();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        List<ItemStack> validItems = this.getValidDisplayItems();
        if (!this.consumesResources() && validItems.size() == 1 && FTBQuestsJEIHelper.isRecipeModAvailable()) {
            FTBQuestsJEIHelper.showRecipes(validItems.get(0));
        } else if (validItems.isEmpty()) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)Component.m_237113_((String)"No valid items!"), ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get())), (Component)Component.m_237113_((String)"Report this bug to modpack author!")));
        } else {
            new ValidItemsScreen(this, validItems, canClick).openGui();
        }
    }

    @Override
    public void addMouseOverHeader(TooltipList list, TeamData teamData, boolean advanced) {
        List lines = this.item.m_41651_(FTBQuests.PROXY.getClientPlayer(), (TooltipFlag)(advanced ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        if (!this.title.isEmpty()) {
            list.add((Component)Component.m_237113_((String)this.title));
        } else {
            if (!lines.isEmpty()) {
                lines.set(0, this.getTitle());
            } else {
                lines.add(this.getTitle());
            }
            lines.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        if (this.taskScreenOnly) {
            list.blankLine();
            list.add((Component)Component.m_237115_((String)"ftbquests.task.task_screen_only").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else if (this.consumesResources() && !teamData.isCompleted(this)) {
            list.blankLine();
            list.add((Component)Component.m_237115_((String)"ftbquests.task.click_to_submit").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else if (this.getValidDisplayItems().size() > 1) {
            list.blankLine();
            list.add((Component)Component.m_237115_((String)"ftbquests.task.ftbquests.item.view_items").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else if (FTBQuestsJEIHelper.isRecipeModAvailable()) {
            list.blankLine();
            list.add((Component)Component.m_237115_((String)"ftbquests.task.ftbquests.item.click_recipe").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        }
    }

    public ItemStack insert(TeamData teamData, ItemStack stack, boolean simulate) {
        long add;
        if (!teamData.isCompleted(this) && this.consumesResources() && this.test(stack) && (add = Math.min((long)stack.m_41613_(), this.count - teamData.getProgress(this))) > 0L) {
            if (!simulate && teamData.file.isServerSide()) {
                teamData.addProgress(this, add);
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_((int)((long)stack.m_41613_() - add));
            return copy;
        }
        return stack;
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (this.taskScreenOnly || teamData.isCompleted(this) || this.item.m_41720_() instanceof MissingItem || craftedItem.m_41720_() instanceof MissingItem) {
            return;
        }
        if (!this.consumesResources()) {
            if (this.onlyFromCrafting.get(false)) {
                if (!craftedItem.m_41619_() && this.test(craftedItem)) {
                    teamData.addProgress(this, craftedItem.m_41613_());
                }
            } else {
                long c = Math.min(this.count, player.m_150109_().f_35974_.stream().filter(this).mapToLong(ItemStack::m_41613_).sum());
                if (c > teamData.getProgress(this)) {
                    teamData.setProgress(this, c);
                }
            }
        } else if (craftedItem.m_41619_()) {
            boolean changed = false;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack1;
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (stack == (stack1 = this.insert(teamData, stack, false))) continue;
                changed = true;
                player.m_150109_().f_35974_.set(i, (Object)(stack1.m_41619_() ? ItemStack.f_41583_ : stack1));
            }
            if (changed) {
                player.m_150109_().m_6596_();
                player.f_36096_.m_38946_();
            }
        }
    }

    public boolean isTaskScreenOnly() {
        return this.taskScreenOnly;
    }
}

