/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.ConfigIconItemStack;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class QuestObjectBase {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    public static Tristate sendNotifications = Tristate.DEFAULT;
    public long id = 0L;
    public boolean invalid = false;
    public String title = "";
    public ItemStack icon = ItemStack.f_41583_;
    private List<String> tags = new ArrayList<String>(0);
    private Icon cachedIcon = null;
    private Component cachedTitle = null;
    private Set<String> cachedTags = null;

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static long getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0L : object.id;
    }

    public static String getCodeString(long id) {
        return String.format("%016X", id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return QuestObjectBase.getCodeString(QuestObjectBase.getID(object));
    }

    public static long parseCodeString(String id) {
        if (id.isEmpty() || id.equals("-")) {
            return 0L;
        }
        try {
            return Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static Optional<String> titleToID(String s) {
        s = s.replace(' ', '_').replaceAll("\\W", "").toLowerCase().trim();
        while (s.startsWith("_")) {
            s = s.substring(1);
        }
        while (s.endsWith("_")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? Optional.empty() : Optional.of(s);
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return Long.hashCode(this.id);
    }

    public abstract QuestObjectType getObjectType();

    public abstract QuestFile getQuestFile();

    public Set<String> getTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.cachedTags == null) {
            this.cachedTags = new LinkedHashSet<String>(this.tags);
        }
        return this.cachedTags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.getTags().contains(tag);
    }

    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
    }

    public final void forceProgressRaw(TeamData teamData, ProgressChange progressChange) {
        if (teamData.isLocked()) {
            return;
        }
        teamData.clearCachedProgress();
        sendNotifications = progressChange.notifications ? Tristate.TRUE : Tristate.FALSE;
        this.forceProgress(teamData, progressChange);
        sendNotifications = Tristate.DEFAULT;
        teamData.clearCachedProgress();
        teamData.save();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public long getParentID() {
        return 1L;
    }

    public void writeData(CompoundTag nbt) {
        if (!this.title.isEmpty()) {
            nbt.m_128359_("title", this.title);
        }
        NBTUtils.write(nbt, "icon", this.icon);
        if (!this.tags.isEmpty()) {
            ListTag tagList = new ListTag();
            for (String s : this.tags) {
                tagList.add((Object)StringTag.m_129297_((String)s));
            }
            nbt.m_128365_("tags", (Tag)tagList);
        }
    }

    public void readData(CompoundTag nbt) {
        this.title = nbt.m_128461_("title");
        this.icon = NBTUtils.read(nbt, "icon");
        ListTag tagsList = nbt.m_128437_("tags", 8);
        this.tags = new ArrayList<String>(tagsList.size());
        for (int i = 0; i < tagsList.size(); ++i) {
            this.tags.add(tagsList.m_128778_(i));
        }
        if (nbt.m_128441_("custom_id")) {
            this.tags.add(nbt.m_128461_("custom_id"));
        }
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.title.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.icon.m_41619_() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        buffer.m_130130_(flags);
        if (!this.title.isEmpty()) {
            buffer.m_130072_(this.title, Short.MAX_VALUE);
        }
        if (!this.icon.m_41619_()) {
            buffer.m_130055_(this.icon);
        }
        if (!this.tags.isEmpty()) {
            NetUtils.writeStrings(buffer, this.tags);
        }
    }

    public void readNetData(FriendlyByteBuf buffer) {
        int flags = buffer.m_130242_();
        this.title = Bits.getFlag((int)flags, (int)1) ? buffer.m_130136_(Short.MAX_VALUE) : "";
        this.icon = Bits.getFlag((int)flags, (int)2) ? buffer.m_130267_() : ItemStack.f_41583_;
        this.tags = new ArrayList<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            NetUtils.readStrings(buffer, this.tags);
        }
    }

    protected boolean hasTitleConfig() {
        return true;
    }

    protected boolean hasIconConfig() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        if (this.hasTitleConfig()) {
            config.addString("title", this.title, v -> {
                this.title = v;
            }, "").setNameKey("ftbquests.title").setOrder(-127);
        }
        if (this.hasIconConfig()) {
            ((ConfigIconItemStack)config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.icon, v -> {
                this.icon = v;
            }, (Object)ItemStack.f_41583_)).setNameKey("ftbquests.icon").setOrder(-126);
        }
        config.addList("tags", this.tags, (ConfigValue)new StringConfig(TAG_PATTERN), (Object)"").setNameKey("ftbquests.tags").setOrder(-125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Component getAltTitle();

    @OnlyIn(value=Dist.CLIENT)
    public abstract Icon getAltIcon();

    @OnlyIn(value=Dist.CLIENT)
    public final Component getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle.m_6881_();
        }
        this.cachedTitle = !this.title.isEmpty() ? TextUtils.parseRawText(this.title) : this.getAltTitle();
        return this.cachedTitle.m_6881_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final MutableComponent getMutableTitle() {
        return Component.m_237119_().m_7220_(this.getTitle());
    }

    @OnlyIn(value=Dist.CLIENT)
    public final Icon getIcon() {
        if (this.cachedIcon != null) {
            return this.cachedIcon;
        }
        if (!this.icon.m_41619_()) {
            this.cachedIcon = CustomIconItem.getIcon(this.icon);
        }
        if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
            this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
        }
        if (this.cachedIcon.isEmpty()) {
            this.cachedIcon = this.getAltIcon();
        }
        return this.cachedIcon;
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void editedFromGUIOnServer() {
    }

    public void onCreated() {
    }

    @Nullable
    public String getPath() {
        return null;
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTags = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getGroup(this.getObjectType().id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        this.getConfig(this.createSubGroup(group));
        group.savedCallback = accepted -> {
            gui.run();
            if (accepted) {
                new EditObjectMessage(this).sendToServer();
            }
        };
        new EditConfigScreen(group).openGui();
    }

    public int refreshJEI() {
        return 0;
    }
}

