/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.EditObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class EditObjectMessage
extends BaseC2SMessage {
    private final long id;
    private final CompoundTag nbt;

    EditObjectMessage(FriendlyByteBuf buffer) {
        this.id = buffer.readLong();
        this.nbt = buffer.m_130260_();
    }

    public EditObjectMessage(QuestObjectBase o) {
        this.id = o.id;
        this.nbt = new CompoundTag();
        o.writeData(this.nbt);
        FTBQuestsJEIHelper.refresh(o);
        ClientQuestFile.INSTANCE.clearCachedData();
        o.editedFromGUI();
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.EDIT_OBJECT;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.id);
        buffer.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        QuestObjectBase object;
        if (NetUtils.canEdit(context) && (object = ServerQuestFile.INSTANCE.getBase(this.id)) != null) {
            object.readData(this.nbt);
            object.editedFromGUIOnServer();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
            new EditObjectResponseMessage(object).sendToAll(context.getPlayer().m_20194_());
        }
    }
}

