/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.jei.JEIRecipeTypes;
import dev.ftb.mods.ftbquests.integration.jei.QuestCategory;
import dev.ftb.mods.ftbquests.integration.jei.WrappedQuest;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;

public enum QuestRecipeManagerPlugin implements IRecipeManagerPlugin
{
    INSTANCE;

    private final List<WrappedQuest> wrappedQuestsCache = new ArrayList<WrappedQuest>();
    private boolean needsRefresh = true;

    private List<WrappedQuest> getWrappedQuests() {
        if (this.needsRefresh) {
            this.rebuildWrappedQuests();
            this.needsRefresh = false;
        }
        return this.wrappedQuestsCache;
    }

    private void rebuildWrappedQuests() {
        this.wrappedQuestsCache.clear();
        if (ClientQuestFile.exists()) {
            for (ChapterGroup group : ClientQuestFile.INSTANCE.chapterGroups) {
                for (Chapter chapter : group.chapters) {
                    for (Quest quest : chapter.quests) {
                        List<Reward> rewards;
                        if (!ClientQuestFile.INSTANCE.self.canStartTasks(quest) || quest.rewards.isEmpty() || quest.disableJEI.get(ClientQuestFile.INSTANCE.defaultQuestDisableJEI) || (rewards = quest.rewards.stream().filter(reward -> reward.getAutoClaimType() != RewardAutoClaim.INVISIBLE && reward.getIngredient() != null).toList()).isEmpty()) continue;
                        this.wrappedQuestsCache.add(new WrappedQuest(quest, rewards));
                    }
                }
            }
        }
    }

    public void refresh() {
        this.needsRefresh = true;
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object object;
        if (recipeCategory instanceof QuestCategory && (object = focus.getTypedValue().getIngredient()) instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (stack.m_41720_() == FTBQuestsItems.BOOK.get() && focus.getRole() == RecipeIngredientRole.CATALYST) {
                return this.getWrappedQuests();
            }
            return switch (focus.getRole()) {
                case RecipeIngredientRole.INPUT -> this.findQuestsWithInput(stack);
                case RecipeIngredientRole.OUTPUT -> this.findQuestsWithOutput(stack);
                default -> Collections.emptyList();
            };
        }
        return Collections.emptyList();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof QuestCategory) {
            return this.getWrappedQuests();
        }
        return Collections.emptyList();
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        Object value = focus.getTypedValue().getIngredient();
        if (!(value instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ItemStack stack = (ItemStack)value;
        if (focus.getRole() == RecipeIngredientRole.INPUT && stack.m_41720_() == FTBQuestsItems.BOOK.get()) {
            return List.of(JEIRecipeTypes.QUEST);
        }
        return Collections.emptyList();
    }

    private List<WrappedQuest> findQuestsWithInput(ItemStack stack) {
        return this.getWrappedQuests().stream().filter(q -> q.hasInput(stack)).toList();
    }

    private List<WrappedQuest> findQuestsWithOutput(ItemStack stack) {
        return this.getWrappedQuests().stream().filter(q -> q.hasOutput(stack)).toList();
    }
}

