/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIIntegration;
import dev.ftb.mods.ftbquests.integration.jei.LootCrateCategory;
import dev.ftb.mods.ftbquests.integration.jei.WrappedLootCrate;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;

public enum LootCrateRecipeManagerPlugin implements IRecipeManagerPlugin
{
    INSTANCE;

    private final List<WrappedLootCrate> wrappedLootCratesCache = new ArrayList<WrappedLootCrate>();
    private final List<ItemStack> crates = new ArrayList<ItemStack>();
    private boolean needsRefresh = true;

    List<WrappedLootCrate> getWrappedLootCrates() {
        if (this.needsRefresh) {
            this.rebuildWrappedLootCrateCache();
            this.needsRefresh = false;
        }
        return this.wrappedLootCratesCache;
    }

    public void refresh() {
        this.needsRefresh = true;
    }

    public void rebuildWrappedLootCrateCache() {
        if (FTBQuestsJEIIntegration.runtime == null) {
            return;
        }
        if (!this.crates.isEmpty()) {
            FTBQuestsJEIIntegration.runtime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.crates);
        }
        this.wrappedLootCratesCache.clear();
        this.crates.clear();
        if (ClientQuestFile.exists()) {
            for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
                if (table.lootCrate == null) continue;
                WrappedLootCrate wrapper = new WrappedLootCrate(table.lootCrate);
                this.wrappedLootCratesCache.add(wrapper);
                this.crates.add(table.lootCrate.createStack());
            }
        }
        if (!this.crates.isEmpty()) {
            FTBQuestsJEIIntegration.runtime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.crates);
        }
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        return List.of();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object object;
        if (recipeCategory instanceof LootCrateCategory && (object = focus.getTypedValue().getIngredient()) instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (stack.m_41720_() == FTBQuestsItems.LOOTCRATE.get() && focus.getRole() == RecipeIngredientRole.CATALYST) {
                return this.getWrappedLootCrates();
            }
            return switch (focus.getRole()) {
                case RecipeIngredientRole.INPUT -> this.findCratesWithInput(stack);
                case RecipeIngredientRole.OUTPUT -> this.findCratesWithOutput(stack);
                default -> Collections.emptyList();
            };
        }
        return Collections.emptyList();
    }

    private List<WrappedLootCrate> findCratesWithInput(ItemStack stack) {
        return this.getWrappedLootCrates().stream().filter(c -> ItemStack.m_41746_((ItemStack)c.crateStack, (ItemStack)stack)).toList();
    }

    private List<WrappedLootCrate> findCratesWithOutput(ItemStack stack) {
        return this.getWrappedLootCrates().stream().filter(c -> c.outputs.stream().anyMatch(s1 -> ItemStack.m_41746_((ItemStack)s1, (ItemStack)stack))).toList();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof LootCrateCategory) {
            return this.getWrappedLootCrates();
        }
        return Collections.emptyList();
    }
}

