/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradedtools.utils;

import com.rolfmao.upgradedcore.init.ModTags;
import com.rolfmao.upgradedtools.init.ModEnchantments;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class BlocksPosUtil {
    public static Stream<BlockPos> getBlocks(Level level, BlockPos blockPos, Player player, Boolean removeTarget) {
        ItemStack heldItem = player.m_21205_();
        Vec3 eyePosition = player.m_146892_();
        Vec3 rotation = player.m_20252_(1.0f);
        double reachDist = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        BlockHitResult rayTraceResult = level.m_45547_(new ClipContext(player.m_146892_(), eyePosition.m_82520_(rotation.f_82479_ * reachDist, rotation.f_82480_ * reachDist, rotation.f_82481_ * reachDist), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction direction = rayTraceResult.m_82434_();
            boolean isX = direction.m_122429_() == 0;
            boolean isY = direction.m_122430_() == 0;
            boolean isZ = direction.m_122431_() == 0;
            BlockPos firstBlockPos = null;
            BlockPos lastBlockPos = null;
            if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.HAMMER_TIME.get()), (ItemStack)heldItem) > 2) {
                firstBlockPos = new BlockPos(isX ? -1 : -1, isY ? -1 : -1, isZ ? -1 : -1);
                lastBlockPos = new BlockPos(isX ? 1 : 1, isY ? 1 : 1, isZ ? 1 : 1);
            } else if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.HAMMER_TIME.get()), (ItemStack)heldItem) > 1) {
                firstBlockPos = new BlockPos(isX ? -1 : 0, isY ? -1 : 0, isZ ? -1 : 0);
                lastBlockPos = new BlockPos(isX ? 1 : -direction.m_122429_(), isY ? 1 : -direction.m_122430_(), isZ ? 1 : -direction.m_122431_());
            } else if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.HAMMER_TIME.get()), (ItemStack)heldItem) > 0) {
                firstBlockPos = new BlockPos(isX ? -1 : 0, isY ? -1 : 0, isZ ? -1 : 0);
                lastBlockPos = new BlockPos(isX ? 1 : 0, isY ? 1 : 0, isZ ? 1 : 0);
            }
            if (firstBlockPos != null && lastBlockPos != null) {
                ArrayList<BlockPos> getExtraBlocks = new ArrayList<BlockPos>();
                for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)blockPos.m_121955_((Vec3i)firstBlockPos), (BlockPos)blockPos.m_121955_((Vec3i)lastBlockPos))) {
                    if (!level.m_8055_(blockpos1).m_204336_(ModTags.MINEABLE_WITH_HAMMER)) continue;
                    getExtraBlocks.add(blockpos1.m_7949_());
                }
                if (removeTarget.booleanValue()) {
                    getExtraBlocks.removeIf(arg_0 -> ((BlockPos)blockPos).equals(arg_0));
                }
                return getExtraBlocks.stream();
            }
        }
        return Stream.empty();
    }
}

