/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradedtools.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.rolfmao.upgradedcore.init.ModTags;
import com.rolfmao.upgradedtools.utils.BlocksPosUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradedtools", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    @SubscribeEvent
    public void renderBlockHighlights(RenderHighlightEvent.Block event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null || player.m_150110_().f_35937_ || player.m_6047_()) {
            return;
        }
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        ItemStack heldItem = player.m_21205_();
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK || heldItem.m_41619_()) {
            return;
        }
        BlockHitResult target = event.getTarget();
        BlockPos targetBlockPos = target.m_82425_();
        BlockState blockState = level.m_8055_(targetBlockPos);
        if (!blockState.m_204336_(ModTags.MINEABLE_WITH_HAMMER) || !(blockState.m_60800_((BlockGetter)level, targetBlockPos) > 0.0f)) {
            return;
        }
        Iterator blocksPos = BlocksPosUtil.getBlocks((Level)level, targetBlockPos, (Player)player, true).iterator();
        if (!blocksPos.hasNext()) {
            return;
        }
        LevelRenderer levelRenderer = event.getLevelRenderer();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = levelRenderer.f_109464_.m_110104_();
        VertexConsumer vertexBuilder = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        Camera mainCamera = Minecraft.m_91087_().f_91063_.m_109153_();
        Entity mainCameraEntity = mainCamera.m_90592_();
        Vec3 vec3 = mainCamera.m_90583_();
        double x = vec3.m_7096_();
        double y = vec3.m_7098_();
        double z = vec3.m_7094_();
        do {
            BlockPos blockPos = (BlockPos)blocksPos.next();
            if (!level.m_6857_().m_61937_(blockPos) || blockPos == targetBlockPos) continue;
            levelRenderer.m_109637_(poseStack, vertexBuilder, mainCameraEntity, x, y, z, blockPos, level.m_8055_(blockPos));
        } while (blocksPos.hasNext());
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }

    @SubscribeEvent
    static void renderBlockDamageProgress(RenderLevelLastEvent event) {
        MultiPlayerGameMode multiPlayerGameMode = Minecraft.m_91087_().f_91072_;
        if (multiPlayerGameMode == null || !multiPlayerGameMode.m_105296_()) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null || player.m_150110_().f_35937_ || player.m_6047_() || Minecraft.m_91087_().m_91288_() == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41619_()) {
            return;
        }
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos targetBlockPos = blockHitResult.m_82425_();
        BlockDestructionProgress destructionProgress = null;
        for (Int2ObjectMap.Entry entry : Minecraft.m_91087_().f_91060_.f_109408_.int2ObjectEntrySet()) {
            if (!((BlockDestructionProgress)entry.getValue()).m_139985_().equals((Object)targetBlockPos)) continue;
            destructionProgress = (BlockDestructionProgress)entry.getValue();
            break;
        }
        if (destructionProgress == null) {
            return;
        }
        BlockState blockState = level.m_8055_(targetBlockPos);
        if (!blockState.m_204336_(ModTags.MINEABLE_WITH_HAMMER) || !(blockState.m_60800_((BlockGetter)level, targetBlockPos) > 0.0f)) {
            return;
        }
        Iterator extraBlocks = BlocksPosUtil.getBlocks((Level)level, targetBlockPos, (Player)player, true).iterator();
        if (!extraBlocks.hasNext()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        MultiBufferSource.BufferSource bufferSource = event.getLevelRenderer().f_109464_.m_110108_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_((RenderType)ModelBakery.f_119229_.get(destructionProgress.m_139988_()));
        Camera mainCamera = Minecraft.m_91087_().f_91063_.m_109153_();
        double x = mainCamera.m_90583_().f_82479_;
        double y = mainCamera.m_90583_().f_82480_;
        double z = mainCamera.m_90583_().f_82481_;
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
        do {
            BlockPos blockPos = (BlockPos)extraBlocks.next();
            poseStack.m_85836_();
            poseStack.m_85837_((double)blockPos.m_123341_() - x, (double)blockPos.m_123342_() - y, (double)blockPos.m_123343_() - z);
            PoseStack.Pose pose = poseStack.m_85850_();
            SheetedDecalTextureGenerator vertexConsumer1 = new SheetedDecalTextureGenerator(vertexConsumer, pose.m_85861_(), pose.m_85864_());
            blockRenderDispatcher.m_110918_(level.m_8055_(blockPos), blockPos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)vertexConsumer1);
            poseStack.m_85849_();
        } while (extraBlocks.hasNext());
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }
}

