/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradedtools.content;

import com.rolfmao.upgradedcore.base.HammerItem;
import com.rolfmao.upgradedcore.compat.ExternalMods;
import com.rolfmao.upgradedcore.helpers.TooltipHelper;
import com.rolfmao.upgradedcore.init.ModTags;
import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import com.rolfmao.upgradednetherite.utils.ToolUtil;
import com.rolfmao.upgradednetherite.utils.check.CorruptUtil;
import com.rolfmao.upgradednetherite_creative.config.UpgradedNetheriteCreativeConfig;
import com.rolfmao.upgradednetherite_creative.utils.CreativeUtil;
import com.rolfmao.upgradednetherite_ultimate.config.UpgradedNetheriteUltimateConfig;
import com.rolfmao.upgradedtools.init.ModEnchantmentCategory;
import com.rolfmao.upgradedtools.init.ModItems;
import com.rolfmao.upgradedtools.utils.BlocksPosUtil;
import com.rolfmao.upgradedtools.utils.check.ToolCorruptUtil;
import com.rolfmao.upgradedtools.utils.check.ToolCreativeUtil;
import com.rolfmao.upgradedtools.utils.check.ToolEchoUtil;
import com.rolfmao.upgradedtools.utils.check.ToolEnderUtil;
import com.rolfmao.upgradedtools.utils.check.ToolFeatherUtil;
import com.rolfmao.upgradedtools.utils.check.ToolFireUtil;
import com.rolfmao.upgradedtools.utils.check.ToolGoldUtil;
import com.rolfmao.upgradedtools.utils.check.ToolPhantomUtil;
import com.rolfmao.upgradedtools.utils.check.ToolPoisonUtil;
import com.rolfmao.upgradedtools.utils.check.ToolUltimateUtil;
import com.rolfmao.upgradedtools.utils.check.ToolWaterUtil;
import com.rolfmao.upgradedtools.utils.check.ToolWitherUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class Hammer
extends HammerItem {
    public Hammer(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, (float)attackDamageIn, attackSpeedIn, builderIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.m_5456_() == ModItems.CORRUPT_UPGRADED_NETHERITE_HAMMER.get() && enchantment == Enchantments.f_44962_) {
            return false;
        }
        if (enchantment.f_44672_.equals((Object)ModEnchantmentCategory.HAMMER)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean p_77663_5_) {
        Map enchantments;
        if (stack.m_41720_() == ModItems.CORRUPT_UPGRADED_NETHERITE_HAMMER.get() && stack.m_41793_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0 && (enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).containsKey(Enchantments.f_44962_)) {
            enchantments.remove(Enchantments.f_44962_);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
        }
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        if (!level.f_46443_ && !player.m_150110_().f_35937_ && !player.m_6047_() && level.m_8055_(blockPos).m_204336_(ModTags.MINEABLE_WITH_HAMMER)) {
            ItemStack heldItem = player.m_21205_();
            Stream<BlockPos> blocksPos = BlocksPosUtil.getBlocks(level, blockPos, player, true);
            blocksPos.forEach(pos -> {
                BlockState blockState1 = level.m_8055_(pos);
                if (blockState1.m_204336_(ModTags.MINEABLE_WITH_HAMMER) && level.m_8055_(blockPos).m_60800_((BlockGetter)level, blockPos) > 0.0f) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (player.m_150110_().f_35937_) {
                        if (blockState1.onDestroyedByPlayer(level, pos, player, true, blockState1.m_60819_())) {
                            blockState1.m_60734_().m_6786_((LevelAccessor)level, pos, blockState1);
                        }
                    } else {
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, blockState1, player);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled()) {
                            Packet packet;
                            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
                            BlockEntity blockEntity = level.m_7702_(pos);
                            if (blockEntity != null && (packet = blockEntity.m_58483_()) != null) {
                                serverPlayer.f_8906_.m_9829_(packet);
                            }
                        } else {
                            heldItem.m_41720_().m_6813_(heldItem, level, blockState1, pos, (LivingEntity)player);
                            BlockEntity blockEntity = level.m_7702_(pos);
                            blockState1.m_60734_().m_6786_((LevelAccessor)level, pos, blockState1);
                            blockState1.m_60734_().m_6240_(level, player, pos, blockState1, blockEntity, heldItem);
                            blockState1.m_60734_().m_49805_((ServerLevel)level, pos, event.getExpToDrop());
                            level.m_7471_(pos, false);
                            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState1));
                            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
                        }
                    }
                }
            });
        }
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        if (ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && UpgradedNetheriteCreativeConfig.EnableCreativeUnbreakable && this.m_5456_() == ModItems.CREATIVE_UPGRADED_NETHERITE_HAMMER.get()) {
            return false;
        }
        return this.m_5456_().m_41465_();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_220152_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            if (ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.IRON_HAMMER.get()))) {
                list.add((Object)stack);
            } else if (ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.GOLD_HAMMER.get()))) {
                list.add((Object)stack);
            } else if (ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.DIAMOND_HAMMER.get()))) {
                list.add((Object)stack);
            } else if (ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.NETHERITE_HAMMER.get()))) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolGoldUtil.isGoldToolOrWeapon(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolFireUtil.isFireTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolEnderUtil.isEnderTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolWaterUtil.isWaterTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolWitherUtil.isWitherTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolPoisonUtil.isPoisonTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolPhantomUtil.isPhantomTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolFeatherUtil.isFeatherTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolEchoUtil.isEchoTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolCorruptUtil.isCorruptTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE_ULTIMATE.isLoaded() && ToolUltimateUtil.isUltimateTool(stack)) {
                list.add((Object)stack);
            } else if (ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && ToolCreativeUtil.isCreativeTool(stack)) {
                list.add((Object)stack);
            } else if (tab == CreativeModeTab.f_40754_) {
                list.add((Object)stack);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && player.m_6047_() && !player.m_36335_().m_41519_(stack.m_41720_()) && ToolUtil.isUsingEffectTool((Player)player)) {
            ToolUtil.toggleDisableEffect((Player)player);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult iResult = super.m_6225_(context);
        if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && iResult == InteractionResult.PASS && context.m_43723_() != null && context.m_43723_().m_6047_() && ToolEnderUtil.isEnderToolOrWeapon(context.m_43722_()) && !context.m_43723_().m_36335_().m_41519_(context.m_43722_().m_41720_())) {
            iResult = ToolUtil.EnderSetTag((UseOnContext)context);
        }
        if (iResult == InteractionResult.PASS) {
            iResult = super.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return iResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!(!ExternalMods.UPGRADEDNETHERITE.isLoaded() || UpgradedNetheriteConfig.DisableTooltips || ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.IRON_HAMMER.get())) || ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.GOLD_HAMMER.get())) || ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.DIAMOND_HAMMER.get())) || ItemStack.m_41758_((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.NETHERITE_HAMMER.get())))) {
            if (Screen.m_96638_()) {
                if (ExternalMods.UPGRADEDNETHERITE_ULTIMATE.isLoaded() && ToolUltimateUtil.isUltimateToolOrWeapon(stack)) {
                    if (!((!UpgradedNetheriteUltimateConfig.EnableUltimateGoldToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableGold")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateFireToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableFire")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateEnderToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableEnder")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateWaterToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableWater")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateWitherToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableWither")) && (!UpgradedNetheriteUltimateConfig.EnableUltimatePoisonToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisablePoison")) && (!UpgradedNetheriteUltimateConfig.EnableUltimatePhantomToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisablePhantom")) && (!UpgradedNetheriteUltimateConfig.EnableUltimateFeatherToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableFeather")))) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.BonusFrom.TT"));
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateGoldToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableGold"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Golderite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateFireToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableFire"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Blazerite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateEnderToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableEnder"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Enderite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateWaterToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableWater"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Prismarite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateWitherToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableWither"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Witherite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimatePoisonToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisablePoison"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Spiderite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimatePhantomToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisablePhantom"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Phanterite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateFeatherToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableFeather"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Featherite.TT"));
                        }
                        if (!(!UpgradedNetheriteUltimateConfig.EnableUltimateEchoToolEffect || stack.m_41782_() && stack.m_41783_().m_128441_("UpgradedNetherite_DisableEcho"))) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_ultimate.Echorite.TT"));
                        }
                        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("UpgradedNetherite_Tagged") && stack.m_41783_().m_128471_("UpgradedNetherite_Tagged") && (!stack.m_41782_() || !stack.m_41783_().m_128441_("UpgradedNetherite_DisableEnder"))) {
                            String world = worldIn.m_46472_().m_135782_().m_135815_();
                            if (!world.equals(stack.m_41783_().m_128461_("UpgradedNetherite_Dimension"))) {
                                tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Target.TT"));
                                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Ender_Dim.TT"));
                                tooltip.add((Component)Component.m_237113_((String)("\u00a77\u2022 \u00a7c" + stack.m_41783_().m_128461_("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[2] + "\u00a77.")));
                            } else {
                                tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Target.TT"));
                                tooltip.add((Component)Component.m_237113_((String)("\u00a77\u2022 \u00a79" + stack.m_41783_().m_128461_("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[2] + "\u00a77.")));
                            }
                        }
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolGoldUtil.isGoldToolOrWeapon(stack) && (UpgradedNetheriteConfig.EnableDamageBonusGoldWeapon || UpgradedNetheriteConfig.EnableFortuneBonus || UpgradedNetheriteConfig.EnableLootingBonus)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusGoldWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusGoldWeapon + "%"});
                    }
                    float EnchantBonusFortune = 0.0f;
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.f_44987_)) {
                        int EnchantLevel = (Integer)enchantments.get(Enchantments.f_44987_);
                        EnchantBonusFortune = EnchantLevel;
                    }
                    float EnchantBonusLooting = 0.0f;
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.f_44982_)) {
                        int EnchantLevel = (Integer)enchantments.get(Enchantments.f_44982_);
                        EnchantBonusLooting = EnchantLevel;
                    }
                    if (UpgradedNetheriteConfig.EnableFortuneBonus) {
                        if (EnchantBonusFortune >= 3.0f) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Tool.TT", (Object[])new Object[]{"\u00a76" + (UpgradedNetheriteConfig.FortuneBonus + UpgradedNetheriteConfig.FortuneEnchantBonus)});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Tool.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.FortuneBonus});
                        }
                    }
                    if (UpgradedNetheriteConfig.EnableLootingBonus) {
                        if (EnchantBonusLooting >= 3.0f) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon2.TT", (Object[])new Object[]{"\u00a76" + (UpgradedNetheriteConfig.LootingBonus + UpgradedNetheriteConfig.LootingEnchantBonus)});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.LootingBonus});
                        }
                    }
                    if (EnchantBonusFortune < 3.0f && UpgradedNetheriteConfig.EnableFortuneBonus) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Tool2.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.FortuneEnchantBonus});
                    }
                    if (EnchantBonusLooting < 3.0f && UpgradedNetheriteConfig.EnableLootingBonus) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Gold_Weapon3.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.LootingEnchantBonus});
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolFireUtil.isFireToolOrWeapon(stack) && (UpgradedNetheriteConfig.EnableDamageBonusFireWeapon || UpgradedNetheriteConfig.EnableAutoSmelt)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusFireWeapon) {
                        float EnchantBonus = 0.0f;
                        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                        if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.f_44981_)) {
                            int EnchantLevel = (Integer)enchantments.get(Enchantments.f_44981_);
                            EnchantBonus = EnchantLevel;
                        }
                        if (EnchantBonus >= 2.0f) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Weapon.TT", (Object[])new Object[]{"\u00a76" + (UpgradedNetheriteConfig.DamageBonusFireWeapon + UpgradedNetheriteConfig.DamageBonusFireEnchantWeapon) + "%"});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusFireWeapon + "%"});
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Weapon2.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.DamageBonusFireEnchantWeapon + "%"});
                        }
                    }
                    if (UpgradedNetheriteConfig.EnableAutoSmelt) {
                        if (ToolUtil.getDisableEffect((ItemStack)stack)) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Fire_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                        }
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolEnderUtil.isEnderToolOrWeapon(stack)) {
                    if (UpgradedNetheriteConfig.EnablePreventTeleport) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.OnHit.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Ender_Weapon.TT"));
                    }
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusEnderWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Ender_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusEnderWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableDoubleLootingBonusEnderWeapon) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Ender_Weapon3.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableTeleportChest) {
                        if (ToolUtil.getDisableEffect((ItemStack)stack)) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Ender_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Ender_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                        }
                        if (stack.m_41783_().m_128471_("UpgradedNetherite_Tagged")) {
                            String world = worldIn.m_46472_().m_135782_().m_135815_();
                            if (!world.equals(stack.m_41783_().m_128461_("UpgradedNetherite_Dimension"))) {
                                tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Target.TT"));
                                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Ender_Dim.TT"));
                                tooltip.add((Component)Component.m_237113_((String)("\u00a77\u2022 \u00a7c" + stack.m_41783_().m_128461_("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[2] + "\u00a77.")));
                            } else {
                                tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Target.TT"));
                                tooltip.add((Component)Component.m_237113_((String)("\u00a77\u2022 \u00a79" + stack.m_41783_().m_128461_("UpgradedNetherite_Dimension") + "\u00a77 : \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[0] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[1] + "\u00a77, \u00a73" + stack.m_41783_().m_128465_("UpgradedNetherite_Position")[2] + "\u00a77.")));
                            }
                        }
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolWaterUtil.isWaterToolOrWeapon(stack) && (UpgradedNetheriteConfig.EnableDamageBonusWaterWeapon || UpgradedNetheriteConfig.EnableDamageBonusWaterEndermanWeapon || UpgradedNetheriteConfig.EnableMiningSpeedUnderwater)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusWaterWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Water_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusWaterWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusWaterEndermanWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Water_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusWaterEndermanWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableMiningSpeedUnderwater) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Water_Tool.TT"));
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolWitherUtil.isWitherToolOrWeapon(stack)) {
                    if (UpgradedNetheriteConfig.EnableWitherEffect) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.OnHit.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Wither_Weapon.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusWitherWeapon) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Wither_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusWitherWeapon + "%"});
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolPoisonUtil.isPoisonToolOrWeapon(stack)) {
                    if (UpgradedNetheriteConfig.EnablePoisonEffect) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.OnHit.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Poison_Weapon.TT"));
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusPoisonWeapon) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Poison_Weapon2.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusPoisonWeapon + "%"});
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolPhantomUtil.isPhantomToolOrWeapon(stack) && (UpgradedNetheriteConfig.EnableDamageBonusPhantomWeapon || UpgradedNetheriteConfig.EnableGlowingEffect || UpgradedNetheriteConfig.EnableReachEffect)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusPhantomWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusPhantomWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableGlowingEffect) {
                        if (ToolUtil.getDisableEffect((ItemStack)stack)) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                        } else {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Phantom_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                        }
                    }
                    if (UpgradedNetheriteConfig.EnableReachEffect) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Phantom_Tool2.TT"));
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolFeatherUtil.isFeatherToolOrWeapon(stack) && UpgradedNetheriteConfig.EnableAttractItem) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (ToolUtil.getDisableEffect((ItemStack)stack)) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Feather_Tool.TT", (Object[])new Object[]{"\u00a7c\u2022 "});
                    } else {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Feather_Tool.TT", (Object[])new Object[]{"\u00a77\u2022 "});
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolEchoUtil.isEchoToolOrWeapon(stack) && (UpgradedNetheriteConfig.EnableDamageBonusEchoWeapon || UpgradedNetheriteConfig.EnableBonusExpEcho)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusEchoWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Echo_Weapon.TT", (Object[])new Object[]{"\u00a76" + UpgradedNetheriteConfig.DamageBonusEchoWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableBonusExpEcho) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Echo_Tool2.TT", (Object[])new Object[0]);
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolCorruptUtil.isCorruptToolOrWeapon(stack)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Malus.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Corrupt_Bonus2.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Corrupt_Enchant.TT"));
                    if (UpgradedNetheriteConfig.EnableDamageBonusCorruptWeapon || UpgradedNetheriteConfig.EnableLootingBonusCorruptWeapon || UpgradedNetheriteConfig.EnableFortuneBonusCorruptTool) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    }
                    if (Minecraft.m_91087_().f_91074_ != null && CorruptUtil.intWearingCorrupt((Player)Minecraft.m_91087_().f_91074_, (Boolean)true) > 0) {
                        if (UpgradedNetheriteConfig.EnableDamageBonusCorruptWeapon) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon3.TT", (Object[])new Object[]{"\u00a76" + CorruptUtil.intWearingCorrupt((Player)Minecraft.m_91087_().f_91074_, (Boolean)true) * UpgradedNetheriteConfig.DamageBonusCorruptWeapon + "%"});
                        }
                        if (UpgradedNetheriteConfig.EnableLootingBonusCorruptWeapon) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon4.TT", (Object[])new Object[]{"\u00a76" + CorruptUtil.intWearingCorrupt((Player)Minecraft.m_91087_().f_91074_, (Boolean)true) * UpgradedNetheriteConfig.LootingBonusCorruptWeapon});
                        }
                        if (UpgradedNetheriteConfig.EnableFortuneBonusCorruptTool) {
                            TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Tool2.TT", (Object[])new Object[]{"\u00a76" + CorruptUtil.intWearingCorrupt((Player)Minecraft.m_91087_().f_91074_, (Boolean)true) * UpgradedNetheriteConfig.FortuneBonusCorruptTool});
                        }
                    }
                    float EnchantBonus = 0.0f;
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                    if (!enchantments.isEmpty() && enchantments.containsKey(Enchantments.f_44982_)) {
                        int EnchantLevel = (Integer)enchantments.get(Enchantments.f_44982_);
                        EnchantBonus = EnchantLevel;
                    }
                    if (UpgradedNetheriteConfig.EnableDamageBonusCorruptWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon2.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.DamageBonusCorruptWeapon + "%"});
                    }
                    if (UpgradedNetheriteConfig.EnableLootingBonusCorruptWeapon) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Weapon.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.LootingBonusCorruptWeapon});
                    }
                    if (UpgradedNetheriteConfig.EnableFortuneBonusCorruptTool) {
                        TooltipHelper.addTWO(tooltip, (String)"upgradednetherite.Corrupt_Tool.TT", (Object[])new Object[]{"\u00a7d" + UpgradedNetheriteConfig.FortuneBonusCorruptTool});
                    }
                } else if (ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && CreativeUtil.isCreativeTool((ItemStack)stack)) {
                    if (UpgradedNetheriteCreativeConfig.EnableCreativeInstaKill || UpgradedNetheriteCreativeConfig.EnableCreativeInstaBreak) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                        if (UpgradedNetheriteCreativeConfig.EnableCreativeInstaKill || UpgradedNetheriteCreativeConfig.EnableCreativeInstaKill) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_creative.Creative_Bonus_Weapon.TT"));
                        }
                        if (UpgradedNetheriteCreativeConfig.EnableCreativeInstaKill || UpgradedNetheriteCreativeConfig.EnableCreativeInstaBreak) {
                            tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_creative.Creative_Bonus_Tool.TT"));
                        }
                    }
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Disabled.TT"));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                tooltip.add((Component)Component.m_237115_((String)"upgradedtools.HoldShift.TT"));
                if (ExternalMods.UPGRADEDNETHERITE.isLoaded() && ToolEnderUtil.isEnderToolOrWeapon(stack)) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradedtools.Blank.TT"));
                    if (stack.m_41783_() != null && stack.m_41783_().m_128441_("UpgradedNetherite_Tagged") && stack.m_41783_().m_128471_("UpgradedNetherite_Tagged")) {
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Ender_ToolTar.TT"));
                    } else {
                        tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Ender_ToolReq.TT"));
                    }
                }
            }
        }
    }
}

