/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.Tools;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class BaseBlockStateProvider
extends BlockStateProvider {
    public static final ResourceLocation RFTOOLSBASE_SIDE = new ResourceLocation("rftoolsbase", "block/base/machineside");
    public static final ResourceLocation RFTOOLSBASE_TOP = new ResourceLocation("rftoolsbase", "block/base/machinetop");
    public static final ResourceLocation RFTOOLSBASE_BOTTOM = new ResourceLocation("rftoolsbase", "block/base/machinebottom");

    public String name(Block block) {
        return Tools.getId(block).m_135815_();
    }

    public BaseBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    public void simpleBlockC(Block block, Consumer<BlockModelBuilder> consumer) {
        BlockModelBuilder blockModelBuilder = (BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block));
        consumer.accept(blockModelBuilder);
        this.simpleBlock(block, (ModelFile)blockModelBuilder);
    }

    public ModelFile frontBasedModel(String modelName, ResourceLocation texture) {
        return this.frontBasedModel(modelName, texture, RFTOOLSBASE_SIDE, RFTOOLSBASE_TOP, RFTOOLSBASE_BOTTOM);
    }

    public ModelFile frontBasedModel(String modelName, ResourceLocation front, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return ((BlockModelBuilder)this.models().cube(modelName, bottom, top, front, side, side, side)).texture("particle", front);
    }

    public ModelFile topBasedModel(String modelName, ResourceLocation texture) {
        return this.topBasedModel(modelName, texture, RFTOOLSBASE_SIDE, RFTOOLSBASE_BOTTOM);
    }

    public ModelFile topBasedModel(String modelName, ResourceLocation top, ResourceLocation side, ResourceLocation bottom) {
        return ((BlockModelBuilder)this.models().cube(modelName, bottom, top, side, side, side, side)).texture("particle", top);
    }

    private ModelFile logicSlabModel(String modelName, ResourceLocation texture, ModelBuilder.FaceRotation faceRotation) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/" + modelName)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 4.0f, 16.0f).face(Direction.DOWN).cullface(Direction.DOWN).texture("#down").end().face(Direction.UP).texture("#up").uvs(0.0f, 0.0f, 16.0f, 16.0f).rotation(faceRotation).end().face(Direction.EAST).cullface(Direction.EAST).texture("#side").end().face(Direction.WEST).cullface(Direction.WEST).texture("#side").end().face(Direction.NORTH).cullface(Direction.NORTH).texture("#side").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#side").end().end()).texture("side", new ResourceLocation("rftoolsbase", "block/base/machineside"))).texture("down", RFTOOLSBASE_BOTTOM)).texture("up", texture)).texture("particle", texture);
        return model;
    }

    public void logicSlabBlock(LogicSlabBlock block, String modelPrefix, ResourceLocation topTexture) {
        ModelFile[] models = this.getLogicSlabModels(modelPrefix, topTexture);
        this.variantBlock(block, state -> models[((LogicFacing)((Object)((Object)state.m_61143_(LogicSlabBlock.LOGIC_FACING)))).getRotationStep()], state -> this.getXRotation(((LogicFacing)((Object)((Object)state.m_61143_(LogicSlabBlock.LOGIC_FACING)))).getSide()), state -> this.getYRotation(((LogicFacing)((Object)((Object)state.m_61143_(LogicSlabBlock.LOGIC_FACING)))).getSide()));
    }

    public ModelFile[] getLogicSlabModels(String modelPrefix, ResourceLocation topTexture) {
        ModelFile[] models = new ModelFile[]{this.logicSlabModel(modelPrefix + "_0", topTexture, ModelBuilder.FaceRotation.ZERO), this.logicSlabModel(modelPrefix + "_1", topTexture, ModelBuilder.FaceRotation.UPSIDE_DOWN), this.logicSlabModel(modelPrefix + "_2", topTexture, ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90), this.logicSlabModel(modelPrefix + "_3", topTexture, ModelBuilder.FaceRotation.CLOCKWISE_90)};
        return models;
    }

    public void variantBlock(Block block, Function<BlockState, ModelFile> modelSelector, Function<BlockState, Integer> xRotation, Function<BlockState, Integer> yRotation) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelSelector.apply((BlockState)state)).rotationX(((Integer)xRotation.apply((BlockState)state)).intValue()).rotationY(((Integer)yRotation.apply((BlockState)state)).intValue()).build());
    }

    public void variantBlock(Block block, Function<BlockState, ModelFile> modelSelector) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelSelector.apply((BlockState)state)).build());
    }

    public int getXRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> 0;
            case Direction.UP -> 180;
            case Direction.NORTH -> -90;
            case Direction.SOUTH -> 90;
            case Direction.WEST -> 90;
            case Direction.EAST -> 90;
        };
    }

    public int getYRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> 0;
            case Direction.UP -> 0;
            case Direction.NORTH -> 0;
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 90;
            case Direction.EAST -> 270;
        };
    }

    public void applyRotation(ConfiguredModel.Builder<?> builder, Direction direction) {
        this.applyRotationBld(builder, direction);
        builder.addModel();
    }

    private void applyRotationBld(ConfiguredModel.Builder<?> builder, Direction direction) {
        switch (direction) {
            case DOWN: {
                builder.rotationX(90);
                break;
            }
            case UP: {
                builder.rotationX(-90);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                builder.rotationY(180);
                break;
            }
            case WEST: {
                builder.rotationY(270);
                break;
            }
            case EAST: {
                builder.rotationY(90);
            }
        }
    }

    public void applyHorizRotation(ConfiguredModel.Builder<VariantBlockStateBuilder> builder, Direction direction) {
        this.applyHorizRotationBld(builder, direction);
        builder.addModel();
    }

    private void applyHorizRotationBld(ConfiguredModel.Builder<VariantBlockStateBuilder> builder, Direction direction) {
        switch (direction) {
            case SOUTH: {
                builder.rotationY(180);
                break;
            }
            case WEST: {
                builder.rotationY(270);
                break;
            }
            case EAST: {
                builder.rotationY(90);
            }
        }
    }

    public void singleTextureBlock(Block block, String modelName, String textureName) {
        ModelBuilder model = this.models().cubeAll(modelName, this.modLoc(textureName));
        this.simpleBlock(block, (ModelFile)model);
    }

    public void singleTextureBlockC(Block block, String modelName, String textureName, Consumer<BlockModelBuilder> consumer) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().cubeAll(modelName, this.modLoc(textureName));
        consumer.accept(builder);
        this.simpleBlock(block, (ModelFile)builder);
    }

    public VariantBlockStateBuilder horizontalOrientedBlock(Block block, ModelFile model) {
        return this.horizontalOrientedBlock(block, (BlockState blockState, ConfiguredModel.Builder<?> builder) -> builder.modelFile(model));
    }

    public VariantBlockStateBuilder horizontalOrientedBlock(Block block, BiConsumer<BlockState, ConfiguredModel.Builder<?>> model) {
        return this.directionBlock(block, model, BlockStateProperties.f_61374_);
    }

    public VariantBlockStateBuilder orientedBlock(Block block, ModelFile model) {
        return this.orientedBlock(block, (BlockState blockState, ConfiguredModel.Builder<?> builder) -> builder.modelFile(model));
    }

    public VariantBlockStateBuilder orientedBlock(Block block, BiConsumer<BlockState, ConfiguredModel.Builder<?>> model) {
        return this.directionBlock(block, model, BlockStateProperties.f_61372_);
    }

    private VariantBlockStateBuilder directionBlock(Block block, BiConsumer<BlockState, ConfiguredModel.Builder<?>> model, DirectionProperty directionProperty) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.forAllStates(state -> {
            ConfiguredModel.Builder bld = ConfiguredModel.builder();
            model.accept((BlockState)state, (ConfiguredModel.Builder<?>)bld);
            this.applyRotationBld(bld, (Direction)state.m_61143_((Property)directionProperty));
            return bld.build();
        });
        return builder;
    }

    public void createFrame(BlockModelBuilder dimCellFrame, String txtName, float thick) {
        this.createFrame(dimCellFrame, txtName, thick, true, true);
    }

    public void createFrame(BlockModelBuilder dimCellFrame, String txtName, float thick, boolean doTop, boolean doBottom) {
        this.innerCube(dimCellFrame, txtName, 0.0f, 0.0f, 0.0f, thick, 16.0f, thick);
        this.innerCube(dimCellFrame, txtName, 16.0f - thick, 0.0f, 0.0f, 16.0f, 16.0f, thick);
        this.innerCube(dimCellFrame, txtName, 0.0f, 0.0f, 16.0f - thick, thick, 16.0f, 16.0f);
        this.innerCube(dimCellFrame, txtName, 16.0f - thick, 0.0f, 16.0f - thick, 16.0f, 16.0f, 16.0f);
        if (doTop) {
            this.innerCube(dimCellFrame, txtName, thick, 16.0f - thick, 0.0f, 16.0f - thick, 16.0f, thick);
            this.innerCube(dimCellFrame, txtName, thick, 16.0f - thick, 16.0f - thick, 16.0f - thick, 16.0f, 16.0f);
            this.innerCube(dimCellFrame, txtName, 0.0f, 16.0f - thick, thick, thick, 16.0f, 16.0f - thick);
            this.innerCube(dimCellFrame, txtName, 16.0f - thick, 16.0f - thick, thick, 16.0f, 16.0f, 16.0f - thick);
        }
        if (doBottom) {
            this.innerCube(dimCellFrame, txtName, thick, 0.0f, 0.0f, 16.0f - thick, thick, thick);
            this.innerCube(dimCellFrame, txtName, thick, 0.0f, 16.0f - thick, 16.0f - thick, thick, 16.0f);
            this.innerCube(dimCellFrame, txtName, 0.0f, 0.0f, thick, thick, thick, 16.0f - thick);
            this.innerCube(dimCellFrame, txtName, 16.0f - thick, 0.0f, thick, 16.0f, thick, 16.0f - thick);
        }
    }

    public void innerCube(BlockModelBuilder builder, String txtName, float fx, float fy, float fz, float tx, float ty, float tz) {
        builder.element().from(fx, fy, fz).to(tx, ty, tz).allFaces((direction, faceBuilder) -> faceBuilder.texture(txtName)).end();
    }
}

