/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.dynamo;

import cofh.lib.api.StorageGroup;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.dynamo.GourmandFuelManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.dynamo.DynamoGourmandContainer;
import cofh.thermal.lib.block.entity.DynamoBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DynamoGourmandTile
extends DynamoBlockEntity {
    protected ItemStorageCoFH fuelSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && GourmandFuelManager.instance().validFuel(item));

    public DynamoGourmandTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.DYNAMO_GOURMAND_TILE.get(), pos, state);
        this.inventory.addSlot(this.fuelSlot, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return GourmandFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return GourmandFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) > 0;
    }

    protected void processStart() {
        this.fuelMax = Math.round((float)GourmandFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) * this.energyMod);
        this.fuel += this.fuelMax;
        this.fuelSlot.consume(1);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DynamoGourmandContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

