/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.util.java.Cast;

public class ReflectionUtil {
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    public static Class<?> getArrayComponent(Class<?> array) {
        return array.isArray() ? ReflectionUtil.getArrayComponent(array.getComponentType()) : array;
    }

    public static <T> Class<?> findCommonSuperClass(Collection<T> coll) {
        if (coll.isEmpty()) {
            return Void.class;
        }
        Class<?> oclass = null;
        for (T t : coll) {
            if (oclass == null) {
                oclass = t.getClass();
                continue;
            }
            oclass = ReflectionUtil.findClosestAncestor(oclass, t.getClass());
        }
        return oclass;
    }

    public static <T> Class<?> findCommonSuperClass(Collection<T> coll, Function<T, Class<?>> toClass) {
        if (coll.isEmpty()) {
            return Void.class;
        }
        Class<?> oclass = null;
        for (T t : coll) {
            if (oclass == null) {
                oclass = toClass.apply(t);
                continue;
            }
            oclass = ReflectionUtil.findClosestAncestor(oclass, toClass.apply(t));
        }
        return oclass;
    }

    public static Class<?> findClosestAncestor(Class<?> a, Class<?> b) {
        while (!a.isAssignableFrom(b)) {
            a = a.getSuperclass();
        }
        return a;
    }

    public static boolean doesParameterTypeArgsMatch(Parameter param, Class<?> ... baseArgs) {
        Type[] args = ReflectionUtil.getTypeArgs(param.getParameterizedType());
        if (args.length != baseArgs.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Class && baseArgs[i].isAssignableFrom((Class)args[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean doesParameterTypeArgsMatch(Field field, Class<?> ... baseArgs) {
        Type[] args = ReflectionUtil.getTypeArgs(field.getGenericType());
        if (args.length != baseArgs.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Class && baseArgs[i].isAssignableFrom((Class)args[i])) continue;
            return false;
        }
        return true;
    }

    public static Type[] getTypeArgs(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments();
        }
        return new Type[0];
    }

    public static Class<?> fetchClassAny(org.objectweb.asm.Type type) {
        return ReflectionUtil.fetchClass(type.getSort() < 9 ? type.getClassName() : type.getInternalName().replace('/', '.'));
    }

    public static <T> Class<T> fetchClass(org.objectweb.asm.Type type) {
        return ReflectionUtil.fetchClass(type.getSort() < 9 ? type.getClassName() : type.getInternalName().replace('/', '.'));
    }

    public static <T> Class<T> fetchClass(String name) {
        block3: {
            try {
                return (Class)Cast.cast(Class.forName(name));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (RuntimeException e) {
                if (!e.getMessage().contains("invalid dist")) break block3;
                HammerLib.LOG.warn("Attempted to load class from invalid dist: " + name, (Throwable)e);
            }
        }
        return null;
    }

    public static Iterable<Field> getFieldsUpTo(@Nonnull Class<?> startClass, @Nullable Class<?> exclusiveParent) {
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List parentClassFields = (List)ReflectionUtil.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    @Deprecated
    public static boolean setStaticFinalField(Class<?> cls, String var, Object val) {
        try {
            return ReflectionUtil.setStaticFinalField(cls.getDeclaredField(var), val);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static boolean setStaticFinalField(Field f, Object val) {
        try {
            if (Modifier.isStatic(f.getModifiers())) {
                return ReflectionUtil.setFinalField(f, null, val);
            }
            return false;
        }
        catch (Throwable err) {
            err.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static boolean setFinalField(Field f, @Nullable Object instance, Object thing) throws ReflectiveOperationException {
        if (Modifier.isFinal(f.getModifiers())) {
            ReflectionUtil.makeWritable(f);
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, f, false);
            fieldAccessorSet.invoke(fieldAccessor, instance, thing);
            return true;
        }
        f.set(instance, thing);
        return false;
    }

    @Deprecated
    private static Field makeWritable(Field f) throws ReflectiveOperationException {
        f.setAccessible(true);
        if (modifiersField == null) {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
        }
        modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        return f;
    }

    public static Object lookupValue(Object object, Class<?> type) {
        Field field = ReflectionUtil.lookupField(object.getClass(), type);
        if (field == null) {
            return null;
        }
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field lookupField(Class<?> clazz, Class<?> type) {
        Field ret = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            if (ret != null) {
                return null;
            }
            field.setAccessible(true);
            ret = field;
        }
        return ret;
    }

    public static List<Field> lookupFields(Class<?> clazz, Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        return fields;
    }

    public static Field lookupField(Class<?> clazz, String name) {
        Field ret = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            if (ret != null) {
                return null;
            }
            field.setAccessible(true);
            ret = field;
        }
        return ret;
    }

    public static <T> Optional<T> fetchValue(Field field, Object instance, Class<T> targetType) {
        try {
            field.setAccessible(true);
            return Cast.optionally(field.get(instance), targetType);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static Class<?> getCaller() {
        try {
            return Class.forName(Thread.currentThread().getStackTrace()[1].getClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Optional<T> getField(Object anything, int i, Class<T> cast) {
        try {
            Field f = anything.getClass().getDeclaredFields()[i];
            f.setAccessible(true);
            return Cast.optionally(f.get(anything), cast);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static <T> Optional<T> getStaticFinalField(Class<?> owner, String member) {
        try {
            Field f = owner.getDeclaredField(member);
            f.setAccessible(true);
            return Optional.ofNullable(Cast.cast(f.get(null)));
        }
        catch (ReflectiveOperationException e) {
            if (!(e instanceof NoSuchFieldException)) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static Method findDeclaredMethod(Class<?> c, String member, Predicate<Method> o) throws NoSuchMethodException {
        for (Method method : c.getDeclaredMethods()) {
            if (!method.getName().equals(member) || !o.test(method)) continue;
            return method;
        }
        throw new NoSuchMethodException(c.getName() + "/" + member);
    }
}

