/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class Hashers {
    public static final Hashers MD5 = new Hashers("MD5");
    public static final Hashers SHA1 = new Hashers("SHA1");
    public static final Hashers SHA256 = new Hashers("SHA256");
    final String algorithm;

    public Hashers(String algorithm) {
        this.algorithm = algorithm;
    }

    public Digestion digestion() {
        return new Digestion(this);
    }

    protected MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String hashify(byte[] data) {
        MessageDigest messageDigest = this.newDigest();
        messageDigest.reset();
        messageDigest.update(data);
        byte[] digest = messageDigest.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        Object md5Hex = bigInt.toString(16);
        while (((String)md5Hex).length() < 32) {
            md5Hex = "0" + (String)md5Hex;
        }
        return md5Hex;
    }

    public String hashify(String line) {
        return this.hashify(line.getBytes());
    }

    public String genFolderHash(File prime) {
        if (!prime.exists()) {
            return "ERROR";
        }
        ArrayList<File> paths = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        paths.add(prime);
        int lastSize = 0;
        while (paths.size() != lastSize) {
            lastSize = paths.size();
            for (int i = 0; i < paths.size(); ++i) {
                File f = (File)paths.get(i);
                if (f.isDirectory()) {
                    for (File r : f.listFiles()) {
                        if (r.isDirectory() && !paths.contains(r)) {
                            paths.add(r);
                            continue;
                        }
                        if (!r.isFile() || files.contains(r)) continue;
                        files.add(r);
                    }
                    continue;
                }
                if (!f.isFile() || files.contains(f)) continue;
                files.add(f);
            }
        }
        StringBuilder b = new StringBuilder();
        for (File k : files) {
            if (k.equals(prime)) continue;
            try {
                b.append(this.genHash(k) + k.getAbsolutePath().substring(prime.getAbsolutePath().length()).replace(File.separatorChar, ' ') + ";");
            }
            catch (Throwable err) {
                err.printStackTrace(System.out);
            }
        }
        return this.hashify(b.toString().getBytes());
    }

    public String genHash(File file) {
        if (file.isDirectory()) {
            return this.genFolderHash(file);
        }
        byte[] b = null;
        try {
            b = this.createChecksum(file);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        BigInteger bigInt = new BigInteger(1, b);
        Object md5Hex = bigInt.toString(16);
        while (((String)md5Hex).length() < 32) {
            md5Hex = "0" + (String)md5Hex;
        }
        return md5Hex;
    }

    private byte[] createChecksum(File file) throws Exception {
        int numRead;
        if (!file.exists()) {
            MessageDigest messageDigest = this.newDigest();
            messageDigest.reset();
            messageDigest.update("0".getBytes());
            return messageDigest.digest();
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance(this.algorithm);
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return complete.digest();
    }

    public static class Digestion {
        final Hashers hasher;
        MessageDigest digest;

        public Digestion(Hashers hasher) {
            this.hasher = hasher;
        }

        public Digestion start() {
            this.digest = this.hasher.newDigest();
            return this;
        }

        public Digestion feed(byte[] input) {
            this.digest.update(input);
            return this;
        }

        public Digestion feed(byte[] input, int off, int len) {
            this.digest.update(input, off, len);
            return this;
        }

        public byte[] digestRaw() {
            byte[] r = this.digest.digest();
            this.digest.reset();
            return r;
        }

        public String digestHex() {
            BigInteger bigInt = new BigInteger(1, this.digestRaw());
            Object hex = bigInt.toString(16);
            while (((String)hex).length() < 32) {
                hex = "0" + (String)hex;
            }
            return hex;
        }
    }
}

