/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraftforge.fml.LogicalSide;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class SidedLocal<T> {
    final EnumMap<LogicalSide, T> values = new EnumMap(LogicalSide.class);
    final Function<LogicalSide, T> defaultValues;

    public SidedLocal() {
        this.defaultValues = side -> null;
    }

    public SidedLocal(Function<LogicalSide, T> defaultValue) {
        this.defaultValues = defaultValue;
    }

    public LogicalSide currentEnvironment() {
        return LogicalSidePredictor.getCurrentLogicalSide();
    }

    public boolean equalsTo(T value) {
        return Objects.equals(this.get(), value);
    }

    public T set(T value) {
        return this.values.put(this.currentEnvironment(), value);
    }

    public T get() {
        return this.values.computeIfAbsent(this.currentEnvironment(), this.defaultValues);
    }

    public T set(LogicalSide side, T value) {
        return this.values.put(side, value);
    }

    public T get(LogicalSide side) {
        return this.values.computeIfAbsent(side, this.defaultValues);
    }

    public void apply(LogicalSide side, UnaryOperator<T> op) {
        this.set(side, op.apply(this.get(side)));
    }

    public void applyForAllSides(UnaryOperator<T> op) {
        this.set(LogicalSide.SERVER, op.apply(this.get(LogicalSide.SERVER)));
        this.set(LogicalSide.CLIENT, op.apply(this.get(LogicalSide.CLIENT)));
    }

    public Stream<T> bothSides() {
        return this.values.values().stream();
    }

    public void acceptBoth(Consumer<T> handler) {
        this.values.values().forEach(handler);
    }
}

