/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import com.mojang.authlib.exceptions.MinecraftClientException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.api.crafting.AbstractRecipeRegistry;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.itf.INetworkable;

@MainThreaded
public class PacketAddCustomRecipe
implements IPacket {
    private AbstractRecipeRegistry registryCache;
    private ResourceLocation registry;
    private IGeneralRecipe recipe;
    private UUID transportSession;

    public PacketAddCustomRecipe(AbstractRecipeRegistry registryCache, IGeneralRecipe recipe, UUID transportSession) {
        this.registryCache = registryCache;
        this.registry = registryCache.getRegistryId();
        this.recipe = recipe;
        this.transportSession = transportSession;
    }

    public PacketAddCustomRecipe() {
    }

    private AbstractRecipeRegistry getRegistry() {
        if (this.registryCache != null) {
            return this.registryCache;
        }
        this.registryCache = AbstractRecipeRegistry.getAllRegistries().stream().filter(r -> r.getRegistryId().equals((Object)this.registry)).findFirst().orElse(null);
        return this.registryCache;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.registry);
        buf.m_130077_(this.transportSession);
        Optional n = this.getRegistry().getNetworkSerializer();
        n.orElseThrow().toNetwork(buf, this.recipe);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.registry = buf.m_130281_();
        this.transportSession = buf.m_130259_();
        Optional n = Optional.ofNullable(this.getRegistry()).flatMap(AbstractRecipeRegistry::getNetworkSerializer);
        this.recipe = (IGeneralRecipe)Cast.cast(((INetworkable)n.orElseThrow(() -> new MinecraftClientException(MinecraftClientException.ErrorType.JSON_ERROR, "Unable to find recipe registry " + this.registry + " client-side!", (Throwable)new NoSuchElementException(this.registry + " registry.")))).fromNetwork(buf));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        try {
            this.getRegistry().addClientSideRecipe(this.recipe, this.transportSession);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

