/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.api.crafting.AbstractRecipeRegistry;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.building.GeneralRecipeBuilder;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class ReloadRecipeRegistryEvent
extends Event {
    final AbstractRecipeRegistry<?, ?, ?> registry;

    public ReloadRecipeRegistryEvent(AbstractRecipeRegistry<?, ?, ?> registry) {
        this.registry = registry;
    }

    public AbstractRecipeRegistry<?, ?, ?> getRegistry() {
        return this.registry;
    }

    public boolean isThisRegistry(AbstractRecipeRegistry<?, ?, ?> registry) {
        return registry.getRegistryId().equals((Object)this.registry.getRegistryId());
    }

    public static class AddRecipes<R extends IGeneralRecipe>
    extends GenericEvent<R>
    implements IRecipeRegistrationEvent<R> {
        final AbstractRecipeRegistry<R, ?, ?> registry;
        final Optional<MinecraftServer> server;
        final ICondition.IContext context;

        public AddRecipes(AbstractRecipeRegistry<R, ?, ?> registry, ICondition.IContext context, MinecraftServer server) {
            super(registry.getRecipeType());
            this.registry = registry;
            this.context = context;
            this.server = Optional.ofNullable(server);
        }

        public AbstractRecipeRegistry<R, ?, ?> getRegistry() {
            return this.registry;
        }

        public ICondition.IContext getContext() {
            return this.context;
        }

        public Optional<MinecraftServer> getServer() {
            return this.server;
        }

        public <B extends GeneralRecipeBuilder<R, B>> Supplier<B> builderFactory() {
            return this::builder;
        }

        public <B extends GeneralRecipeBuilder<R, B>> B builder() {
            return (B)((GeneralRecipeBuilder)Cast.cast(this.registry.builder(this)));
        }

        public void addRecipe(R recipe) {
            this.registry.addRecipe(recipe);
        }

        public boolean is(AbstractRecipeRegistry<R, ?, ?> registry) {
            return registry.getRegistryId().equals((Object)this.registry.getRegistryId());
        }

        @Override
        public ResourceLocation nextId(Item item) {
            if (item == null || item == Items.f_41852_) {
                return null;
            }
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item);
            if (this.registry.getRecipe(Cast.cast(rl)) == null) {
                return rl;
            }
            int lastIdx = 1;
            while (this.registry.getRecipe(Cast.cast(rl = new ResourceLocation(rl.m_135827_(), rl.m_135815_() + "_" + lastIdx++))) != null) {
            }
            return rl;
        }

        @Override
        public void register(ResourceLocation id, R entry) {
            this.addRecipe(entry);
        }
    }

    public static class Post
    extends ReloadRecipeRegistryEvent {
        public Post(AbstractRecipeRegistry<?, ?, ?> registry) {
            super(registry);
        }
    }

    public static class Pre
    extends ReloadRecipeRegistryEvent {
        public Pre(AbstractRecipeRegistry<?, ?, ?> registry) {
            super(registry);
        }
    }
}

