/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.recipes.RecipeBuilderExtension;
import org.zeith.hammerlib.core.adapter.recipe.BlastingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.CampfireRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapelessRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmeltingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmokingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.StoneCutterRecipeBuilder;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class RegisterRecipesEvent
extends Event
implements IRecipeRegistrationEvent<Recipe<?>> {
    private final List<Recipe<?>> recipes = Lists.newArrayList();
    private final Set<ResourceLocation> removeRecipes = Sets.newHashSet();
    private final Predicate<ResourceLocation> idInUse;
    private final Map<Class<?>, RecipeBuilderExtension> extensions;

    public RegisterRecipesEvent(Predicate<ResourceLocation> idInUse) {
        this.idInUse = idInUse;
        this.extensions = RecipeBuilderExtension.attach(this);
    }

    @Nullable
    public <T> T extension(Class<T> type) {
        return Cast.cast(this.extensions.get(type), type);
    }

    public void add(Recipe<?> recipe) {
        if (recipe != null) {
            this.recipes.add(recipe);
        }
    }

    public Set<ResourceLocation> removedRecipes() {
        return Collections.unmodifiableSet(this.removeRecipes);
    }

    public RegisterRecipesEvent removeRecipe(ResourceLocation id) {
        this.removeRecipes.add(id);
        return this;
    }

    public StoneCutterRecipeBuilder stoneCutting() {
        return new StoneCutterRecipeBuilder(this);
    }

    public SmokingRecipeBuilder smoking() {
        return new SmokingRecipeBuilder(this);
    }

    public BlastingRecipeBuilder blasting() {
        return new BlastingRecipeBuilder(this);
    }

    public CampfireRecipeBuilder campfire() {
        return new CampfireRecipeBuilder(this);
    }

    public SmeltingRecipeBuilder smelting() {
        return new SmeltingRecipeBuilder(this);
    }

    public ShapedRecipeBuilder shaped() {
        return new ShapedRecipeBuilder(this);
    }

    public ShapelessRecipeBuilder shapeless() {
        return new ShapelessRecipeBuilder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRecipeIdTaken(ResourceLocation id) {
        if (this.idInUse.test(id)) return true;
        if (!this.recipes.stream().map(Recipe::m_6423_).anyMatch(arg_0 -> ((ResourceLocation)id).equals(arg_0))) return false;
        return true;
    }

    @Override
    public ResourceLocation nextId(Item item) {
        if (item == null || item == Items.f_41852_) {
            return null;
        }
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item);
        if (!this.isRecipeIdTaken(rl)) {
            return rl;
        }
        int lastIdx = 1;
        while (this.isRecipeIdTaken(rl = new ResourceLocation(rl.m_135827_(), rl.m_135815_() + "_" + lastIdx++))) {
        }
        return rl;
    }

    @Override
    public void register(ResourceLocation id, Recipe<?> entry) {
        this.add(entry);
    }

    public Stream<Recipe<?>> getRecipes() {
        return this.recipes.stream();
    }
}

