/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.SyncTileEntityPacket;
import org.zeith.hammerlib.net.properties.IPropertyTile;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerListener {
    public static final List<BlockEntity> NEED_SYNC = new ArrayList<BlockEntity>();
    public static final List<BlockEntity> NEED_PROP_SYNC = new ArrayList<BlockEntity>();

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            BlockEntity tile;
            HashSet<BlockPos> processed = new HashSet<BlockPos>();
            while (!NEED_SYNC.isEmpty()) {
                tile = NEED_SYNC.remove(0);
                if (!processed.add(tile.m_58899_())) continue;
                if (tile instanceof ISyncableTile) {
                    ISyncableTile s = (ISyncableTile)tile;
                    s.syncNow();
                    continue;
                }
                Network.sendToTracking((IPacket)new SyncTileEntityPacket(tile, false), tile);
            }
            processed.clear();
            while (!NEED_PROP_SYNC.isEmpty()) {
                tile = NEED_PROP_SYNC.remove(0);
                if (!processed.add(tile.m_58899_()) || !(tile instanceof IPropertyTile)) continue;
                IPropertyTile ipt = (IPropertyTile)tile;
                ipt.syncPropertiesNow();
            }
        }
    }

    public static void syncProperties(BlockEntity tileEntity) {
        Level level;
        if (tileEntity != null && (level = tileEntity.m_58904_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!sl.f_46443_) {
                NEED_PROP_SYNC.add(tileEntity);
            }
        }
    }

    public static void syncTileEntity(BlockEntity tileEntity) {
        Level level;
        if (tileEntity != null && (level = tileEntity.m_58904_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!sl.f_46443_) {
                NEED_SYNC.add(tileEntity);
            }
        }
    }
}

