/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.ApiStatus;

public class LootTableAdapter {
    private static final Map<ResourceLocation, UnaryOperator<LootTable>> TABLE_ALTERATORS = new ConcurrentHashMap<ResourceLocation, UnaryOperator<LootTable>>();

    public static void alterTable(ResourceLocation id, UnaryOperator<LootTable> alterator) {
        UnaryOperator<LootTable> prev = TABLE_ALTERATORS.get(id);
        if (prev != null) {
            alterator = prev.andThen(alterator)::apply;
        }
        TABLE_ALTERATORS.put(id, alterator);
    }

    @ApiStatus.Internal
    public static LootTable alter(LootTable table) {
        return (LootTable)TABLE_ALTERATORS.getOrDefault(table.getLootTableId(), UnaryOperator.identity()).apply(table);
    }
}

