/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.jei;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipe;
import org.zeith.hammerlib.abstractions.recipes.RecipeVisualizationRegistry;
import org.zeith.hammerlib.client.screen.IAdvancedGui;
import org.zeith.hammerlib.compat.jei.AdvancedGuiToJeiWrapper;
import org.zeith.hammerlib.compat.jei.IJeiPluginHL;
import org.zeith.hammerlib.compat.jei.VisualizedRecipeCategory;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@JeiPlugin
public class JeiHammerLib
implements IModPlugin,
IJeiPluginHL {
    public static final ResourceLocation HL_PLUGIN = new ResourceLocation("hammerlib", "jei");
    IJeiRuntime runtime;
    static final Map<net.minecraft.world.item.crafting.RecipeType<?>, RecipeType<?>> MC2JEI = new HashMap();

    public JeiHammerLib() {
        IJeiPluginHL.Container.active = this;
    }

    public ResourceLocation getPluginUid() {
        return HL_PLUGIN;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        RecipeVisualizationRegistry.getVisualizedEntries().forEach(tup -> {
            net.minecraft.world.item.crafting.RecipeType type = (net.minecraft.world.item.crafting.RecipeType)tup.a();
            ResourceLocation typeID = ForgeRegistries.RECIPE_TYPES.getKey((Object)type);
            if (typeID == null) {
                return;
            }
            IRecipeVisualizer vis = (IRecipeVisualizer)tup.b();
            RecipeType jeiRT = MC2JEI.computeIfAbsent(type, vanilla -> new RecipeType(typeID, vis.getVisualizedType()));
            VisualizedRecipeCategory cat = new VisualizedRecipeCategory(jeiRT, vis.getGroup());
            registration.addRecipeCategories(new IRecipeCategory[]{cat});
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeVisualizationRegistry.getVisualizedEntries().forEach(tup -> {
            net.minecraft.world.item.crafting.RecipeType type = (net.minecraft.world.item.crafting.RecipeType)tup.a();
            ResourceLocation typeID = ForgeRegistries.RECIPE_TYPES.getKey((Object)type);
            if (typeID == null) {
                return;
            }
            IRecipeVisualizer vis = (IRecipeVisualizer)tup.b();
            RecipeType jeiRT = MC2JEI.computeIfAbsent(type, vanilla -> new RecipeType(typeID, vis.getVisualizedType()));
            this.registerRecipesFor(registration, type, jeiRT, vis);
        });
    }

    private <R extends Recipe<C>, C extends Container, T extends IVisualizedRecipe<R>> void registerRecipesFor(IRecipeRegistration reg, net.minecraft.world.item.crafting.RecipeType<R> recipeType, RecipeType<T> type, IRecipeVisualizer<R, T> visualizer) {
        List<IVisualizedRecipe> lst = JeiHammerLib.getRecipes(recipeType).map(visualizer::visualize).toList();
        reg.addRecipes(type, lst);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        ScanDataHelper.lookupAnnotatedObjects(IAdvancedGui.ApplyToJEI.class).stream().map(ScanDataHelper.ModAwareAnnotationData::getOwnerClass).filter(raw -> AbstractContainerScreen.class.isAssignableFrom((Class<?>)raw) && IAdvancedGui.class.isAssignableFrom((Class<?>)raw)).forEach(f -> registration.addGuiContainerHandler(f.asSubclass(AbstractContainerScreen.class), (IGuiContainerHandler)Cast.cast(AdvancedGuiToJeiWrapper.get())));
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouseJEI(Class<T> type) {
        return Optional.ofNullable(this.runtime).map(IJeiRuntime::getIngredientListOverlay).flatMap(IIngredientListOverlay::getIngredientUnderMouse).filter(ing -> ing.getType().getIngredientClass().equals(ing.getType().getIngredientClass())).filter(ing -> type.isInstance(ing.getIngredient())).map(ing -> Cast.cast(ing.getIngredient()));
    }

    public static <T extends Recipe<C>, C extends Container> Stream<T> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        ClientLevel lvl = Minecraft.m_91087_().f_91073_;
        return lvl != null ? RecipeHelper.getRecipes((Level)lvl, type) : Stream.of(new Recipe[0]);
    }
}

