/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting;

import com.google.common.collect.BiMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLPaths;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.crafting.AbstractRecipeRegistry;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.INameableRecipe;
import org.zeith.hammerlib.api.crafting.IRecipeContainer;
import org.zeith.hammerlib.api.crafting.RecipeRegistryFactory;
import org.zeith.hammerlib.api.crafting.building.CustomRecipeGenerator;
import org.zeith.hammerlib.api.crafting.itf.IRecipeReceiver;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PacketAddCustomRecipe;
import org.zeith.hammerlib.util.SidedLocal;
import org.zeith.hammerlib.util.java.collections.UnmodifiableConcatCollection;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;
import org.zeith.hammerlib.util.shaded.json.JSONException;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class NamespacedRecipeRegistry<T extends INameableRecipe>
extends AbstractRecipeRegistry<T, NamespacedRecipeContainer<T>, ResourceLocation> {
    protected final RecipeRegistryFactory.RegistryFingerprint<T> fingerprint;
    protected final Set<ResourceLocation> customRecipes = Collections.synchronizedSet(new HashSet());
    private final Map<ResourceLocation, Boolean> recipeStates = new HashMap<ResourceLocation, Boolean>();

    @Deprecated(forRemoval=true)
    public NamespacedRecipeRegistry(Class<T> type, ResourceLocation id) {
        this(new RecipeRegistryFactory.RegistryFingerprint<T>(type, id), null);
    }

    NamespacedRecipeRegistry(RecipeRegistryFactory.RegistryFingerprint<T> fingerprint, CustomRecipeGenerator<T, ?, ?> custom) {
        super(fingerprint.type(), new NamespacedRecipeContainer<T>(fingerprint), fingerprint.regId(), custom);
        this.fingerprint = fingerprint;
    }

    @Override
    public ResourceLocation addRecipe(T recipe) {
        ResourceLocation loc = recipe.getRecipeName();
        if (loc == null) {
            throw new IllegalArgumentException("Attempted to register a recipe with null recipe name!");
        }
        if (((NamespacedRecipeContainer)this.container).elements.get().containsKey((Object)loc)) {
            throw new IllegalArgumentException("Attempted to register a recipe with registry name that is already taken!");
        }
        ((NamespacedRecipeContainer)this.container).elements.get().put((Object)loc, recipe);
        return loc;
    }

    @Override
    public void removeRecipe(T recipe) {
        ResourceLocation loc = ((NamespacedRecipeContainer)this.container).elementsInv.apply(recipe);
        if (loc != null) {
            Optional.ofNullable(((NamespacedRecipeContainer)this.container).remove(LogicalSidePredictor.getCurrentLogicalSide(), loc)).ifPresent(IGeneralRecipe::onDeregistered);
        }
    }

    @Override
    protected void removeAllRecipes() {
        ((NamespacedRecipeContainer)this.container).removeAllRecipes(LogicalSidePredictor.getCurrentLogicalSide());
    }

    @Override
    protected void removeStaticRecipes() {
        ((NamespacedRecipeContainer)this.container).removeStaticRecipes(LogicalSidePredictor.getCurrentLogicalSide());
    }

    @Override
    public T getRecipe(ResourceLocation identifier) {
        if (identifier == null) {
            return null;
        }
        return (T)((INameableRecipe)((NamespacedRecipeContainer)this.container).elements.get().get((Object)identifier));
    }

    protected Path getBuiltinRecipes() {
        Path codedRecipes = FMLPaths.CONFIGDIR.get().resolve(this.getRegistryId().m_135827_()).resolve("recipes").resolve("builtin").resolve(this.getRegistryId().m_135815_() + ".json");
        codedRecipes.getParent().toFile().mkdirs();
        return codedRecipes;
    }

    protected Path getGlobalCustomRecipes() {
        Path dynRecipes = FMLPaths.CONFIGDIR.get().resolve(this.getRegistryId().m_135827_()).resolve("recipes").resolve("custom").resolve(this.getRegistryId().m_135815_());
        dynRecipes.toFile().mkdirs();
        return dynRecipes;
    }

    @Override
    public void reload(MinecraftServer server, ICondition.IContext context) {
        super.reload(server, context);
        List<String> unregisteredKeys = this.getRecipes().stream().map(INameableRecipe::getRecipeName).filter(f -> !this.customRecipes.contains(f)).map(ResourceLocation::toString).toList();
        Path cfgPath = this.getBuiltinRecipes();
        try {
            JSONObject obj = new JSONObject();
            for (String string : unregisteredKeys) {
                obj.put(string, true);
            }
            for (ResourceLocation resourceLocation : this.recipeStates.keySet()) {
                if (this.getRecipe(resourceLocation) == null) continue;
                obj.put(resourceLocation.toString(), this.recipeStates.get(resourceLocation));
            }
            Files.writeString(cfgPath, (CharSequence)obj.toString(2), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void reloadDatapackRecipes(MinecraftServer server, ICondition.IContext context) {
        this.recipeStates.clear();
        Path cfgPath = this.getBuiltinRecipes();
        File cfgFile = cfgPath.toFile();
        if (cfgFile.isFile()) {
            try {
                new JSONTokener(Files.readString(cfgPath)).nextValueOBJ().ifPresent(obj -> {
                    for (String str : obj.keySet()) {
                        this.recipeStates.put(new ResourceLocation(str), obj.getBoolean(str));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                HammerLib.LOG.error("Failed to read json from file " + cfgPath + ". Check validity of the file!", (Throwable)e);
                throw e;
            }
        }
        if (server != null && this.custom != null) {
            this.customRecipes.clear();
            try {
                Path dir = this.getGlobalCustomRecipes();
                File fl = dir.toFile();
                int rootLength = fl.getAbsolutePath().length() + 1;
                File templateFile = new File(fl, "__template.json");
                if (!this.custom.createExampleRecipe((Resource.IoSupplier<BufferedWriter>)((Resource.IoSupplier)() -> new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(templateFile), StandardCharsets.UTF_8))))) {
                    templateFile.delete();
                }
                Iterator itr = Files.walk(dir, new FileVisitOption[0]).map(Path::toFile).filter(f -> !f.getName().startsWith("__") && f.getName().toLowerCase(Locale.ROOT).endsWith(".json")).iterator();
                while (itr.hasNext()) {
                    File file = (File)itr.next();
                    Resource res = new Resource("File System", () -> new FileInputStream(file));
                    ResourceLocation recipePath = new ResourceLocation("modpack", this.custom.getFileDir() + "/" + file.getAbsolutePath().substring(rootLength));
                    try {
                        this.custom.readRecipe(recipePath, res, server, context).ifPresent(recipe -> {
                            this.addRecipe((T)recipe);
                            this.customRecipes.add(recipe.getRecipeName());
                        });
                    }
                    catch (IOException | RuntimeException e) {
                        HammerLib.LOG.error("Failed to read recipe for registry " + this.getClass().getSimpleName() + "<" + this.type.getSimpleName() + "> (" + this.getRegistryId() + "): " + recipePath, (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                HammerLib.LOG.error("Failed to read custom global recipe for registry " + this.getClass().getSimpleName() + "<" + this.type.getSimpleName() + "> (" + this.getRegistryId() + ").", (Throwable)e);
            }
            MinecraftServer.ReloadableResources resources = server.getServerResources();
            CloseableResourceManager mgr = resources.f_206584_();
            for (Map.Entry entry : mgr.m_214159_(this.custom.getFileDir(), this.custom::pathMatches).entrySet()) {
                if (!((ResourceLocation)entry.getKey()).m_135815_().startsWith("recipes_hl/")) continue;
                try {
                    this.custom.readRecipe((ResourceLocation)entry.getKey(), (Resource)entry.getValue(), server, context).ifPresent(recipe -> {
                        this.addRecipe((T)recipe);
                        this.customRecipes.add(recipe.getRecipeName());
                    });
                }
                catch (IOException | RuntimeException e) {
                    HammerLib.LOG.error("Failed to read recipe for registry " + this.getClass().getSimpleName() + "<" + this.type.getSimpleName() + "> (" + this.getRegistryId() + "): " + entry.getKey(), (Throwable)e);
                }
            }
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                this.syncToPlayer(player);
            }
        }
    }

    @Override
    public void syncToPlayer(ServerPlayer player) {
        super.syncToPlayer(player);
        if (this.custom != null) {
            this.custom.getSerializer().ifPresent(io -> {
                UUID transportSession = UUID.randomUUID();
                for (ResourceLocation recipe : this.customRecipes) {
                    T r = this.getRecipe(recipe);
                    if (r == null) continue;
                    Network.sendTo(player, (IPacket)new PacketAddCustomRecipe(this, (IGeneralRecipe)r, transportSession));
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addClientSideRecipe(T recipe, UUID transportSession) {
        super.addClientSideRecipe(recipe, transportSession);
        if (((NamespacedRecipeContainer)this.container).elementsClient.containsKey((Object)recipe.getRecipeName())) {
            throw new IllegalArgumentException("Attempted to sync a client recipe with registry name that is already in use! (" + recipe.getRecipeName() + ")");
        }
        ((NamespacedRecipeContainer)this.container).elementsClient.put((Object)recipe.getRecipeName(), recipe);
        for (IRecipeReceiver<T> rcv : this.fingerprint.clientReceivers()) {
            rcv.onReceive(recipe);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void resetClientRecipes() {
        for (INameableRecipe value : ((NamespacedRecipeContainer)this.container).elementsClient.values()) {
            value.onDeregistered();
        }
        ((NamespacedRecipeContainer)this.container).elementsClient.clear();
    }

    protected static class NamespacedRecipeContainer<T extends INameableRecipe>
    implements IRecipeContainer<T> {
        private final Class<T> type;
        private final BiMap<ResourceLocation, T> elementsClient;
        private final SidedLocal<BiMap<ResourceLocation, T>> elements;
        private final Collection<T> elementsViewClient;
        private final Collection<T> elementsViewServer;
        private final Function<T, ResourceLocation> elementsInv;

        public NamespacedRecipeContainer(RecipeRegistryFactory.RegistryFingerprint<T> fingerprint) {
            this.type = fingerprint.type();
            this.elements = fingerprint.storage();
            this.elementsClient = fingerprint.clientExtraStorage();
            this.elementsViewClient = new UnmodifiableConcatCollection<T>(List.of(this.elements.get(LogicalSide.CLIENT).values(), this.elementsClient.values()));
            this.elementsViewServer = new UnmodifiableConcatCollection<T>(List.of(this.elements.get(LogicalSide.SERVER).values()));
            this.elementsInv = recipe -> (ResourceLocation)this.elements.get().inverse().get(recipe);
        }

        @Override
        public Collection<T> getRecipes() {
            return LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER ? this.elementsViewServer : this.elementsViewClient;
        }

        void removeAllRecipes(LogicalSide side) {
            for (INameableRecipe value : this.elements.get(side).values()) {
                value.onDeregistered();
            }
            for (INameableRecipe value : this.elementsClient.values()) {
                value.onDeregistered();
            }
            this.elements.get(side).clear();
            this.elementsClient.clear();
        }

        public void removeStaticRecipes(LogicalSide side) {
            for (INameableRecipe value : this.elements.get(side).values()) {
                value.onDeregistered();
            }
            this.elements.get(side).clear();
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        public T remove(LogicalSide side, ResourceLocation loc) {
            return (T)((INameableRecipe)this.elements.get(side).remove((Object)loc));
        }
    }
}

