/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.api.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.zeith.hammerlib.util.java.Cast;

public class RegistryMapping {
    private static final BiMap<Class<?>, IForgeRegistry<?>> REG_BY_TYPE = HashBiMap.create();
    private static final BiMap<ResourceKey<?>, Class<?>> TYPE_BY_REG = HashBiMap.create();
    private static final Set<ResourceKey<?>> NON_INTRUSIVE_REGISTRIES = new HashSet();

    public static synchronized <T> void markRegistryAsNonIntrusive(ResourceKey<Registry<T>> registryKey) {
        NON_INTRUSIVE_REGISTRIES.add(registryKey);
    }

    public static synchronized <T> void report(Class<T> base, IForgeRegistry<T> registry) {
        REG_BY_TYPE.put(base, registry);
        TYPE_BY_REG.put((Object)registry.getRegistryKey(), base);
    }

    public static synchronized <T> void report(Class<T> base, IForgeRegistry<T> registry, boolean intrusive) {
        REG_BY_TYPE.put(base, registry);
        TYPE_BY_REG.put((Object)registry.getRegistryKey(), base);
        if (!intrusive) {
            RegistryMapping.markRegistryAsNonIntrusive(registry.getRegistryKey());
        }
    }

    public static synchronized void reportRaw(Class base, IForgeRegistry registry) {
        REG_BY_TYPE.put((Object)base, (Object)registry);
        TYPE_BY_REG.put((Object)registry.getRegistryKey(), (Object)base);
    }

    public static <T> Class<T> getSuperType(IForgeRegistry<T> registry) {
        if (registry == null) {
            return null;
        }
        return RegistryMapping.getSuperType(registry.getRegistryKey());
    }

    public static <T> Class<T> getSuperType(Registry<T> registry) {
        if (registry == null) {
            return null;
        }
        return RegistryMapping.getSuperType(registry.m_123023_());
    }

    public static <T> Class<T> getSuperType(ResourceKey<? extends Registry<?>> registry) {
        if (registry == null) {
            return null;
        }
        return (Class)Cast.cast(TYPE_BY_REG.get(registry));
    }

    public static <T> IForgeRegistry<T> getRegistryByType(Class<T> registry) {
        if (registry == null) {
            return null;
        }
        return (IForgeRegistry)Cast.cast(REG_BY_TYPE.get(registry));
    }

    public static boolean isNonIntrusive(IForgeRegistry<?> registry) {
        return NON_INTRUSIVE_REGISTRIES.contains(registry.getRegistryKey());
    }

    static {
        RegistryMapping.report(Block.class, ForgeRegistries.BLOCKS);
        RegistryMapping.report(Fluid.class, ForgeRegistries.FLUIDS);
        RegistryMapping.report(Item.class, ForgeRegistries.ITEMS);
        RegistryMapping.report(MobEffect.class, ForgeRegistries.MOB_EFFECTS);
        RegistryMapping.report(SoundEvent.class, ForgeRegistries.SOUND_EVENTS);
        RegistryMapping.report(Potion.class, ForgeRegistries.POTIONS);
        RegistryMapping.report(Enchantment.class, ForgeRegistries.ENCHANTMENTS);
        RegistryMapping.report(PaintingVariant.class, ForgeRegistries.PAINTING_VARIANTS);
        RegistryMapping.report(Attribute.class, ForgeRegistries.ATTRIBUTES);
        RegistryMapping.report(VillagerProfession.class, ForgeRegistries.VILLAGER_PROFESSIONS);
        RegistryMapping.report(PoiType.class, ForgeRegistries.POI_TYPES);
        RegistryMapping.report(Schedule.class, ForgeRegistries.SCHEDULES);
        RegistryMapping.report(Activity.class, ForgeRegistries.ACTIVITIES);
        RegistryMapping.report(ChunkStatus.class, ForgeRegistries.CHUNK_STATUS);
        RegistryMapping.report(Biome.class, ForgeRegistries.BIOMES);
        RegistryMapping.reportRaw(EntityType.class, ForgeRegistries.ENTITY_TYPES);
        RegistryMapping.reportRaw(BlockEntityType.class, ForgeRegistries.BLOCK_ENTITY_TYPES);
        RegistryMapping.reportRaw(ParticleType.class, ForgeRegistries.PARTICLE_TYPES);
        RegistryMapping.reportRaw(MenuType.class, ForgeRegistries.MENU_TYPES);
        RegistryMapping.reportRaw(RecipeType.class, ForgeRegistries.RECIPE_TYPES);
        RegistryMapping.reportRaw(RecipeSerializer.class, ForgeRegistries.RECIPE_SERIALIZERS);
        RegistryMapping.reportRaw(StatType.class, ForgeRegistries.STAT_TYPES);
        RegistryMapping.reportRaw(MemoryModuleType.class, ForgeRegistries.MEMORY_MODULE_TYPES);
        RegistryMapping.reportRaw(SensorType.class, ForgeRegistries.SENSOR_TYPES);
        RegistryMapping.reportRaw(WorldCarver.class, ForgeRegistries.WORLD_CARVERS);
        RegistryMapping.reportRaw(Feature.class, ForgeRegistries.FEATURES);
        RegistryMapping.reportRaw(BlockStateProviderType.class, ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES);
        RegistryMapping.reportRaw(FoliagePlacerType.class, ForgeRegistries.FOLIAGE_PLACER_TYPES);
        RegistryMapping.reportRaw(TreeDecoratorType.class, ForgeRegistries.TREE_DECORATOR_TYPES);
        RegistryMapping.reportRaw(ArgumentTypeInfo.class, ForgeRegistries.COMMAND_ARGUMENT_TYPES);
    }
}

