/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.network.PacketDistributor;
import noobanidus.mods.lootr.advancement.GenericTrigger;
import noobanidus.mods.lootr.api.IHasOpeners;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.entities.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModAdvancements;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.network.CloseCart;
import noobanidus.mods.lootr.network.PacketHandler;
import noobanidus.mods.lootr.network.UpdateModelData;

public class ChestUtil {
    public static void handleLootSneak(Block block, Level level, BlockPos pos, Player player) {
        ILootBlockEntity tile;
        if (level.m_5776_() || player.m_5833_()) {
            return;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof ILootBlockEntity && (tile = (ILootBlockEntity)te).getOpeners().remove(player.m_20148_())) {
            te.m_6596_();
            tile.updatePacketViaState();
            UpdateModelData message = new UpdateModelData(te.m_58899_());
            PacketHandler.sendToInternal(message, (ServerPlayer)player);
        }
    }

    public static void handleLootCartSneak(Level level, LootrChestMinecartEntity cart, Player player) {
        if (level.m_5776_() || player.m_5833_()) {
            return;
        }
        cart.getOpeners().remove(player.m_20148_());
        CloseCart open = new CloseCart(cart.m_19879_());
        PacketHandler.sendInternal(PacketDistributor.TRACKING_ENTITY.with(() -> cart), open);
    }

    public static void handleLootChest(Block block, Level level, BlockPos pos, Player player) {
        if (level.m_5776_() || player.m_5833_()) {
            if (player.m_5833_()) {
                player.m_5893_(null);
            }
            return;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof ILootBlockEntity) {
            int refreshValue;
            ILootBlockEntity tile = (ILootBlockEntity)te;
            UUID tileId = tile.getTileId();
            if (DataStorage.isDecayed(tileId)) {
                level.m_46961_(pos, true);
                ChestUtil.notifyDecay(player, tileId);
                return;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0) {
                player.m_5661_((Component)Component.m_237110_((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), false);
            } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)level, tile)) {
                ChestUtil.startDecay(player, tileId, decayValue);
            }
            GenericTrigger<UUID> trigger = ModAdvancements.CHEST_PREDICATE;
            if (block instanceof BarrelBlock) {
                trigger = ModAdvancements.BARREL_PREDICATE;
            } else if (block instanceof LootrShulkerBlock) {
                trigger = ModAdvancements.SHULKER_PREDICATE;
            }
            trigger.trigger((ServerPlayer)player, tileId);
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(level, pos, tileId, (ServerPlayer)player);
                ChestUtil.notifyRefresh(player, tileId);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0) {
                player.m_5661_((Component)Component.m_237110_((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), false);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, tile)) {
                ChestUtil.startRefresh(player, tileId, refreshValue);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tileId, pos, (ServerPlayer)player, (RandomizableContainerBlockEntity)te, tile::unpackLootTable);
            ChestUtil.checkScore((ServerPlayer)player, tileId);
            if (ChestUtil.addOpener(tile, player)) {
                te.m_6596_();
                tile.updatePacketViaState();
            }
            player.m_5893_((MenuProvider)provider);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    private static boolean addOpener(IHasOpeners openable, Player player) {
        return openable.getOpeners().add(player.m_20148_());
    }

    public static void handleLootCart(Level level, LootrChestMinecartEntity cart, Player player) {
        int refreshValue;
        if (level.m_5776_() || player.m_5833_()) {
            if (player.m_5833_()) {
                player.m_5893_(null);
            }
            return;
        }
        ModAdvancements.CART_PREDICATE.trigger((ServerPlayer)player, cart.m_20148_());
        UUID tileId = cart.m_20148_();
        if (DataStorage.isDecayed(tileId)) {
            cart.m_7617_(DamageSource.f_19317_);
            ChestUtil.notifyDecay(player, tileId);
            return;
        }
        int decayValue = DataStorage.getDecayValue(tileId);
        if (decayValue > 0) {
            player.m_5661_((Component)Component.m_237110_((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), false);
        } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)level, cart)) {
            ChestUtil.startDecay(player, tileId, decayValue);
        }
        ChestUtil.addOpener(cart, player);
        ChestUtil.checkScore((ServerPlayer)player, cart.m_20148_());
        if (DataStorage.isRefreshed(tileId)) {
            DataStorage.refreshInventory(level, cart, (ServerPlayer)player);
            ChestUtil.notifyRefresh(player, tileId);
        }
        if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0) {
            player.m_5661_((Component)Component.m_237110_((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), false);
        } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, cart)) {
            ChestUtil.startRefresh(player, tileId, refreshValue);
        }
        SpecialChestInventory provider = DataStorage.getInventory(level, cart, (ServerPlayer)player, cart::addLoot);
        player.m_5893_((MenuProvider)provider);
    }

    public static void handleLootInventory(Block block, Level level, BlockPos pos, Player player) {
        if (level.m_5776_() || player.m_5833_()) {
            if (player.m_5833_()) {
                player.m_5893_(null);
            }
            return;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof LootrInventoryBlockEntity) {
            int refreshValue;
            UUID tileId;
            LootrInventoryBlockEntity tile = (LootrInventoryBlockEntity)te;
            ModAdvancements.CHEST_PREDICATE.trigger((ServerPlayer)player, tile.getTileId());
            NonNullList<ItemStack> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isRefreshed(tileId = tile.getTileId())) {
                DataStorage.refreshInventory(level, pos, tile.getTileId(), stacks, (ServerPlayer)player);
                ChestUtil.notifyRefresh(player, tileId);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0) {
                player.m_5661_((Component)Component.m_237110_((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), false);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, tile)) {
                ChestUtil.startRefresh(player, tileId, refreshValue);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tile.getTileId(), stacks, (ServerPlayer)player, pos, (RandomizableContainerBlockEntity)tile);
            ChestUtil.checkScore((ServerPlayer)player, tile.getTileId());
            if (ChestUtil.addOpener(tile, player)) {
                te.m_6596_();
                tile.updatePacketViaState();
            }
            player.m_5893_((MenuProvider)provider);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    public static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.m_122780_((int)reference.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).m_41777_());
        }
        return contents;
    }

    private static void checkScore(ServerPlayer player, UUID tileId) {
        if (!DataStorage.isScored(player.m_20148_(), tileId)) {
            player.m_36246_(ModStats.LOOTED_STAT);
            ModAdvancements.SCORE_PREDICATE.trigger(player, null);
            DataStorage.score(player.m_20148_(), tileId);
        }
    }

    private static void notifyDecay(Player player, UUID tileId) {
        player.m_5661_((Component)Component.m_237115_((String)"lootr.message.decayed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), false);
        DataStorage.removeDecayed(tileId);
    }

    private static void notifyRefresh(Player player, UUID tileId) {
        DataStorage.removeRefreshed(tileId);
        player.m_5661_((Component)Component.m_237115_((String)"lootr.message.refreshed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), false);
    }

    private static void startDecay(Player player, UUID tileId, int decayValue) {
        DataStorage.setDecaying(tileId, (Integer)ConfigManager.DECAY_VALUE.get());
        player.m_5661_((Component)Component.m_237110_((String)"lootr.message.decay_start", (Object[])new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))), false);
    }

    private static void startRefresh(Player player, UUID tileId, int refreshValue) {
        DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
        player.m_5661_((Component)Component.m_237110_((String)"lootr.message.refresh_start", (Object[])new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), false);
    }
}

