/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderChest
implements BlockEntityRenderer<TileEntityEnderChest> {
    private static final BlockColors BLOCK_COLORS = Minecraft.m_91087_().m_91298_();
    private static final ModelBlockRenderer RENDERER = new ModelBlockRenderer(BLOCK_COLORS);

    public void render(TileEntityEnderChest tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockState state = tile.m_58900_();
        if (tile.m_58904_() == null || !state.m_61138_((Property)BlockEnderChest.STATIC)) {
            return;
        }
        state = (BlockState)state.m_61124_((Property)BlockEnderChest.STATIC, (Comparable)Boolean.valueOf(false));
        float lidAngle = tile.getLidAngle(partialTicks);
        lidAngle *= 0.7f;
        BakedModel model = blockRenderer.m_110907_().m_110893_(state);
        Direction facing = BlockEnderChest.getFacing(state);
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            lidAngle = -lidAngle;
        }
        matrixStack.m_85836_();
        switch (facing.m_122434_()) {
            case X: {
                matrixStack.m_85837_((double)lidAngle, 0.0, 0.0);
                break;
            }
            case Y: {
                matrixStack.m_85837_(0.0, (double)lidAngle, 0.0);
                break;
            }
            case Z: {
                matrixStack.m_85837_(0.0, 0.0, (double)lidAngle);
            }
        }
        int color = BLOCK_COLORS.m_92577_(state, null, null, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RENDERER.renderModel(matrixStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, model, red, green, blue, combinedLight, combinedOverlay, ModelData.EMPTY, null);
        matrixStack.m_85849_();
    }
}

