/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.enderchests.client.gui.Textures;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.ItemEnderBag;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnderChest
extends AbstractContainerScreen<ContainerEnderChest> {
    private int slotCount;
    private int columns;
    private int rows;
    private int colOffset;

    public GuiEnderChest(ContainerEnderChest container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 182;
        this.setLayout();
        ((ContainerEnderChest)this.f_97732_).setInventoryChangeCallback(this::setLayout);
    }

    private void setLayout() {
        this.slotCount = ((ContainerEnderChest)this.f_97732_).getChestSize();
        int n = this.columns = this.slotCount >= 27 ? 9 : this.slotCount / 3;
        this.rows = this.slotCount <= 27 ? 3 : (this.slotCount % 9 == 0 ? this.slotCount / 9 : this.slotCount / 9 + 1);
        this.colOffset = (9 - this.columns) * 9;
        int rowOffset = (this.rows - 3) * 18;
        this.f_97727_ = 172 + rowOffset;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        for (Slot invSlot : ((ContainerEnderChest)this.f_97732_).f_38839_) {
            if (invSlot instanceof Slots.Hideable) {
                Slots.Hideable slot = (Slots.Hideable)invSlot;
                int group = slot.getSlotIndex();
                if (slot.getSlotIndex() >= this.slotCount) {
                    slot.setVisible(false);
                    continue;
                }
                slot.setVisible(true);
                int toX = 11 + this.colOffset + group % this.columns * 18;
                int toY = 11 + group / this.columns * 18;
                Slots.moveSlot(slot, toX, toY);
                continue;
            }
            int slotId = invSlot.getSlotIndex();
            int row = slotId / 9 - 1;
            int col = slotId % 9 * 18;
            Slots.moveSlot(invSlot, 11 + col, 87 + rowOffset + (row == -1 ? 58 : row * 18));
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        GuiEnderChest.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)((ContainerEnderChest)this.f_97732_).getOwner(), (int)(this.f_97726_ / 2), (int)-8, (int)-32961);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.slotCount != ((ContainerEnderChest)this.f_97732_).getChestSize()) {
            this.setLayout();
        }
        GuiFunctions.enterDrawTextureStateWithBlend();
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.ENDERCHEST.get());
        int ypos = 0;
        if (this.slotCount >= 27) {
            int rem;
            this.m_93228_(matrixStack, this.f_97735_, this.f_97736_ + ypos, 0, 102, 182, 46);
            this.m_93228_(matrixStack, this.f_97735_, this.f_97736_ + (ypos += 46), 0, 112, 182, this.rows == 3 ? 18 : 36);
            ypos += this.rows == 3 ? 18 : 36;
            if (this.rows > 4) {
                this.m_93228_(matrixStack, this.f_97735_, this.f_97736_ + ypos, 0, 112, 182, this.rows == 5 ? 18 : 36);
                ypos += this.rows == 5 ? 18 : 36;
            }
            if ((rem = this.slotCount % 9) != 0) {
                int left = rem == 3 ? 64 : 118;
                this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + ypos - 18, left, this.rows % 2 == 0 ? 82 : 64, 182 - left - 10, 18);
            }
            this.m_93228_(matrixStack, this.f_97735_, this.f_97736_ + ypos, 0, 148, 182, 10);
        } else {
            int left = this.colOffset;
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_, 0, 102, 10, 46);
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + 46, 0, 112, 10, 18);
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + 64, 0, 148, 10, 10);
            int half = (this.columns / 2 - 1) * 18;
            this.m_93228_(matrixStack, this.f_97735_ + (left += 10), this.f_97736_, 64 - half, 102, this.columns * 18, 46);
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + 46, 64 - half, 112, this.columns * 18, 18);
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + 64, 64 - half, 148, this.columns * 18, 10);
            this.m_93228_(matrixStack, this.f_97735_ + (left += this.columns * 18), this.f_97736_, 172, 102, 10, 46);
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + 46, 172, 112, 10, 18);
            this.m_93228_(matrixStack, this.f_97735_ + left, this.f_97736_ + 64, 172, 148, 10, 10);
            ypos += 64;
        }
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_ + (ypos += 10), 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    protected void m_6597_(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        ItemStack stack;
        if (slot != null && slot.m_6657_() && !(stack = slot.m_7993_()).m_41619_() && stack.m_41720_() instanceof ItemEnderBag && ItemEnderBag.isOpen(stack)) {
            return;
        }
        super.m_6597_(slot, slotId, clickedButton, clickType);
    }
}

