/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.NamedRenderTypeManager;

public abstract class ModelGenerator
extends ResourceGenerator {
    private static final Field RENDER_TYPES;
    private final Map<ResourceLocation, ModelBuilder> models = new HashMap<ResourceLocation, ModelBuilder>();

    private static boolean isRenderTypeRegistered(ResourceLocation identifier) {
        try {
            return ((ImmutableMap)RENDER_TYPES.get(null)).containsKey((Object)identifier);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public ModelGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (ModelBuilder modelBuilder : this.models.values()) {
            JsonObject json = this.convertToJson(modelBuilder);
            ResourceLocation identifier = modelBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.m_135827_(), "models", identifier.m_135815_());
        }
    }

    protected JsonObject convertToJson(ModelBuilder modelBuilder) {
        JsonObject json = new JsonObject();
        ResourceLocation parentModel = modelBuilder.parent;
        if (parentModel != null) {
            if (!this.models.containsKey(parentModel) && !this.cache.doesResourceExist(ResourceType.ASSET, parentModel.m_135827_(), "models", parentModel.m_135815_(), ".json")) {
                throw new RuntimeException("Could find parent model '" + parentModel + "' for model '" + modelBuilder.identifier + "'!");
            }
            json.addProperty("parent", parentModel.toString());
        }
        if (modelBuilder.renderType != null) {
            json.addProperty("render_type", modelBuilder.renderType.toString());
        }
        if (!modelBuilder.ambientOcclusion) {
            json.addProperty("ambientocclusion", Boolean.valueOf(false));
        }
        if (!modelBuilder.transforms.isEmpty()) {
            JsonObject displayJson = new JsonObject();
            for (Map.Entry<ItemTransforms.TransformType, TransformBuilder> entry : modelBuilder.transforms.entrySet()) {
                JsonObject transformJson = new JsonObject();
                transformJson.add("rotation", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().rotation.m_122239_(), entry.getValue().rotation.m_122260_(), entry.getValue().rotation.m_122269_()));
                transformJson.add("translation", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().translation.m_122239_(), entry.getValue().translation.m_122260_(), entry.getValue().translation.m_122269_()));
                transformJson.add("scale", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().scale.m_122239_(), entry.getValue().scale.m_122260_(), entry.getValue().scale.m_122269_()));
                displayJson.add(entry.getKey().getSerializeName(), (JsonElement)transformJson);
            }
            json.add("display", (JsonElement)displayJson);
        }
        if (!modelBuilder.textures.isEmpty()) {
            JsonObject texturesJson = new JsonObject();
            for (Map.Entry<Object, Object> entry : modelBuilder.textures.entrySet()) {
                ResourceLocation texture;
                if (((String)entry.getValue()).charAt(0) != '#' && !this.cache.doesResourceExist(ResourceType.ASSET, (texture = new ResourceLocation((String)entry.getValue())).m_135827_(), "textures", texture.m_135815_(), ".png")) {
                    throw new IllegalArgumentException("Could not find texture '" + texture + "' for model '" + modelBuilder.identifier + "'!");
                }
                texturesJson.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            json.add("textures", (JsonElement)texturesJson);
        }
        if (modelBuilder.lighting != null) {
            json.addProperty("gui_light", modelBuilder.lighting.getSerializedName());
        }
        if (!modelBuilder.elements.isEmpty()) {
            JsonArray elementsJson = new JsonArray();
            for (ElementBuilder elementBuilder : modelBuilder.elements) {
                JsonObject facesJson;
                JsonObject elementJson = new JsonObject();
                elementJson.add("from", (JsonElement)ModelGenerator.createJsonArray(elementBuilder.from.m_122239_(), elementBuilder.from.m_122260_(), elementBuilder.from.m_122269_()));
                elementJson.add("to", (JsonElement)ModelGenerator.createJsonArray(elementBuilder.to.m_122239_(), elementBuilder.to.m_122260_(), elementBuilder.to.m_122269_()));
                if (elementBuilder.rotation != null) {
                    JsonObject rotationJson = new JsonObject();
                    rotationJson.add("origin", (JsonElement)ModelGenerator.createJsonArray(elementBuilder.rotation.origin.m_122239_(), elementBuilder.rotation.origin.m_122260_(), elementBuilder.rotation.origin.m_122269_()));
                    rotationJson.addProperty("axis", elementBuilder.rotation.axis.m_7912_());
                    rotationJson.addProperty("angle", (Number)Float.valueOf(elementBuilder.rotation.angle));
                    rotationJson.addProperty("rescale", Boolean.valueOf(elementBuilder.rotation.rescale));
                    elementJson.add("rotation", (JsonElement)rotationJson);
                }
                if (!elementBuilder.shading) {
                    elementJson.addProperty("shade", Boolean.valueOf(false));
                }
                if (!elementBuilder.faces.isEmpty()) {
                    facesJson = new JsonObject();
                    for (Map.Entry<Direction, FaceBuilder> entry : elementBuilder.faces.entrySet()) {
                        JsonObject faceJson = new JsonObject();
                        if (entry.getValue().texture == null) {
                            throw new RuntimeException("Model '" + modelBuilder.identifier + "' has face without a texture!");
                        }
                        faceJson.addProperty("texture", entry.getValue().texture);
                        if (entry.getValue().uv != null) {
                            faceJson.add("uv", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().uv));
                        }
                        if (entry.getValue().cullface != null) {
                            faceJson.addProperty("cullface", entry.getValue().cullface.m_7912_());
                        }
                        if (entry.getValue().emissivity != 0) {
                            faceJson.addProperty("emissivity", (Number)entry.getValue().emissivity);
                        }
                        if (entry.getValue().rotation != 0) {
                            faceJson.addProperty("rotation", (Number)entry.getValue().rotation);
                        }
                        if (entry.getValue().tintIndex != -1) {
                            faceJson.addProperty("tintindex", (Number)entry.getValue().tintIndex);
                        }
                        facesJson.add(entry.getKey().m_7912_(), (JsonElement)faceJson);
                    }
                } else {
                    throw new RuntimeException("Element in model '" + modelBuilder.identifier + "' has no faces!");
                }
                elementJson.add("faces", (JsonElement)facesJson);
                elementsJson.add((JsonElement)elementJson);
            }
            json.add("elements", (JsonElement)elementsJson);
        }
        return json;
    }

    private static JsonArray createJsonArray(float ... elements) {
        JsonArray array = new JsonArray(elements.length);
        float[] fArray = elements;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float element = Float.valueOf(fArray[i]);
            array.add((Number)element);
        }
        return array;
    }

    protected ModelBuilder model(ResourceLocation location) {
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, location.m_135827_(), "models", location.m_135815_(), ".json");
        return this.models.computeIfAbsent(location, i -> new ModelBuilder(this.modid, (ResourceLocation)i));
    }

    protected ModelBuilder model(String namespace, String path) {
        return this.model(new ResourceLocation(namespace, path));
    }

    protected ModelBuilder model(String location) {
        return this.model(this.modid, location);
    }

    protected ModelBuilder cube(ResourceLocation location, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation east, ResourceLocation south, ResourceLocation west) {
        return this.model(location).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cube(String namespace, String path, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation east, ResourceLocation south, ResourceLocation west) {
        return this.model(namespace, path).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cube(String location, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation east, ResourceLocation south, ResourceLocation west) {
        return this.model(location).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cubeAll(ResourceLocation location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder cubeAll(String namespace, String path, ResourceLocation texture) {
        return this.model(namespace, path).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder cubeAll(String location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder slabBottom(ResourceLocation location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabBottom(String namespace, String path, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(namespace, path).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabBottom(String location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(ResourceLocation location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(String namespace, String path, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(namespace, path).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(String location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(ResourceLocation location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(String namespace, String path, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(namespace, path).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(String location, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        return this.model(location).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder itemGenerated(ResourceLocation location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(String namespace, String path, ResourceLocation texture) {
        return this.model(namespace, path).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(String location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(ItemLike item, ResourceLocation texture) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(item.m_5456_());
        return this.model(identifier.m_135827_(), "item/" + identifier.m_135815_()).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(ResourceLocation location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(String namespace, String path, ResourceLocation texture) {
        return this.model(namespace, path).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(String location, ResourceLocation texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(ItemLike item, ResourceLocation texture) {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(item.m_5456_());
        return this.model(identifier.m_135827_(), "item/" + identifier.m_135815_()).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    @Override
    public String getName() {
        return this.modName + " Model Generator";
    }

    static {
        try {
            RENDER_TYPES = NamedRenderTypeManager.class.getDeclaredField("RENDER_TYPES");
            RENDER_TYPES.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class ModelBuilder {
        protected final String modid;
        protected final ResourceLocation identifier;
        private final Map<String, String> textures = new HashMap<String, String>();
        private final Map<ItemTransforms.TransformType, TransformBuilder> transforms = new HashMap<ItemTransforms.TransformType, TransformBuilder>();
        private final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
        private ResourceLocation parent;
        private ResourceLocation renderType;
        private boolean ambientOcclusion = true;
        private BlockModel.GuiLight lighting = null;

        protected ModelBuilder(String modid, ResourceLocation identifier) {
            this.modid = modid;
            this.identifier = identifier;
        }

        public ModelBuilder parent(ResourceLocation model) {
            if (this.identifier.equals((Object)model)) {
                throw new IllegalArgumentException("Cannot add self as parent model '" + model + "'!");
            }
            this.parent = model;
            return this;
        }

        public ModelBuilder parent(String namespace, String path) {
            return this.parent(new ResourceLocation(namespace, path));
        }

        public ModelBuilder parent(String model) {
            return this.parent(this.modid, model);
        }

        public ModelBuilder renderType(ResourceLocation renderType) {
            if (!ModelGenerator.isRenderTypeRegistered(renderType)) {
                throw new RuntimeException("Could not find any object registered under '" + renderType + "'!");
            }
            this.renderType = renderType;
            return this;
        }

        public ModelBuilder renderType(String namespace, String identifier) {
            return this.renderType(new ResourceLocation(namespace, identifier));
        }

        public ModelBuilder renderTypeSolid() {
            return this.renderType(new ResourceLocation("solid"));
        }

        public ModelBuilder renderTypeCutout() {
            return this.renderType(new ResourceLocation("cutout"));
        }

        public ModelBuilder renderTypeCutoutMipped() {
            return this.renderType(new ResourceLocation("cutout_mipped"));
        }

        public ModelBuilder renderTypeCutoutMippedAll() {
            return this.renderType(new ResourceLocation("cutout_mipped_all"));
        }

        public ModelBuilder renderTypeTranslucent() {
            return this.renderType(new ResourceLocation("translucent"));
        }

        public ModelBuilder ambientOcclusion(boolean useAmbientOcclusion) {
            this.ambientOcclusion = useAmbientOcclusion;
            return this;
        }

        public ModelBuilder noAmbientOcclusion() {
            return this.ambientOcclusion(false);
        }

        public ModelBuilder frontLit() {
            this.lighting = BlockModel.GuiLight.FRONT;
            return this;
        }

        public ModelBuilder sideLit() {
            this.lighting = BlockModel.GuiLight.SIDE;
            return this;
        }

        public ModelBuilder texture(String key, ResourceLocation texture) {
            this.textures.put(key, texture.toString());
            return this;
        }

        public ModelBuilder texture(String key, String texture) {
            if (texture.charAt(0) != '#' && !RegistryUtil.isValidIdentifier(texture)) {
                throw new IllegalArgumentException("Texture entry must either start with '#' or be a valid resource location, not '" + texture + "'!");
            }
            if (texture.charAt(0) != '#') {
                return this.texture(key, texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.modid, texture));
            }
            this.textures.put(key, texture);
            return this;
        }

        public ModelBuilder texture(String key, String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.texture(key, new ResourceLocation(namespace, identifier));
            return this;
        }

        public ModelBuilder particleTexture(ResourceLocation texture) {
            return this.texture("particle", texture);
        }

        public ModelBuilder particleTexture(String texture) {
            return this.texture("particle", texture);
        }

        public ModelBuilder particleTexture(String namespace, String identifier) {
            return this.texture("particle", namespace, identifier);
        }

        public ModelBuilder transform(ItemTransforms.TransformType transformType, Consumer<TransformBuilder> transformBuilderConsumer) {
            transformBuilderConsumer.accept(this.transforms.computeIfAbsent(transformType, o -> new TransformBuilder()));
            return this;
        }

        public ModelBuilder element(Consumer<ElementBuilder> elementBuilderConsumer) {
            ElementBuilder builder = new ElementBuilder();
            elementBuilderConsumer.accept(builder);
            this.elements.add(builder);
            return this;
        }
    }

    protected static class TransformBuilder {
        private Vector3f rotation = ItemTransform.Deserializer.f_111769_.m_122281_();
        private Vector3f translation = ItemTransform.Deserializer.f_111770_.m_122281_();
        private Vector3f scale = ItemTransform.Deserializer.f_111771_.m_122281_();

        protected TransformBuilder() {
        }

        public TransformBuilder rotation(float x, float y, float z) {
            this.rotation = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder translation(float x, float y, float z) {
            this.translation = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder scale(float x, float y, float z) {
            this.scale = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder scale(float scale) {
            return this.scale(scale, scale, scale);
        }
    }

    protected static class ElementBuilder {
        private final Map<Direction, FaceBuilder> faces = new HashMap<Direction, FaceBuilder>();
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private RotationBuilder rotation;
        private boolean shading = true;

        protected ElementBuilder() {
        }

        public ElementBuilder from(Vector3f from) {
            this.from = from;
            return this;
        }

        public ElementBuilder from(float x, float y, float z) {
            return this.from(new Vector3f(x, y, z));
        }

        public ElementBuilder to(Vector3f to) {
            this.to = to;
            return this;
        }

        public ElementBuilder to(float x, float y, float z) {
            return this.to(new Vector3f(x, y, z));
        }

        public ElementBuilder shape(Vector3f from, Vector3f to) {
            this.from(from);
            this.to(to);
            return this;
        }

        public ElementBuilder shape(float minX, float minY, int minZ, float maxX, float maxY, float maxZ) {
            return this.shape(new Vector3f(minX, minY, (float)minZ), new Vector3f(maxX, maxY, maxZ));
        }

        public ElementBuilder shading(boolean doShading) {
            this.shading = doShading;
            return this;
        }

        public ElementBuilder noShading() {
            return this.shading(false);
        }

        public ElementBuilder face(Direction side, Consumer<FaceBuilder> faceBuilderConsumer) {
            faceBuilderConsumer.accept(this.faces.computeIfAbsent(side, FaceBuilder::new));
            return this;
        }

        public ElementBuilder allFaces(BiFunction<Direction, FaceBuilder, Boolean> faceBuilderFunction) {
            for (Direction side : Direction.values()) {
                if (faceBuilderFunction.apply(side, this.faces.computeIfAbsent(side, FaceBuilder::new)).booleanValue()) continue;
                this.faces.remove(side);
            }
            return this;
        }

        public ElementBuilder allFaces(BiConsumer<Direction, FaceBuilder> faceBuilderConsumer) {
            return this.allFaces((Direction direction, FaceBuilder faceBuilder) -> {
                faceBuilderConsumer.accept((Direction)direction, (FaceBuilder)faceBuilder);
                return true;
            });
        }

        public ElementBuilder allFaces(Consumer<FaceBuilder> faceBuilderConsumer) {
            return this.allFaces((Direction direction, FaceBuilder faceBuilder) -> {
                faceBuilderConsumer.accept((FaceBuilder)faceBuilder);
                return true;
            });
        }

        public ElementBuilder rotation(Consumer<RotationBuilder> rotationBuilderConsumer) {
            if (this.rotation == null) {
                this.rotation = new RotationBuilder();
            }
            rotationBuilderConsumer.accept(this.rotation);
            return this;
        }
    }

    protected static class RotationBuilder {
        private Vector3f origin;
        private Direction.Axis axis;
        private float angle;
        private boolean rescale;

        protected RotationBuilder() {
        }

        public RotationBuilder origin(Vector3f origin) {
            this.origin = origin;
            return this;
        }

        public RotationBuilder origin(float x, float y, float z) {
            return this.origin(new Vector3f(x, y, z));
        }

        public RotationBuilder axis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        public RotationBuilder angle(float angle) {
            if (angle != 0.0f && Math.abs(angle) != 22.5f && Math.abs(angle) != 45.0f) {
                throw new IllegalArgumentException("Angle must be one of -45, -22.5, 0, 22.5, or 45, not '" + angle + "'!");
            }
            this.angle = angle;
            return this;
        }

        public RotationBuilder rescale(boolean rescale) {
            this.rescale = rescale;
            return this;
        }

        public RotationBuilder rescale() {
            return this.rescale(true);
        }
    }

    protected static class FaceBuilder {
        private final Direction side;
        private float[] uv;
        private String texture;
        private Direction cullface;
        private int rotation = 0;
        private int tintIndex = -1;
        private int emissivity = 0;

        protected FaceBuilder(Direction side) {
            this.side = side;
        }

        public FaceBuilder uv(float minX, float minY, float maxX, float maxY) {
            this.uv = new float[]{minX, minY, maxX, maxY};
            return this;
        }

        public FaceBuilder texture(String reference) {
            if (!(reference.charAt(0) == '#' ? reference.substring(1) : reference).matches("[a-zA-Z_-]*")) {
                throw new IllegalArgumentException("Texture reference '" + reference + "' must only contain characters [a-zA-Z_-]!");
            }
            this.texture = reference.charAt(0) == '#' ? reference : "#" + reference;
            return this;
        }

        public FaceBuilder cullface(Direction side) {
            this.cullface = side;
            return this;
        }

        public FaceBuilder cullface() {
            this.cullface(this.side);
            return this;
        }

        public FaceBuilder rotation(int rotation) {
            if (rotation % 90 != 0) {
                throw new IllegalArgumentException("Rotation must be a multiple of 90, not '" + rotation + "'!");
            }
            this.rotation = rotation;
            return this;
        }

        public FaceBuilder tintIndex(int index) {
            this.tintIndex = index;
            return this;
        }

        public FaceBuilder emissivity(int emissivity) {
            if (emissivity < 0 || emissivity > 15) {
                throw new IllegalArgumentException("Emissivity must be between 0 and 15, not '" + emissivity + "'!");
            }
            this.emissivity = emissivity;
            return this;
        }
    }
}

