/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.passive.CrogreEntity;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmberbackEntity
extends SkiesMonsterEntity {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(EmberbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    public int attackTimer;
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance flapSound;

    public EmberbackEntity(EntityType<? extends EmberbackEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new AIMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CrogreEntity.class, 8.0f, 0.6, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)0.4f, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, this.m_21525_() ? Vec3.f_82478_ : pos);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FLYING, (Object)false);
    }

    public void setFlying(boolean type) {
        this.m_20242_(type);
        this.f_19804_.m_135381_(FLYING, (Object)type);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.f_19853_.f_46443_) {
            this.updateWingRotation();
            if (this.isFlying() || this.attackTimer > 0) {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.m_21525_() && this.m_6084_() && !this.f_19800_) {
            if (this.m_5448_() != null) {
                LivingEntity entitylivingbase = this.m_5448_();
                if (this.m_20270_((Entity)entitylivingbase) <= 4.0f) {
                    this.setFlying(false);
                } else if (this.isFlying()) {
                    if (this.f_19861_ || !this.f_19853_.m_46859_(this.m_20183_().m_7495_())) {
                        this.m_20334_(this.m_20184_().m_7096_(), 0.5, this.m_20184_().m_7094_());
                    }
                    this.m_21573_().m_26573_();
                    Vec3 vec3d = entitylivingbase.m_20299_(1.0f);
                    this.m_21566_().m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                    this.m_21563_().m_24964_(vec3d);
                } else if (!this.isFlying()) {
                    this.setFlying(true);
                }
            } else if (!this.f_19853_.f_46443_ && this.m_5448_() == null) {
                this.setFlying(false);
            }
        }
    }

    public float getDistance(BlockPos posIn) {
        return EntityUtil.getDistanceToPos((Vec3i)this.m_20183_(), (Vec3i)posIn);
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setFlying(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateWingRotation() {
        if (!this.m_20067_() && this.f_19853_.f_46443_) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (!soundHandler.m_120403_(this.flapSound) && this.isFlying()) {
                this.flapSound = new MovingEntitySound((LivingEntity)this, SkiesSounds.ENTITY_EMBERBACK_FLYING);
                soundHandler.m_120367_(this.flapSound);
            } else if (!this.isFlying()) {
                soundHandler.m_120399_(this.flapSound);
            }
        }
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22284_, 10.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsFlying", this.isFlying());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setFlying(compound.m_128471_("IsFlying"));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_EMBERBACK_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_EMBERBACK_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_EMBERBACK_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.3f);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        boolean randomBoolean = this.f_19853_.m_46471_() ? true : this.f_19796_.m_188499_();
        return randomBoolean && super.m_5545_(worldIn, spawnReasonIn);
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    public int m_5792_() {
        return 1;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.5f;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7327_(Entity entityIn) {
        if (entityIn instanceof LivingEntity && (this.f_19800_ || entityIn.m_5825_() || ((LivingEntity)entityIn).m_21023_(MobEffects.f_19607_))) {
            LivingEntity target = this.m_5448_();
            if (this.f_19861_) {
                Vec3 motion = this.m_20184_();
                Vec3 targetDirection = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_());
                if (targetDirection.m_82556_() > 1.0E-7) {
                    targetDirection = targetDirection.m_82541_().m_82490_(0.4).m_82549_(motion.m_82490_(0.2));
                }
                this.m_20334_(targetDirection.f_82479_, 0.3f, targetDirection.f_82481_);
            }
            return entityIn.m_6469_(EntityUtil.DamageSources.causeBiteDamage((Entity)this), 3.0f);
        }
        for (LivingEntity living : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(2.0), EntityUtil.CAN_ATTACK)) {
            if (living == this || living.m_5825_() || !living.m_6469_(EntityUtil.DamageSources.causeEmberDamage((Entity)this), 3.0f)) continue;
            living.m_20254_(1 + this.f_19853_.f_46441_.m_188503_(5));
        }
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.attackTimer = 10;
        this.m_5496_(SkiesSounds.ENTITY_EMBERBACK_SPRAY, this.m_6121_(), this.m_6100_());
        return true;
    }

    public void m_7023_(Vec3 vec) {
        if (this.isFlying()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                BlockPos ground = new BlockPos(this.m_20185_(), this.m_20191_().f_82289_ - 1.0, this.m_20189_());
                float f = 0.91f;
                if (this.f_19861_) {
                    f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.f_19861_) {
                    f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
                }
                this.m_19920_(this.f_19861_ ? 0.1f * f1 : 0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
            this.f_20923_ = this.f_20924_;
            double d1 = this.m_20185_() - this.f_19854_;
            double d0 = this.m_20189_() - this.f_19856_;
            float f2 = Mth.m_14116_((float)((float)(d1 * d1 + d0 * d0))) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.f_20924_ += (f2 - this.f_20924_) * 0.4f;
            this.f_20925_ += this.f_20924_;
        } else {
            super.m_7023_(vec);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                for (int i = 0; i < 30; ++i) {
                    double xSpeed = this.f_19796_.m_188583_() * 0.2;
                    double ySpeed = this.f_19796_.m_188583_() * 0.2;
                    double zSpeed = this.f_19796_.m_188583_() * 0.2;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), xSpeed, ySpeed, zSpeed);
                }
                this.attackTimer = 10;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    class AIMoveControl
    extends MoveControl {
        public AIMoveControl(EmberbackEntity bug) {
            super((Mob)bug);
        }

        public void m_8126_() {
            if (EmberbackEntity.this.m_5448_() != null && EmberbackEntity.this.isFlying()) {
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                    this.f_24981_ = MoveControl.Operation.MOVE_TO;
                }
                Vec3 vec3d = new Vec3(this.f_24975_ - EmberbackEntity.this.m_20185_(), this.f_24976_ - EmberbackEntity.this.m_20186_(), this.f_24977_ - EmberbackEntity.this.m_20189_());
                double d0 = vec3d.m_82553_();
                EmberbackEntity.this.m_20256_(EmberbackEntity.this.m_20184_().m_82549_(vec3d.m_82490_(this.getSpeed() * 0.05 / d0)));
                double d4 = EmberbackEntity.this.m_5448_().m_20185_() - EmberbackEntity.this.m_20185_();
                double d5 = EmberbackEntity.this.m_5448_().m_20189_() - EmberbackEntity.this.m_20189_();
                EmberbackEntity.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                EmberbackEntity.this.f_20883_ = EmberbackEntity.this.f_20885_ = EmberbackEntity.this.m_146908_();
            } else {
                super.m_8126_();
            }
        }

        public double getSpeed() {
            return 0.45f;
        }
    }
}

