/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.util.ListSet;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class TransmuteRecipe
extends AlchemyRecipe {
    private static final Codec<TransmuteRecipe> CODEC = RecordCodecBuilder.create(instance -> {
        Products.P2 parent = TransmuteRecipe.parentCodec(instance);
        return instance.group(parent.t1(), parent.t2(), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("items", Collections.emptyList()).forGetter(r -> r.items), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).listOf().optionalFieldOf("tags", Collections.emptyList()).forGetter(r -> r.itemTags), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("blacklist", Collections.emptyList()).forGetter(r -> r.resultBlacklist)).apply((Applicative)instance, TransmuteRecipe::new);
    });
    private final List<ResourceLocation> items;
    private final List<TagKey<Item>> itemTags;
    private final List<ResourceLocation> resultBlacklist;
    @Nullable
    protected ListSet<Item> cachedResults = null;

    private TransmuteRecipe(boolean shouldOverride, ResourceLocation type, List<ResourceLocation> items, List<TagKey<Item>> itemTags, List<ResourceLocation> resultBlacklist) {
        super(shouldOverride, type);
        this.items = items;
        this.itemTags = itemTags;
        this.resultBlacklist = resultBlacklist;
    }

    private TransmuteRecipe(Builder builder) {
        this(builder.shouldOverride, BlueSkies.locate("transmute"), builder.items, builder.itemTags, builder.resultBlacklist);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    public void mergeRecipe(AlchemyRecipe recipe) {
        if (recipe instanceof TransmuteRecipe) {
            TransmuteRecipe transmute = (TransmuteRecipe)recipe;
            this.items.addAll(transmute.items);
            this.itemTags.addAll(transmute.itemTags);
            this.resultBlacklist.addAll(transmute.resultBlacklist);
        }
    }

    @Override
    public List<Item> getResults(Item inputA, Item inputB) {
        List<Item> results = this.getResults();
        results.remove(inputA);
        results.remove(inputB);
        return results;
    }

    @Override
    public List<Item> getResults() {
        if (this.cachedResults == null) {
            this.cachedResults = TransmuteRecipe.computeValues(this.items, this.itemTags);
            this.cachedResults.removeAll(TransmuteRecipe.computeValues(this.resultBlacklist, List.of()));
        }
        return this.cachedResults.clone();
    }

    @Override
    public boolean matches(Item itemA, Item itemB) {
        return (itemB == Items.f_41852_ || itemB == null) && this.getResults().contains(itemA);
    }

    @Override
    public TransmuteRecipe fromJson(JsonObject json) {
        return (TransmuteRecipe)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, JsonParseException::new)).getFirst();
    }

    @Override
    public JsonObject toJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, IllegalStateException::new)).getAsJsonObject();
    }

    public static class Builder {
        private final String name;
        private boolean shouldOverride = false;
        private List<ResourceLocation> items = new ArrayList<ResourceLocation>();
        private List<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        private List<ResourceLocation> resultBlacklist = new ArrayList<ResourceLocation>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder shouldOverride() {
            this.shouldOverride = true;
            return this;
        }

        public Builder items(ItemLike ... items) {
            for (ItemLike item : items) {
                this.items.add(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
            }
            return this;
        }

        public Builder items(List<ItemLike> items) {
            return this.items((ItemLike[])items.toArray(ItemLike[]::new));
        }

        public Builder withTag(TagKey<Item> itemTag) {
            this.itemTags.add(itemTag);
            return this;
        }

        public Builder resultBlacklist(ItemLike ... items) {
            for (ItemLike item : items) {
                this.resultBlacklist.add(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
            }
            return this;
        }

        public Builder resultBlacklist(String modID, String ... itemNames) {
            for (String itemName : itemNames) {
                this.resultBlacklist.add(new ResourceLocation(modID, itemName));
            }
            return this;
        }

        public String getName() {
            return this.name;
        }

        public TransmuteRecipe build() {
            if (this.items.isEmpty() && this.itemTags.isEmpty()) {
                throw new IllegalStateException("Transmute recipe with name " + this.name + " had no items");
            }
            return new TransmuteRecipe(this);
        }
    }
}

