/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.events;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.client.IncompatHandler;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.client.audio.ambient.DungeonAmbientSoundHandler;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.PerksScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.widgets.InventoryTabButton;
import com.legacy.blue_skies.client.gui.screen.widgets.SimpleInventoryTabButton;
import com.legacy.blue_skies.client.renders.world.BrightWeatherRenderer;
import com.legacy.blue_skies.client.renders.world.BrightWeatherTick;
import com.legacy.blue_skies.client.renders.world.DawnWeatherRenderer;
import com.legacy.blue_skies.client.renders.world.DawnWeatherTick;
import com.legacy.blue_skies.client.renders.world.StarrySkyRenderer;
import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.items.tools.weapons.SpearItem;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.c_to_s.OpenInventoryPacket;
import com.legacy.blue_skies.network.c_to_s.OpenedLorePacket;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.BiomeAmbientSoundsHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.versions.forge.ForgeVersion;

public class SkiesClientEvents {
    private static final Minecraft mc = Minecraft.m_91087_();
    public static float sandstormStrength = 0.0f;
    public static float snowstormStrength = 0.0f;
    public static int clientTicks;
    public static int inventoryTabCount;
    private static boolean inDungeon;
    private static DungeonAmbientSoundHandler dungeonAmbientSoundHandler;
    private static final ResourceLocation BLUE_SKIES_ICONS;
    public static final ResourceLocation UPDATE_LOGO;
    private static final DimensionSpecialEffects EVERBRIGHT_RENDER_INFO;
    private static final DimensionSpecialEffects EVERDAWN_RENDER_INFO;

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "nature_arc_health_bonus", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
            if (!SkiesClientEvents.mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                gui.setupOverlayRenderState(true, false);
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)BLUE_SKIES_ICONS);
                float health = SkiesPlayer.getIfPresent(SkiesClientEvents.mc.f_91074_, ISkiesPlayer::getNatureHealth, () -> Float.valueOf(0.0f)).floatValue();
                int width = mc.m_91268_().m_85445_();
                int height = mc.m_91268_().m_85446_();
                int i = 0;
                while ((float)i < health / 2.0f) {
                    int x = width / 2 - 91 + i * 8;
                    int y = height - gui.leftHeight;
                    SkiesClientEvents.mc.f_91065_.m_93228_(mStack, x, y, health - (float)(i * 2) <= 1.0f ? 9 : 0, 0, 9, 9);
                    ++i;
                }
                if (health > 0.0f) {
                    gui.leftHeight += 10;
                }
                RenderSystem.m_69461_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            }
        });
    }

    public static void initDimensionRenderInfo(RegisterDimensionSpecialEffectsEvent event) {
        event.register(SkiesDimensions.EVERBRIGHT_ID, EVERBRIGHT_RENDER_INFO);
        event.register(SkiesDimensions.EVERDAWN_ID, EVERDAWN_RENDER_INFO);
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (SkiesPlayer.getIfPresent(player, ISkiesPlayer::hasFullDuskInvis, () -> false).booleanValue() && !SkiesClientEvents.mc.f_91074_.m_5833_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onOpenGui(ScreenEvent.Opening event) {
        Screen screen = event.getScreen();
        if (SkiesClientEvents.mc.f_91080_ != null && SkiesClientEvents.mc.f_91080_.getClass().getPackageName().startsWith("net.optifine.shaders") && (screen == null || screen != null && !screen.getClass().getPackageName().startsWith("net.optifine.shaders"))) {
            new Timer("Blue Skies Warning Timer").schedule(IncompatHandler.Optifine.getTask(), 5000L);
        }
        if (screen == null) {
            return;
        }
        if (screen instanceof TitleScreen) {
            SkiesPlayerEvents.spawnDimensionID = 0;
            if (BlueSkiesConfig.CLIENT.isPanoramaCustom()) {
                Panoramas.setNewPanorama();
                event.setNewScreen((Screen)new TitleScreen());
            }
        }
        if ((screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) && SkiesClientEvents.mc.f_91074_ != null && SkiesClientEvents.mc.f_91074_.m_20202_() != null && SkiesClientEvents.mc.f_91074_.m_20202_() instanceof SkiesMountEntity) {
            event.setCanceled(true);
            PacketHandler.sendToServer(new OpenInventoryPacket.Mount());
        }
    }

    @SubscribeEvent
    public static void openGuiEvent(ScreenEvent.Init.Post event) {
        Screen screen;
        if (BlueSkies.isIndevBuild() && event.getScreen() instanceof CreateWorldScreen) {
            MutableComponent overworld = Component.m_237113_((String)"Spawn: Overworld");
            MutableComponent bright = Component.m_237113_((String)"Spawn: Everbright");
            MutableComponent dawn = Component.m_237113_((String)"Spawn: Everdawn");
            event.addListener((GuiEventListener)new Button(10, 10, 98, 20, (Component)(SkiesPlayerEvents.spawnDimensionID == 1 ? bright : (SkiesPlayerEvents.spawnDimensionID == 2 ? dawn : overworld)), arg_0 -> SkiesClientEvents.lambda$openGuiEvent$3((Component)bright, (Component)dawn, (Component)overworld, arg_0)));
        }
        if (SkiesClientEvents.areInventoryTabsVisible(screen = event.getScreen())) {
            boolean simpleFlag = BlueSkiesConfig.CLIENT.useSimpleInventoryTabs() || screen.getClass() == CreativeModeInventoryScreen.class;
            InventoryButtonFactory buttonFactory = simpleFlag ? SimpleInventoryTabButton::new : InventoryTabButton::new;
            inventoryTabCount = 0;
            event.addListener((GuiEventListener)buttonFactory.create(0, screen, !(screen.getClass() == InventoryScreen.class ^ screen.getClass() == CreativeModeInventoryScreen.class), inventoryTabCount++, button -> {
                LocalPlayer player = SkiesClientEvents.mc.f_91074_;
                player.f_36096_.m_142503_(ItemStack.f_41583_);
                mc.m_91152_((Screen)new InventoryScreen((Player)player));
                PacketHandler.sendToServer(new OpenInventoryPacket.Vanilla());
            }));
            event.addListener((GuiEventListener)buttonFactory.create(1, screen, screen.getClass() != ArcsScreen.class, inventoryTabCount++, button -> {
                LocalPlayer player = SkiesClientEvents.mc.f_91074_;
                player.f_36096_.m_142503_(ItemStack.f_41583_);
                PacketHandler.sendToServer(new OpenInventoryPacket.Arcs());
            }));
            SkiesPlayer.ifPresent(SkiesClientEvents.mc.f_91074_, player -> {
                if (player.hasUsedBlueLore()) {
                    event.addListener((GuiEventListener)(simpleFlag ? SimpleInventoryTabButton::new : InventoryTabButton::new).createWithSound(3, screen, screen.getClass() != BlueJournalScreen.class, inventoryTabCount++, button -> {
                        if (SkiesClientEvents.mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                            SkiesPlayer.ifPresent(SkiesClientEvents.mc.f_91074_, skyPlayer -> skyPlayer.setOpenedBlueLore(true));
                            PacketHandler.sendToServer(new OpenedLorePacket());
                            BlueJournalScreen.open(false);
                        }
                    }, SoundEvents.f_11713_));
                }
            });
            if (BlueSkies.ML_SUPPORTER.getRank((Player)SkiesClientEvents.mc.f_91074_).hasPerks()) {
                event.addListener((GuiEventListener)buttonFactory.create(2, screen, screen.getClass() != PerksScreen.class, inventoryTabCount++, button -> {
                    if (SkiesClientEvents.mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                        mc.m_91152_((Screen)new PerksScreen());
                    }
                }));
            }
        }
    }

    public static boolean areInventoryTabsVisible(Screen screen) {
        return screen.getClass() == InventoryScreen.class || screen.getClass() == CreativeModeInventoryScreen.class || screen.getClass() == ArcsScreen.class || screen.getClass() == PerksScreen.class;
    }

    @SubscribeEvent
    public static void drawScreenEvent(ScreenEvent.Render.Post event) {
        MerchantScreen tradeScreen;
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen && BlueSkies.isIndevBuild()) {
            VersionChecker.Status status = ForgeVersion.getStatus();
            String text = "This is a Blue Skies indev build; it may be extremely unfinished or unplayable.";
            String subtitle = "Please make sure you know what you are doing!";
            int height = status == VersionChecker.Status.BETA || status == VersionChecker.Status.BETA_OUTDATED ? screen.f_96544_ - 25 : 5;
            GuiComponent.m_93215_((PoseStack)event.getPoseStack(), (Font)SkiesClientEvents.mc.f_91062_, (Component)Component.m_237115_((String)text).m_130940_(ChatFormatting.RED), (int)(screen.f_96543_ / 2), (int)height, (int)0xFFFFFF);
            GuiComponent.m_93215_((PoseStack)event.getPoseStack(), (Font)SkiesClientEvents.mc.f_91062_, (Component)Component.m_237115_((String)subtitle).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD, ChatFormatting.UNDERLINE}), (int)(screen.f_96543_ / 2), (int)(height + 11), (int)0xFFFFFF);
        }
        if (screen instanceof MerchantScreen && ((MerchantMenu)(tradeScreen = (MerchantScreen)screen).m_6262_()).m_40075_().size() >= 2 && ((MerchantMenu)tradeScreen.m_6262_()).m_40075_().get(1) != null && ((MerchantOffer)((MerchantMenu)tradeScreen.m_6262_()).m_40075_().get((int)1)).f_45312_.m_41720_() == SkiesItems.blue_journal) {
            SkiesPlayer.ifPresent(SkiesClientEvents.mc.f_91074_, skyPlayer -> {
                if (!skyPlayer.hasUsedBlueLore()) {
                    SkiesClientUtil.renderExclamation(event.getPoseStack(), screen.f_96543_ / 2 - 52, screen.f_96544_ / 2 - 40);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRenderToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null) {
            List lore = event.getToolTip();
            if (stack.m_41720_() instanceof SpearItem) {
                int index = 0;
                for (int i = 0; i < event.getToolTip().size(); ++i) {
                    TranslatableContents tcomp;
                    MutableComponent comp;
                    Object object = lore.get(i);
                    if (!(object instanceof MutableComponent) || !((object = (comp = (MutableComponent)object).m_214077_()) instanceof TranslatableContents) || !(tcomp = (TranslatableContents)object).m_237508_().equals("item.modifiers." + EquipmentSlot.MAINHAND.m_20751_())) continue;
                    index = i;
                }
                lore.add(index, Component.m_237119_());
                lore.add(index, Component.m_237110_((String)"gui.blue_skies.item.spear.thrown_damage", (Object[])new Object[]{ItemStack.f_41584_.format(ToolUtils.getProjectileDamage(8.0f, ((SpearItem)stack.m_41720_()).getStick()))}).m_130940_(ChatFormatting.DARK_GREEN));
                lore.add(index, Component.m_237115_((String)"gui.blue_skies.item.spear.when_thrown").m_130940_(ChatFormatting.GRAY));
            }
            if (stack.m_41720_() instanceof IFalsiteItem && ((IFalsiteItem)stack.m_41720_()).isFalsiteCompatible(stack) && IFalsiteItem.hasUses(stack)) {
                lore.add(1, Component.m_237110_((String)"gui.blue_skies.item.falsite_uses", (Object[])new Object[]{IFalsiteItem.getFalsiteUses(stack), IFalsiteItem.getMaxFalsiteUses(stack)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onFogRender(ViewportEvent.RenderFog event) {
        if (!SkiesClientEvents.mc.f_91074_.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !SkiesClientEvents.mc.f_91074_.isEyeInFluidType((FluidType)ForgeMod.LAVA_TYPE.get())) {
            if (snowstormStrength > 2.0f && SkiesClientEvents.mc.f_91073_.m_46472_() == SkiesDimensions.everbrightKey()) {
                RenderSystem.m_157445_((float)-8.0f);
                RenderSystem.m_157443_((float)(240.0f + -snowstormStrength));
            }
            if (sandstormStrength > -8.0f && SkiesClientEvents.mc.f_91073_.m_46472_() == SkiesDimensions.everdawnKey()) {
                RenderSystem.m_157445_((float)-8.0f);
                RenderSystem.m_157443_((float)(220.0f + -sandstormStrength));
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++clientTicks;
        ClientLevel world = SkiesClientEvents.mc.f_91073_;
        LocalPlayer player = SkiesClientEvents.mc.f_91074_;
        if (world == null || !world.f_46443_) {
            return;
        }
        if (player != null) {
            boolean everdawn;
            if (IncompatHandler.Optifine.shouldWarn && SkiesDimensions.inSkyDimension((Entity)player)) {
                player.m_5661_((Component)IncompatHandler.Optifine.SHADER_MSG, false);
                IncompatHandler.Optifine.shouldWarn = false;
            }
            SkiesPlayer.ifPresent(player, skyPlayer -> {
                skyPlayer.clientTick();
                SkiesClientEvents.dungeonAmbientSoundHandler.dungeonType = skyPlayer.getDungeonMusicId();
            });
            dungeonAmbientSoundHandler.m_7551_();
            if (SkiesDimensions.inSkyDimension((Entity)player)) {
                for (AmbientSoundHandler handler : player.f_108593_) {
                    ObjectCollection values;
                    if (!(handler instanceof BiomeAmbientSoundsHandler)) continue;
                    BiomeAmbientSoundsHandler biomeSoundHandler = (BiomeAmbientSoundsHandler)handler;
                    Object2ObjectArrayMap loopSounds = biomeSoundHandler.f_119633_;
                    if (SkiesClientEvents.dungeonAmbientSoundHandler.dungeonType != null && SkiesClientEvents.dungeonAmbientSoundHandler.dungeonType != SkiesDungeonType.NONE || player.m_20186_() + (double)player.m_20192_() < (double)(world.m_5736_() + 1)) {
                        values = loopSounds.values();
                        values.forEach(BiomeAmbientSoundsHandler.LoopSoundInstance::m_119659_);
                        values.removeIf(AbstractTickableSoundInstance::m_7801_);
                        values.removeIf(sound -> sound.m_7769_() <= 0.0f);
                        continue;
                    }
                    values = loopSounds.values();
                    values.removeIf(sound -> sound.m_7769_() <= 0.0f);
                    values.removeIf(AbstractTickableSoundInstance::m_7801_);
                    Biome biome = (Biome)player.f_19853_.m_7062_().m_204206_(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_203334_();
                    values.forEach(BiomeAmbientSoundsHandler.LoopSoundInstance::m_119659_);
                    biome.m_47563_().ifPresent(soundEvent -> loopSounds.compute((Object)biome, (b, s) -> {
                        if (s == null) {
                            s = new BiomeAmbientSoundsHandler.LoopSoundInstance(soundEvent);
                            s.f_119573_ = 0.01f;
                            mc.m_91106_().m_120367_((SoundInstance)s);
                        }
                        s.m_119660_();
                        return s;
                    }));
                }
            }
            boolean everbright = world.m_46472_() == SkiesDimensions.everbrightKey();
            boolean bl = everdawn = world.m_46472_() == SkiesDimensions.everdawnKey();
            if (!everbright && !everdawn) {
                return;
            }
            if (everbright) {
                float maxSnowStrength;
                entity = mc.m_91288_();
                blockpos = entity.m_20183_();
                float f = world.m_46470_() && ((Biome)world.m_204166_(blockpos).m_203334_()).m_47530_() != Biome.Precipitation.NONE && world.f_46440_ > 0.0f ? 210.0f : (maxSnowStrength = !world.m_46470_() && world.f_46438_ > 0.0f ? 200.0f : 200.0f);
                if ((inDungeon && world.m_45517_(LightLayer.SKY, blockpos) <= 0 || blockpos.m_123342_() < world.m_5736_() + 1) && world.m_45517_(LightLayer.SKY, blockpos) <= 0 && snowstormStrength > 2.0f || snowstormStrength > maxSnowStrength) {
                    snowstormStrength -= 1.0f;
                } else if (world.m_45517_(LightLayer.SKY, blockpos) <= 12 && snowstormStrength > 160.0f) {
                    snowstormStrength -= 1.0f;
                } else if ((blockpos.m_123342_() >= world.m_5736_() + 1 || world.m_45517_(LightLayer.SKY, blockpos) > 0) && world.m_46471_() && snowstormStrength < maxSnowStrength) {
                    snowstormStrength += 1.0f;
                } else if (snowstormStrength > 2.0f && !world.m_46471_() && snowstormStrength <= maxSnowStrength || world.f_46438_ < 1.0f && snowstormStrength > 2.0f) {
                    snowstormStrength -= 1.0f;
                }
            } else if (everdawn) {
                entity = mc.m_91288_();
                blockpos = entity.m_20183_();
                Holder biome = world.m_204166_(blockpos);
                float min = -8.0f;
                float max = 200.0f;
                if (blockpos.m_123342_() < world.m_5736_() + 1 && world.m_45517_(LightLayer.SKY, blockpos) <= 0 && sandstormStrength > min) {
                    sandstormStrength -= 1.0f;
                } else if (SkiesPlayerEvents.inBossFight((Player)player) && sandstormStrength > 10.0f && world.m_45517_(LightLayer.SKY, blockpos) <= 5 && blockpos.m_123342_() >= world.m_5736_() + 1) {
                    sandstormStrength -= 1.0f;
                } else if (world.m_45517_(LightLayer.SKY, blockpos) <= 12 && sandstormStrength > 160.0f) {
                    sandstormStrength -= 1.0f;
                } else if (world.f_46438_ > 0.0f && world.m_5962_().m_175515_(Registry.f_122885_).m_203561_(SkiesBiomeTags.HAS_SANDSTORMS).m_203333_(biome) && sandstormStrength < max) {
                    sandstormStrength += 1.0f;
                } else if (sandstormStrength > min && !world.m_5962_().m_175515_(Registry.f_122885_).m_203561_(SkiesBiomeTags.HAS_SANDSTORMS).m_203333_(biome) && sandstormStrength <= max || world.f_46438_ < 1.0f && sandstormStrength > min) {
                    sandstormStrength -= 1.0f;
                }
            }
            SkiesPlayer.ifPresent(player, skyPlayer -> {
                inDungeon = skyPlayer.getDungeonMusicId() == SkiesDungeonType.NATURE;
            });
        }
    }

    private static /* synthetic */ void lambda$openGuiEvent$3(Component bright, Component dawn, Component overworld, Button button) {
        if (SkiesPlayerEvents.spawnDimensionID == 0) {
            button.m_93666_(bright);
        } else if (SkiesPlayerEvents.spawnDimensionID == 1) {
            button.m_93666_(dawn);
        } else {
            button.m_93666_(overworld);
        }
        SkiesPlayerEvents.spawnDimensionID = SkiesPlayerEvents.spawnDimensionID < 2 ? ++SkiesPlayerEvents.spawnDimensionID : 0;
    }

    static {
        inventoryTabCount = 0;
        inDungeon = false;
        dungeonAmbientSoundHandler = new DungeonAmbientSoundHandler(SkiesClientEvents.mc.f_91074_, mc.m_91106_());
        BLUE_SKIES_ICONS = BlueSkies.locate("textures/gui/icons.png");
        UPDATE_LOGO = BlueSkies.locate("textures/gui/update_logo.png");
        EVERBRIGHT_RENDER_INFO = new EverbrightRenderInfo();
        EVERDAWN_RENDER_INFO = new EverdawnRenderInfo();
    }

    public static class Panoramas {
        private static final ResourceLocation BRIGHT_BACKGROUND = BlueSkies.locate("textures/block/dirt_grass/turquoise_dirt.png");
        private static final ResourceLocation DAWN_BACKGROUND = BlueSkies.locate("textures/block/dirt_grass/lunar_dirt.png");
        private static final ResourceLocation PANORAMA_GRADIENT = BlueSkies.locate("textures/gui/panorama/panorama_overlay.png");
        private static final ResourceLocation PANORAMA_EMPTY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
        private static Random rand = new Random();
        private static int panoramaCount = 0;
        protected static final Map<Integer, PanoramaData> PANORAMAS = new HashMap<Integer, PanoramaData>();

        protected static void setNewPanorama() {
            PanoramaData panorama = PANORAMAS.get(rand.nextInt(panoramaCount));
            TitleScreen.f_96716_ = new CubeMap(panorama.texture());
            TitleScreen.f_96718_ = panorama.overlay();
            try {
                GuiComponent.f_93096_ = panorama.menuBackground();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static void registerPanoramas() {
            Panoramas.register("calming_skies", true, true);
            Panoramas.register("snow_covered_pines", true, true);
            Panoramas.register("brisk_meadow", true, true);
            Panoramas.register("frostbitten_forest", true, false);
            Panoramas.register("peeking_ocean", true, false, BlueSkies.locate("textures/block/misc/midnight_sand.png"));
            Panoramas.register("nature_dungeon", true, false, BlueSkies.locate("textures/block/dungeon/nature_stonebrick.png"));
            Panoramas.register("shaded_woodlands", false, false);
            Panoramas.register("crystal_roughs", false, false, BlueSkies.locate("textures/block/misc/crystal_sand.png"));
            Panoramas.register("sunset_maple_forest", false, false);
            Panoramas.register("moonlit_reservoir", false, false);
            Panoramas.register("poison_dungeon", false, false, BlueSkies.locate("textures/block/dungeon/poison_stonebrick.png"));
        }

        public static void register(String panorama, boolean everbright, boolean shouldHaveGradient) {
            ResourceLocation background = everbright ? BRIGHT_BACKGROUND : DAWN_BACKGROUND;
            Panoramas.register(panorama, everbright, shouldHaveGradient, background);
        }

        public static void register(String panorama, boolean everbright, boolean shouldHaveGradient, ResourceLocation background) {
            String prefix = everbright ? "everbright/" : "everdawn/";
            String panLoc = "textures/gui/panorama/";
            ResourceLocation gradient = shouldHaveGradient ? PANORAMA_GRADIENT : PANORAMA_EMPTY;
            PANORAMAS.put(panoramaCount, new PanoramaData(BlueSkies.locate(panLoc + prefix + panorama + "/panorama"), gradient, background));
            ++panoramaCount;
        }

        private record PanoramaData(ResourceLocation texture, ResourceLocation overlay, ResourceLocation menuBackground) {
        }
    }

    public static interface InventoryButtonFactory {
        public Button create(int var1, Screen var2, boolean var3, int var4, Button.OnPress var5);
    }

    public static interface InventoryButtonFactorySound {
        public Button createWithSound(int var1, Screen var2, boolean var3, int var4, Button.OnPress var5, SoundEvent var6);
    }

    private static class EverbrightRenderInfo
    extends DimensionSpecialEffects {
        public EverbrightRenderInfo() {
            super(185.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        }

        public Vec3 m_5927_(Vec3 color, float brightness) {
            return color.m_82542_((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
        }

        public boolean m_5781_(int x, int z) {
            return false;
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            StarrySkyRenderer.BRIGHT_INSTANCE.render(ticks, partialTick, poseStack, level, camera, projectionMatrix, setupFog);
            return true;
        }

        public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
            BrightWeatherRenderer.INSTANCE.renderRainSnow(ticks, partialTick, level, lightTexture, camX, camY, camZ);
            return true;
        }

        public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
            BrightWeatherTick.INSTANCE.tick(ticks, level, mc, camera);
            return true;
        }
    }

    private static class EverdawnRenderInfo
    extends DimensionSpecialEffects.OverworldEffects {
        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            StarrySkyRenderer.DAWN_INSTANCE.render(ticks, partialTick, poseStack, level, camera, projectionMatrix, setupFog);
            return true;
        }

        public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
            DawnWeatherRenderer.INSTANCE.renderRainSnow(ticks, partialTick, level, lightTexture, camX, camY, camZ);
            return true;
        }

        public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
            DawnWeatherTick.INSTANCE.tick(ticks, level, mc, camera);
            return true;
        }
    }
}

