/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;

public class ProspectingResultPacket {
    private final Set<BlockState> blocksFound = new HashSet<BlockState>();

    public ProspectingResultPacket(Set<BlockState> blocksFound) {
        this.blocksFound.addAll(blocksFound);
    }

    public static ProspectingResultPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.m_130242_();
        HashSet<BlockState> blocks = new HashSet<BlockState>();
        for (int i = 0; i < count; ++i) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
            if (block == null) continue;
            blocks.add(block.m_49966_());
        }
        return new ProspectingResultPacket(blocks);
    }

    public static void encode(ProspectingResultPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130130_(packet.blocksFound.size());
        packet.blocksFound.forEach(block -> buffer.m_130085_(NameUtils.fromBlock((BlockState)block)));
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Component text = (Component)this.blocksFound.stream().map(state -> state.m_60734_().m_49954_()).reduce((t1, t2) -> t1.m_130946_(", ").m_7220_((Component)t2)).orElseGet(() -> TextUtil.translate("item", "prospector_hammer.no_finds"));
            player.m_213846_((Component)(!this.blocksFound.isEmpty() ? TextUtil.translate("item", "prospector_hammer.finds", text) : text));
        }
        context.get().setPacketHandled(true);
    }
}

