/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.crafting.ingredient.BlueprintIngredient;
import net.silentchaos512.gear.crafting.ingredient.CustomCompoundIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearTypeIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.CombineFragmentsRecipe;
import net.silentchaos512.gear.crafting.recipe.ConversionRecipe;
import net.silentchaos512.gear.crafting.recipe.FillRepairKitRecipe;
import net.silentchaos512.gear.crafting.recipe.GearPartSwapRecipe;
import net.silentchaos512.gear.crafting.recipe.ModKitRemovePartRecipe;
import net.silentchaos512.gear.crafting.recipe.QuickRepairRecipe;
import net.silentchaos512.gear.crafting.recipe.RepairItemRecipeFix;
import net.silentchaos512.gear.crafting.recipe.SGearDamageItemRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapedGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessCompoundPartRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessGearRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.press.MaterialPressingRecipe;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.CompoundPartSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.GearSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.CoatingSmithingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.UpgradeSmithingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedSingleItemRecipe;

public final class SgRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"silentgear");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"silentgear");
    public static final RegistryObject<RecipeType<CompoundingRecipe>> COMPOUNDING_TYPE = SgRecipes.registerType(Const.COMPOUNDING);
    public static final RegistryObject<RecipeType<FabricCompoundingRecipe>> COMPOUNDING_FABRIC_TYPE = SgRecipes.registerType(Const.COMPOUNDING_FABRIC);
    public static final RegistryObject<RecipeType<GemCompoundingRecipe>> COMPOUNDING_GEM_TYPE = SgRecipes.registerType(Const.COMPOUNDING_GEM);
    public static final RegistryObject<RecipeType<MetalCompoundingRecipe>> COMPOUNDING_METAL_TYPE = SgRecipes.registerType(Const.COMPOUNDING_METAL);
    public static final RegistryObject<RecipeType<PressingRecipe>> PRESSING_TYPE = SgRecipes.registerType(Const.PRESSING);
    public static final RegistryObject<RecipeType<SalvagingRecipe>> SALVAGING_TYPE = SgRecipes.registerType(Const.SALVAGING);
    public static final RegistryObject<RecipeSerializer<?>> COMBINE_FRAGMENTS = SgRecipes.register(Const.COMBINE_FRAGMENTS, () -> new SimpleRecipeSerializer(CombineFragmentsRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> COMPOUND_PART = SgRecipes.register(Const.COMPOUND_PART, () -> ExtendedShapelessRecipe.Serializer.basic(ShapelessCompoundPartRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> COMPOUNDING = SgRecipes.register(Const.COMPOUNDING, () -> new CompoundingRecipe.Serializer<CompoundingRecipe>(CompoundingRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> COMPOUNDING_FABRIC = SgRecipes.register(Const.COMPOUNDING_FABRIC, () -> new CompoundingRecipe.Serializer<GemCompoundingRecipe>(GemCompoundingRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> COMPOUNDING_GEM = SgRecipes.register(Const.COMPOUNDING_GEM, () -> new CompoundingRecipe.Serializer<GemCompoundingRecipe>(GemCompoundingRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> COMPOUNDING_METAL = SgRecipes.register(Const.COMPOUNDING_METAL, () -> new CompoundingRecipe.Serializer<MetalCompoundingRecipe>(MetalCompoundingRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> CONVERSION = SgRecipes.register("conversion", ConversionRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> DAMAGE_ITEM = SgRecipes.register(Const.DAMAGE_ITEM, SGearDamageItemRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> FILL_REPAIR_KIT = SgRecipes.register(Const.FILL_REPAIR_KIT, () -> new SimpleRecipeSerializer(FillRepairKitRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> MOD_KIT_REMOVE_PART = SgRecipes.register(Const.MOD_KIT_REMOVE_PART, () -> new SimpleRecipeSerializer(ModKitRemovePartRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> PRESSING = SgRecipes.register(Const.PRESSING, () -> ExtendedSingleItemRecipe.Serializer.basic((RecipeType)((RecipeType)PRESSING_TYPE.get()), PressingRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> PRESSING_MATERIAL = SgRecipes.register(Const.PRESSING_MATERIAL, () -> ExtendedSingleItemRecipe.Serializer.basic((RecipeType)((RecipeType)PRESSING_TYPE.get()), MaterialPressingRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> QUICK_REPAIR = SgRecipes.register(Const.QUICK_REPAIR, () -> new SimpleRecipeSerializer(QuickRepairRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> SALVAGING = SgRecipes.register(Const.SALVAGING, SalvagingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SALVAGING_GEAR = SgRecipes.register(Const.SALVAGING_GEAR, GearSalvagingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SALVAGING_COMPOUND_PART = SgRecipes.register(Const.SALVAGING_COMPOUND_PART, CompoundPartSalvagingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPED_GEAR = SgRecipes.register(Const.SHAPED_GEAR_CRAFTING, () -> ExtendedShapedRecipe.Serializer.basic(ShapedGearRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> SHAPELESS_GEAR = SgRecipes.register(Const.SHAPELESS_GEAR_CRAFTING, () -> ExtendedShapelessRecipe.Serializer.basic(ShapelessGearRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> SMITHING_COATING = SgRecipes.register(Const.SMITHING_COATING, CoatingSmithingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SMITHING_UPGRADE = SgRecipes.register(Const.SMITHING_UPGRADE, UpgradeSmithingRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SWAP_GEAR_PART = SgRecipes.register(Const.SWAP_GEAR_PART, () -> new SimpleRecipeSerializer(GearPartSwapRecipe::new));
    public static final RegistryObject<RecipeSerializer<?>> REPAIR_ITEM_OVERRIDE = SgRecipes.register("crafting_special_repairitem", () -> new SimpleRecipeSerializer(RepairItemRecipeFix::new));

    private SgRecipes() {
    }

    private static RegistryObject<RecipeSerializer<?>> register(String name, Supplier<RecipeSerializer<?>> serializer) {
        return SgRecipes.register(SilentGear.getId(name), serializer);
    }

    private static RegistryObject<RecipeSerializer<?>> register(ResourceLocation id, Supplier<RecipeSerializer<?>> serializer) {
        return RECIPE_SERIALIZERS.register(id.m_135815_(), serializer);
    }

    public static <T extends Recipe<?>> RegistryObject<RecipeType<T>> registerType(ResourceLocation name) {
        return RECIPE_TYPES.register(name.m_135815_(), () -> RecipeType.simple((ResourceLocation)name));
    }

    public static boolean isRepairMaterial(ItemStack gear, ItemStack materialItem) {
        MaterialInstance mat = MaterialInstance.from(materialItem);
        if (mat != null) {
            return mat.getRepairValue(gear) > 0;
        }
        return false;
    }

    static {
        CraftingHelper.register((ResourceLocation)BlueprintIngredient.Serializer.NAME, (IIngredientSerializer)BlueprintIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)GearPartIngredient.Serializer.NAME, (IIngredientSerializer)GearPartIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)GearTypeIngredient.Serializer.NAME, (IIngredientSerializer)GearTypeIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)PartMaterialIngredient.Serializer.NAME, (IIngredientSerializer)PartMaterialIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)CustomCompoundIngredient.Serializer.NAME, (IIngredientSerializer)CustomCompoundIngredient.Serializer.INSTANCE);
    }
}

