/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.init.SgBlocks;
import net.silentchaos512.gear.util.ModResourceLocation;

public class ModWorldGen {
    public static void init(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        ModResourceLocation bortName = SilentGear.getId("bort_ore");
        ModResourceLocation crimsonIronName = SilentGear.getId("crimson_iron_ore");
        ModResourceLocation azureSilverName = SilentGear.getId("azure_silver_ore");
        ModResourceLocation wildFlaxName = SilentGear.getId("wild_flax");
        ModResourceLocation wildFluffyName = SilentGear.getId("wild_fluffy");
        ConfiguredFeature bortFeature = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)SgBlocks.BORT_ORE.asBlockState()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)SgBlocks.DEEPSLATE_BORT_ORE.asBlockState())), 3));
        PlacedFeature bortPlaced = new PlacedFeature(ModWorldGen.holder(bortFeature, (RegistryOps<JsonElement>)ops, bortName), ModWorldGen.commonOrePlacement(40, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-60), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))));
        ConfiguredFeature crimsonIronFeature = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(Tags.Blocks.NETHERRACK), (BlockState)SgBlocks.CRIMSON_IRON_ORE.asBlockState()), OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(Blocks.f_50730_), (BlockState)SgBlocks.BLACKSTONE_CRIMSON_IRON_ORE.asBlockState())), 8, 0.0f));
        PlacedFeature crimsonIronPlaced = new PlacedFeature(ModWorldGen.holder(crimsonIronFeature, (RegistryOps<JsonElement>)ops, crimsonIronName), ModWorldGen.commonOrePlacement(14, PlacementUtils.f_195357_));
        ConfiguredFeature azureSilverFeature = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(Tags.Blocks.END_STONES), SgBlocks.AZURE_SILVER_ORE.asBlockState(), 6, 0.0f));
        PlacedFeature azureSilverPlaced = new PlacedFeature(ModWorldGen.holder(azureSilverFeature, (RegistryOps<JsonElement>)ops, azureSilverName), ModWorldGen.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)16), (VerticalAnchor)VerticalAnchor.m_158922_((int)92))));
        ConfiguredFeature wildFlaxFeature = new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)SgBlocks.WILD_FLAX_PLANT.get()))), List.of(), (int)32));
        PlacedFeature wildFlaxPlaced = new PlacedFeature(ModWorldGen.holder(wildFlaxFeature, (RegistryOps<JsonElement>)ops, wildFlaxName), List.of(RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        ConfiguredFeature wildFluffyFeature = new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)SgBlocks.WILD_FLUFFY_PLANT.get()))), List.of(), (int)32));
        PlacedFeature wildFluffyPlaced = new PlacedFeature(ModWorldGen.holder(wildFluffyFeature, (RegistryOps<JsonElement>)ops, wildFluffyName), List.of(RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        ImmutableMap oreFeatures = ImmutableMap.of((Object)((Object)bortName), (Object)bortFeature, (Object)((Object)crimsonIronName), (Object)crimsonIronFeature, (Object)((Object)azureSilverName), (Object)azureSilverFeature, (Object)((Object)wildFlaxName), (Object)wildFlaxFeature, (Object)((Object)wildFluffyName), (Object)wildFluffyFeature);
        ImmutableMap orePlacedFeatures = ImmutableMap.of((Object)((Object)bortName), (Object)bortPlaced, (Object)((Object)crimsonIronName), (Object)crimsonIronPlaced, (Object)((Object)azureSilverName), (Object)azureSilverPlaced, (Object)((Object)wildFlaxName), (Object)wildFlaxPlaced, (Object)((Object)wildFluffyName), (Object)wildFluffyPlaced);
        HolderSet.Named overworldBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_);
        HolderSet.Named netherBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_207612_);
        HolderSet.Named endBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215818_);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier overworldOres = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldBiomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{ModWorldGen.holderPlaced(bortPlaced, (RegistryOps<JsonElement>)ops, bortName), ModWorldGen.holderPlaced(wildFlaxPlaced, (RegistryOps<JsonElement>)ops, wildFlaxName), ModWorldGen.holderPlaced(wildFluffyPlaced, (RegistryOps<JsonElement>)ops, wildFluffyName)}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier netherOres = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)netherBiomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{ModWorldGen.holderPlaced(crimsonIronPlaced, (RegistryOps<JsonElement>)ops, crimsonIronName)}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier endOres = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)endBiomes, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{ModWorldGen.holderPlaced(azureSilverPlaced, (RegistryOps<JsonElement>)ops, azureSilverName)}), GenerationStep.Decoration.UNDERGROUND_ORES);
        JsonCodecProvider configuredFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"silentgear", (RegistryOps)ops, (ResourceKey)Registry.f_122881_, (Map)oreFeatures);
        JsonCodecProvider placedFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"silentgear", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, (Map)orePlacedFeatures);
        JsonCodecProvider biomeModifierProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"silentgear", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (Map)ImmutableMap.of((Object)((Object)SilentGear.getId("overworld_ores")), (Object)overworldOres, (Object)((Object)SilentGear.getId("nether_ores")), (Object)netherOres, (Object)((Object)SilentGear.getId("end_ores")), (Object)endOres));
        generator.m_236039_(true, (DataProvider)configuredFeatureProvider);
        generator.m_236039_(true, (DataProvider)placedFeatureProvider);
        generator.m_236039_(true, (DataProvider)biomeModifierProvider);
    }

    public static Holder<ConfiguredFeature<?, ?>> holder(ConfiguredFeature<?, ?> feature, RegistryOps<JsonElement> ops, ResourceLocation location) {
        return ops.f_206806_.m_175515_(Registry.f_122881_).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)location));
    }

    public static Holder<PlacedFeature> holderPlaced(PlacedFeature feature, RegistryOps<JsonElement> ops, ResourceLocation location) {
        return ops.f_206806_.m_175515_(Registry.f_194567_).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)location));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return ModWorldGen.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
    }
}

