/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.collection.StackList;

public class GearPartSwapRecipe
extends CustomRecipe {
    public GearPartSwapRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        StackList list = StackList.from((Container)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.m_41619_()) {
            return false;
        }
        ICoreItem item = (ICoreItem)gear.m_41720_();
        Collection others = list.allMatches(stack -> !(stack.m_41720_() instanceof ICoreItem));
        if (others.isEmpty()) {
            return false;
        }
        HashMap<PartType, Integer> typeCounts = new HashMap<PartType, Integer>();
        for (ItemStack stack2 : others) {
            PartData part = PartData.from(stack2);
            if (part == null) {
                return false;
            }
            PartType type = part.getType();
            if (!item.supportsPart(gear, part) || typeCounts.getOrDefault(type, 0) >= type.getMaxPerItem(item.getGearType())) {
                return false;
            }
            typeCounts.merge(type, 1, Integer::sum);
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv) {
        StackList list = StackList.from((Container)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Collection others = list.allMatches(stack -> !(stack.m_41720_() instanceof ICoreItem));
        if (others.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = gear.m_41777_();
        PartDataList parts = GearData.getConstructionParts(result);
        PartDataList newParts = PartDataList.of(new PartData[0]);
        for (ItemStack stack2 : others) {
            PartData part = PartData.from(stack2);
            if (part == null) {
                return ItemStack.f_41583_;
            }
            PartType type = part.getType();
            ArrayList<PartData> partsOfType = new ArrayList<PartData>(parts.getPartsOfType(type));
            int maxPerItem = type.getMaxPerItem(GearHelper.getType(result));
            if (partsOfType.size() >= maxPerItem) {
                PartData oldPart = (PartData)partsOfType.get(0);
                partsOfType.remove(oldPart);
                parts.remove(oldPart);
                oldPart.onRemoveFromGear(result);
            }
            parts.add(part);
            newParts.add(part);
        }
        GearData.writeConstructionParts(result, parts);
        GearData.removeExcessParts(result);
        GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
        newParts.forEach(p -> p.onAddToGear(result));
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack gear = StackList.from((Container)inv).uniqueMatch(s -> s.m_41720_() instanceof ICoreItem);
        PartDataList oldParts = GearData.getConstructionParts(gear);
        HashMap<PartType, Integer> removedCount = new HashMap<PartType, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() instanceof ICoreItem) {
                list.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            PartData newPart = PartData.from(stack);
            if (newPart == null || ((Boolean)Config.Common.destroySwappedParts.get()).booleanValue()) continue;
            PartType type = newPart.getType();
            List<PartData> partsOfType = oldParts.getPartsOfType(type);
            if (partsOfType.size() >= type.getMaxPerItem(GearHelper.getType(gear))) {
                int index = removedCount.getOrDefault(type, 0);
                if (index >= partsOfType.size()) continue;
                PartData oldPart = partsOfType.get(index);
                oldPart.onRemoveFromGear(gear);
                ItemStack oldPartItem = oldPart.getItem();
                if (oldPartItem.m_41720_() instanceof MainPartItem) {
                    oldPartItem.m_41721_(gear.m_41773_());
                }
                list.set(i, (Object)oldPartItem);
                removedCount.merge(type, 1, Integer::sum);
                continue;
            }
            list.set(i, (Object)ItemStack.f_41583_);
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.SWAP_GEAR_PART.get();
    }
}

